/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.builtInWebServer;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.builtInWebServer.PhpCgiService;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.PhpProjectWorkspaceConfiguration;
import com.jetbrains.php.config.PhpProjectWorkspaceConfigurationListener;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.run.PhpExecutionUtil;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import icons.PhpIcons;
import java.io.File;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.fastCgi.FastCgiService;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000]\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\r\b\u0001\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u0007H\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/jetbrains/php/builtInWebServer/PhpCgiService;", "Lorg/jetbrains/io/fastCgi/FastCgiService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "currentPhpCgiPath", "", "configurationChangedListenerAdded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "notification", "Lcom/intellij/notification/SingletonNotificationManager;", "notificationListener", "com/jetbrains/php/builtInWebServer/PhpCgiService$notificationListener$1", "Lcom/jetbrains/php/builtInWebServer/PhpCgiService$notificationListener$1;", "addConfigurationChangedListener", "", "createProcessHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "port", "", "addPhpIniParameters", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "getPhpCgiPath", "Ljava/io/File;", "configureConsole", "consoleBuilder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "getConsoleToolWindowId", "getConsoleToolWindowIcon", "Ljavax/swing/Icon;", "Companion", "intellij.php.jsDebugger"})
@SourceDebugExtension(value={"SMAP\nPhpCgiService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpCgiService.kt\ncom/jetbrains/php/builtInWebServer/PhpCgiService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,136:1\n13#2:137\n13#2:138\n13#2:139\n*S KotlinDebug\n*F\n+ 1 PhpCgiService.kt\ncom/jetbrains/php/builtInWebServer/PhpCgiService\n*L\n104#1:137\n112#1:138\n122#1:139\n*E\n"})
public final class PhpCgiService
extends FastCgiService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private volatile String currentPhpCgiPath;
    @NotNull
    private final AtomicBoolean configurationChangedListenerAdded;
    @NotNull
    private final SingletonNotificationManager notification;
    @NotNull
    private final notificationListener.1 notificationListener;

    public PhpCgiService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.configurationChangedListenerAdded = new AtomicBoolean();
        this.notification = new SingletonNotificationManager("PHP-CGI Server", NotificationType.ERROR);
        this.notificationListener = new NotificationListener.Adapter(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            protected void hyperlinkActivated(Notification notification, HyperlinkEvent e) {
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                notification.expire();
                PhpUiUtil.editConfigurable(this.$project, (Configurable)new PhpProjectConfigurable(this.$project));
            }
        };
    }

    private final void addConfigurationChangedListener() {
        if (!this.configurationChangedListenerAdded.compareAndSet(false, true)) {
            return;
        }
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        Topic<PhpProjectWorkspaceConfigurationListener> topic = PhpProjectWorkspaceConfiguration.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, () -> PhpCgiService.addConfigurationChangedListener$lambda$0(this));
    }

    @Nullable
    protected OSProcessHandler createProcessHandler(@NotNull Project project, int port) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File file = this.getPhpCgiPath(project, this.notification);
        if (file == null) {
            return null;
        }
        File phpCgi = file;
        GeneralCommandLine commandLine = new GeneralCommandLine();
        String string = this.currentPhpCgiPath = phpCgi.getPath();
        Intrinsics.checkNotNull((Object)string);
        commandLine.setExePath(string);
        this.addPhpIniParameters(project, commandLine);
        commandLine.addParameter("-e");
        commandLine.addParameter("-b");
        commandLine.addParameter(InetAddress.getLoopbackAddress().getHostAddress() + ":" + port);
        VirtualFile file2 = ProjectUtil.guessProjectDir((Project)project);
        if (file2 != null) {
            commandLine.setWorkDirectory(PathUtil.toSystemDependentName((String)file2.getPath()));
        }
        OSProcessHandler handler = new OSProcessHandler(commandLine);
        this.addConfigurationChangedListener();
        return handler;
    }

    private final void addPhpIniParameters(Project project, GeneralCommandLine commandLine) {
        String customIni;
        PhpInterpreter interpreter;
        String interpreterName = PhpProjectConfigurationFacade.getInstance(project).getProjectConfiguration().getInterpreterName();
        PhpInterpreter phpInterpreter = interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreter(interpreterName);
        String string = customIni = phpInterpreter != null ? phpInterpreter.getCustomIni() : null;
        if (StringUtil.isNotEmpty((String)customIni)) {
            String[] stringArray = new String[]{"-c", customIni};
            commandLine.addParameters(stringArray);
        }
    }

    private final File getPhpCgiPath(Project project, SingletonNotificationManager notification) {
        File phpCgi;
        String interpreterName = PhpProjectConfigurationFacade.getInstance(project).getProjectConfiguration().getInterpreterName();
        PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreter(interpreterName);
        if (interpreter == null) {
            SingletonNotificationManager singletonNotificationManager = notification;
            if (singletonNotificationManager != null) {
                String string = PhpBundle.message("php.interpreter.not.configured.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String string2 = PhpBundle.message("php.interpreter.not.configured", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                singletonNotificationManager.notify(string, string2, project, arg_0 -> PhpCgiService.getPhpCgiPath$lambda$0(this, arg_0));
            }
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(PhpCgiService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("cannot find interpreter " + interpreterName);
            return null;
        }
        if (interpreter.isRemote()) {
            SingletonNotificationManager singletonNotificationManager = notification;
            if (singletonNotificationManager != null) {
                String string = PhpBundle.message("php.interpreter.is.remote.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String string3 = PhpBundle.message("php.interpreter.is.remote.message", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                singletonNotificationManager.notify(string, string3, project, arg_0 -> PhpCgiService.getPhpCgiPath$lambda$1(this, arg_0));
            }
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(PhpCgiService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("built-in web server does not support remote interpreters: " + interpreterName);
            return null;
        }
        String home = interpreter.getPathToPhpExecutable();
        File file = phpCgi = home == null ? null : new File(PathUtil.getParentPath((String)home), PhpProjectConfigurationFacade.PHP_CGI);
        if (phpCgi == null || !phpCgi.exists()) {
            SingletonNotificationManager singletonNotificationManager = notification;
            if (singletonNotificationManager != null) {
                Object[] objectArray = new Object[]{PhpProjectConfigurationFacade.PHP_CGI};
                String string = PhpBundle.message("php.cgi.not.found.title", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String string4 = PhpBundle.message("php.cgi.not.found", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                singletonNotificationManager.notify(string, string4, project, arg_0 -> PhpCgiService.getPhpCgiPath$lambda$2(this, arg_0));
            }
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(PhpCgiService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("php-cgi not found " + interpreterName);
            return null;
        }
        return phpCgi;
    }

    protected void configureConsole(@NotNull TextConsoleBuilder consoleBuilder) {
        Intrinsics.checkNotNullParameter((Object)consoleBuilder, (String)"consoleBuilder");
        Filter[] filterArray = PhpExecutionUtil.getConsoleMessageFilters(this.getProject(), PhpPathMapper.create(this.getProject()));
        consoleBuilder.filters(Arrays.copyOf(filterArray, filterArray.length));
    }

    @NotNull
    protected String getConsoleToolWindowId() {
        return "PHP-CGI Server";
    }

    @NotNull
    protected Icon getConsoleToolWindowIcon() {
        Icon icon = PhpIcons.PhpIcon;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PhpIcon");
        return icon;
    }

    private static final void addConfigurationChangedListener$lambda$0(PhpCgiService this$0) {
        String string = this$0.currentPhpCgiPath;
        if (string == null) {
            return;
        }
        String phpCgiPath = string;
        File file = this$0.getPhpCgiPath(this$0.getProject(), null);
        if (file == null || !Intrinsics.areEqual((Object)file.getPath(), (Object)phpCgiPath)) {
            this$0.currentPhpCgiPath = null;
            this$0.getProcessHandler().reset();
        }
    }

    private static final void getPhpCgiPath$lambda$0(PhpCgiService this$0, Notification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setSuggestionType(true);
        it.setListener((NotificationListener)this$0.notificationListener);
    }

    private static final void getPhpCgiPath$lambda$1(PhpCgiService this$0, Notification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setSuggestionType(true);
        it.setListener((NotificationListener)this$0.notificationListener);
    }

    private static final void getPhpCgiPath$lambda$2(PhpCgiService this$0, Notification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setListener((NotificationListener)this$0.notificationListener);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/php/builtInWebServer/PhpCgiService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/php/builtInWebServer/PhpCgiService;", "project", "Lcom/intellij/openapi/project/Project;", "getInstance$intellij_php_jsDebugger", "intellij.php.jsDebugger"})
    @SourceDebugExtension(value={"SMAP\nPhpCgiService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpCgiService.kt\ncom/jetbrains/php/builtInWebServer/PhpCgiService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,136:1\n30#2,2:137\n*S KotlinDebug\n*F\n+ 1 PhpCgiService.kt\ncom/jetbrains/php/builtInWebServer/PhpCgiService$Companion\n*L\n37#1:137,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PhpCgiService getInstance$intellij_php_jsDebugger(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PhpCgiService> serviceClass$iv = PhpCgiService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (PhpCgiService)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

