/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.google.common.collect.ImmutableMap;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.completion.CompletionResultSetWrapper;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.completion.PhpKeywordsCompletionContributor;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.completion.PhpSmartFunctionParametersLookupElement;
import com.jetbrains.php.completion.expectedArguments.PhpExpectedFunctionArgumentLookupElement;
import com.jetbrains.php.config.PhpExtensionStatisticsManager;
import com.jetbrains.php.config.PhpExtensionsManager;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocExpectedExceptionTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocThrowsTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpCompletionSorting {
    private static final Condition<PsiElement> EXCEPTION_POSITION = Conditions.or((Condition)Catch.INSTANCEOF, (Condition)Conditions.or((Condition)PhpDocThrowsTag.INSTANCEOF, (Condition)PhpDocExpectedExceptionTag.INSTANCEOF));
    private static final Condition<PsiElement> RETURN_OR_YIELD = Conditions.or((Condition)PhpReturn.INSTANCEOF, (Condition)PhpYield.INSTANCEOF);
    private static final PhpType INT_FLOAT_TYPE = new PhpType().add(PhpType.INT).add(PhpType.FLOAT);
    private static final PhpType GENERATOR_TYPE = new PhpType().add("\\Generator");
    private static final Map<IElementType, PhpType> ASSIGNMENT_OPERATION_TYPE_TO_PHP_TYPE = ImmutableMap.builder().put((Object)PhpTokenTypes.opCONCAT_ASGN, (Object)PhpType.STRING).put((Object)PhpTokenTypes.opPLUS_ASGN, (Object)INT_FLOAT_TYPE).put((Object)PhpTokenTypes.opMINUS_ASGN, (Object)INT_FLOAT_TYPE).put((Object)PhpTokenTypes.opMUL_ASGN, (Object)INT_FLOAT_TYPE).put((Object)PhpTokenTypes.opDIV_ASGN, (Object)INT_FLOAT_TYPE).put((Object)PhpTokenTypes.opREM_ASGN, (Object)PhpType.INT).put((Object)PhpTokenTypes.opEXP_ASGN, (Object)INT_FLOAT_TYPE).put((Object)PhpTokenTypes.opBIT_AND_ASGN, (Object)PhpType.INT).put((Object)PhpTokenTypes.opBIT_OR_ASGN, (Object)PhpType.INT).put((Object)PhpTokenTypes.opBIT_XOR_ASGN, (Object)PhpType.INT).put((Object)PhpTokenTypes.opSHIFT_LEFT_ASGN, (Object)PhpType.INT).put((Object)PhpTokenTypes.opSHIFT_RIGHT_ASGN, (Object)PhpType.INT).build();
    private static final LookupElementWeigher DISPREFER_MAGIC_WEIGHER = new LookupElementWeigher("phpDispreferMagic"){

        @NotNull
        public Boolean weigh(@NotNull LookupElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            Boolean bl = element.getLookupString().startsWith("__");
            if (bl == null) {
                1.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };
    private static final LookupElementWeigher DISPREFER_NON_BUNDLED_EXTENSION = new LookupElementWeigher("phpDispreferNonBundledExtension"){

        @NotNull
        public Boolean weigh(@NotNull LookupElement element) {
            PhpNamedElement namedElement;
            if (element == null) {
                2.$$$reportNull$$$0(0);
            }
            PhpExtensionStatisticsManager.Priority priority = (namedElement = (PhpNamedElement)ObjectUtils.tryCast((Object)element.getObject(), PhpNamedElement.class)) != null ? PhpExtensionsManager.getStatisticsManagerInstance().getPriority(namedElement) : null;
            Boolean bl = priority == PhpExtensionStatisticsManager.Priority.LOW ? Boolean.TRUE : Boolean.FALSE;
            if (bl == null) {
                2.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };
    private static final LookupElementWeigher DISPREFER_SUPERGLOBALS_WEIGHER = new LookupElementWeigher("phpDispreferSuperglobals"){

        @NotNull
        public Boolean weigh(@NotNull LookupElement element) {
            PhpNamedElement namedElement;
            if (element == null) {
                3.$$$reportNull$$$0(0);
            }
            PhpNamedElement phpNamedElement = namedElement = (element = PhpCompletionSorting.unwrapLookupElement(element)) instanceof PhpLookupElement ? ((PhpLookupElement)element).getNamedElement() : null;
            if (!(namedElement instanceof Variable)) {
                Boolean bl = Boolean.FALSE;
                if (bl == null) {
                    3.$$$reportNull$$$0(1);
                }
                return bl;
            }
            String name = element.getLookupString();
            Boolean bl = PhpLangUtil.isSuperGlobal(name) || PhpLangUtil.isMagicPredefinedVariable(name) || PhpLangUtil.FILE_PREDEFINED_VARIABLES_SET.contains(name);
            if (bl == null) {
                3.$$$reportNull$$$0(2);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$3";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    };
    private static final LookupElementWeigher DISPREFER_NON_APPLICABLE_WEIGHER = new LookupElementWeigher("phpDispreferNonApplicable"){

        @NotNull
        public Boolean weigh(@NotNull LookupElement element) {
            if (element == null) {
                4.$$$reportNull$$$0(0);
            }
            Boolean bl = (element = PhpCompletionSorting.unwrapLookupElement(element)) instanceof PhpLookupElement && !((PhpLookupElement)element).isApplicable();
            if (bl == null) {
                4.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting$4";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$4";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };
    private static final LookupElementWeigher DISPREFER_CLASS_ELEMENTS = new LookupElementWeigher("phpDispreferClassElements"){

        @NotNull
        public Boolean weigh(@NotNull LookupElement element) {
            if (element == null) {
                5.$$$reportNull$$$0(0);
            }
            Boolean bl = (element = PhpCompletionSorting.unwrapLookupElement(element)) instanceof PhpLookupElement && ((PhpLookupElement)element).myIsClassElement;
            if (bl == null) {
                5.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting$5";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$5";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };
    private static final LookupElementWeigher DISPREFER_DEPRECATED_OR_INTERNAL_WEIGHER = new LookupElementWeigher("phpDispreferDeprecatedOrInternal"){

        @NotNull
        public Boolean weigh(@NotNull LookupElement element) {
            PhpNamedElement namedElement;
            if (element == null) {
                6.$$$reportNull$$$0(0);
            }
            Boolean bl = (namedElement = (PhpNamedElement)ObjectUtils.tryCast((Object)element.getObject(), PhpNamedElement.class)) != null && (namedElement.isDeprecated() || namedElement.isInternal());
            if (bl == null) {
                6.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting$6";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$6";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };
    private static final LookupElementWeigher PHP_OPENING_TAG_WEIGHER = new LookupElementWeigher("phpOpeningTag"){

        @NotNull
        public Boolean weigh(@NotNull LookupElement element) {
            if (element == null) {
                7.$$$reportNull$$$0(0);
            }
            Boolean bl = !Strings.areSameInstance((String)element.getLookupString(), (String)"php");
            if (bl == null) {
                7.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting$7";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$7";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };
    private static final LookupElementWeigher THIS_WEIGHER = new LookupElementWeigher("phpThis"){

        @NotNull
        public Boolean weigh(@NotNull LookupElement element) {
            if (element == null) {
                8.$$$reportNull$$$0(0);
            }
            Boolean bl = !"this".equals(element.getLookupString());
            if (bl == null) {
                8.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting$8";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$8";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };
    private static final LookupElementWeigher EXPECTED_FUNCTION_ARGUMENTS_WEIGHER = new LookupElementWeigher("phpPredefinedFunctionArguments"){

        @NotNull
        public Integer weigh(@NotNull LookupElement element) {
            if (element == null) {
                9.$$$reportNull$$$0(0);
            }
            if (!((element = PhpCompletionSorting.unwrapLookupElement(element)) instanceof PhpExpectedFunctionArgumentLookupElement)) {
                Integer n = Integer.MAX_VALUE;
                if (n == null) {
                    9.$$$reportNull$$$0(1);
                }
                return n;
            }
            Integer n = ((PhpExpectedFunctionArgumentLookupElement)element).getOrder();
            if (n == null) {
                9.$$$reportNull$$$0(2);
            }
            return n;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting$9";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$9";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    };
    private static final LookupElementWeigher PREFER_PHP_VERSION_CONSTANTS_IN_VERSION_COMPARE = new LookupElementWeigher("phpVersionConstantsInVersionCompare"){

        public Boolean weigh(@NotNull LookupElement element) {
            if (element == null) {
                10.$$$reportNull$$$0(0);
            }
            return !(element = PhpCompletionSorting.unwrapLookupElement(element)).getLookupString().equals("phpversion") && !element.getLookupString().equals("PHP_VERSION");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/completion/PhpCompletionSorting$10", "weigh"));
        }
    };
    private static final LookupElementWeigher MARKER_EXPECTED_FUNCTION_ARGUMENTS_WEIGHER = new LookupElementWeigher("phpMarkPredefinedFunctionArguments"){

        @Nullable
        public Boolean weigh(@NotNull LookupElement element) {
            if (element == null) {
                11.$$$reportNull$$$0(0);
            }
            if (!((element = PhpCompletionSorting.unwrapLookupElement(element)) instanceof PhpExpectedFunctionArgumentLookupElement)) {
                return null;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/completion/PhpCompletionSorting$11", "weigh"));
        }
    };
    private static final LookupElementWeigher DEFAULT_KEYWORD_IN_MATCH_EXPRESSION_WEIGHER = new LookupElementWeigher("phpDefaultKeywordInMatchExpression"){

        @Nullable
        public Boolean weigh(@NotNull LookupElement element) {
            if (element == null) {
                12.$$$reportNull$$$0(0);
            }
            if (!(element = PhpCompletionSorting.unwrapLookupElement(element)).getLookupString().equals("default")) {
                return null;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/completion/PhpCompletionSorting$12", "weigh"));
        }
    };
    private static final LookupElementWeigher PREFER_IMPORTED_CLASSES = new LookupElementWeigher("phpPreferImportedClasses"){

        @NotNull
        public Boolean weigh(@NotNull LookupElement element) {
            if (element == null) {
                13.$$$reportNull$$$0(0);
            }
            Boolean bl = !(element.getObject() instanceof PhpUse);
            if (bl == null) {
                13.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting$13";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$13";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };

    @NotNull
    public static LookupElement unwrapLookupElement(@NotNull LookupElement element) {
        if (element == null) {
            PhpCompletionSorting.$$$reportNull$$$0(0);
        }
        if (element instanceof LookupElementDecorator && !(element instanceof PrioritizedLookupElement)) {
            element = ((LookupElementDecorator)element).getDelegate();
        }
        LookupElement lookupElement = element;
        if (lookupElement == null) {
            PhpCompletionSorting.$$$reportNull$$$0(1);
        }
        return lookupElement;
    }

    private PhpCompletionSorting() {
    }

    @NotNull
    public static CompletionResultSet addPhpSorting(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        PhpModifier.State type;
        PhpMatchArm matchArm;
        if (parameters == null) {
            PhpCompletionSorting.$$$reportNull$$$0(2);
        }
        if (result == null) {
            PhpCompletionSorting.$$$reportNull$$$0(3);
        }
        CompletionSorter sorter = CompletionSorter.defaultSorter((CompletionParameters)parameters, (PrefixMatcher)result.getPrefixMatcher());
        sorter = sorter.weighBefore("prefix", new LookupElementWeigher[]{DISPREFER_CLASS_ELEMENTS});
        sorter = sorter.weighBefore("templates", new LookupElementWeigher[]{DISPREFER_SUPERGLOBALS_WEIGHER});
        sorter = sorter.weighAfter("templates", new LookupElementWeigher[]{PHP_OPENING_TAG_WEIGHER});
        sorter = sorter.weighAfter("stats", new LookupElementWeigher[]{THIS_WEIGHER});
        sorter = sorter.weighBefore("stats", new LookupElementWeigher[]{DISPREFER_NON_BUNDLED_EXTENSION});
        sorter = sorter.weighBefore("phpDispreferNonBundledExtension", new LookupElementWeigher[]{DISPREFER_NON_APPLICABLE_WEIGHER});
        sorter = sorter.weighAfter("phpThis", new LookupElementWeigher[]{DISPREFER_MAGIC_WEIGHER});
        sorter = sorter.weighAfter("phpDispreferMagic", new LookupElementWeigher[]{DISPREFER_DEPRECATED_OR_INTERNAL_WEIGHER});
        PsiElement position = parameters.getPosition().getOriginalElement();
        sorter = sorter.weighAfter("phpDispreferDeprecatedOrInternal", new LookupElementWeigher[]{new PhpPreferKeywordsByContext(position)});
        if (PhpCompletionContributor.isVersionCompareVersionArgument(parameters.getPosition())) {
            sorter = sorter.weighAfter("phpPreferKeywordsByContext", new LookupElementWeigher[]{PREFER_PHP_VERSION_CONSTANTS_IN_VERSION_COMPARE});
        }
        PhpReceiver receiver = PhpCompletionSorting.getReceiver(parameters);
        if (receiver.type != null && !receiver.type.isAmbiguous()) {
            boolean inNew = PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)NewExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF) != null;
            sorter = sorter.weighBefore("liftShorter", new LookupElementWeigher[]{new PhpReceiverTypeWeigher(receiver, inNew)});
            sorter = sorter.weighBefore("phpReceiverType", new LookupElementWeigher[]{EXPECTED_FUNCTION_ARGUMENTS_WEIGHER});
            sorter = sorter.weighAfter("phpPredefinedFunctionArguments", new LookupElementWeigher[]{MARKER_EXPECTED_FUNCTION_ARGUMENTS_WEIGHER});
        } else {
            sorter = sorter.weighBefore("liftShorter", new LookupElementWeigher[]{EXPECTED_FUNCTION_ARGUMENTS_WEIGHER});
            sorter = sorter.weighAfter("phpPredefinedFunctionArguments", new LookupElementWeigher[]{MARKER_EXPECTED_FUNCTION_ARGUMENTS_WEIGHER});
        }
        if ((matchArm = (PhpMatchArm)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)((Condition)PhpMatchArm.class::isInstance), (Condition<? super PsiElement>)Statement.INSTANCEOF)) != null) {
            sorter = sorter.weighAfter("phpMarkPredefinedFunctionArguments", new LookupElementWeigher[]{DEFAULT_KEYWORD_IN_MATCH_EXPRESSION_WEIGHER});
        }
        if (receiver.name != null) {
            sorter = sorter.weighBefore("phpThis", new LookupElementWeigher[]{new PhpReceiverNameWeigher(receiver.name, receiver.dispreferSameName)});
        }
        sorter = sorter.weighAfter("liftShorter", new LookupElementWeigher[]{PREFER_IMPORTED_CLASSES});
        PsiElement parent = position.getParent();
        if (parent instanceof MemberReference && (type = ((MemberReference)parent).getReferenceType()) != PhpModifier.State.PARENT) {
            sorter = sorter.weighAfter("phpPreferImportedClasses", new LookupElementWeigher[]{PhpMemberReferenceStateTypeWeigher.create(type)});
        }
        CompletionResultSet completionResultSet = result.withRelevanceSorter(sorter);
        if (completionResultSet == null) {
            PhpCompletionSorting.$$$reportNull$$$0(4);
        }
        return completionResultSet;
    }

    @NotNull
    private static PhpReceiver getReceiver(CompletionParameters parameters) {
        PhpReceiver receiver = PhpCompletionSorting.getReceiverInternal(parameters);
        if (receiver.type != null && PhpCompletionSorting.isStrictTypes(parameters.getPosition()) && PhpCompletionSorting.isScalarType(receiver.type)) {
            receiver.strictComparison = true;
            if (PhpType.intersects((PhpType)PhpType.FLOAT, (PhpType)receiver.type)) {
                receiver.type = new PhpType().add(receiver.type).add(PhpType.INT);
            }
        }
        PhpReceiver phpReceiver = receiver;
        if (phpReceiver == null) {
            PhpCompletionSorting.$$$reportNull$$$0(5);
        }
        return phpReceiver;
    }

    private static boolean isStrictTypes(PsiElement position) {
        PhpFile file = PhpPsiUtil.getParentOfClass(position, PhpFile.class);
        return file != null && PhpCodeInsightUtil.isStrictTypes(file);
    }

    private static boolean isScalarType(@NotNull PhpType type) {
        if (type == null) {
            PhpCompletionSorting.$$$reportNull$$$0(6);
        }
        if (PhpType.intersects((PhpType)type, (PhpType)PhpType.SCALAR)) {
            return type.filterNull().filter(PhpType.SCALAR).filter(PhpType.TRUE).isEmpty();
        }
        return false;
    }

    @NotNull
    private static PhpReceiver getReceiverInternal(CompletionParameters parameters) {
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        if (parent != null && PhpPsiUtil.isOfType(parent.getParent(), PhpElementTypes.ARRAY_VALUE)) {
            PhpReceiver phpReceiver = PhpReceiver.EMPTY;
            if (phpReceiver == null) {
                PhpCompletionSorting.$$$reportNull$$$0(7);
            }
            return phpReceiver;
        }
        Parameter parameter = PhpWorkaroundUtil.getFunctionParameter(position);
        if (parameter != null) {
            PhpType type = parameter.isVariadic() ? parameter.getType().unpluralize() : parameter.getType();
            return new PhpReceiver(PhpCompletionSorting.getGlobalType(type, position.getProject()), parameter.getName(), false);
        }
        PhpThrowExpression throwExpression = (PhpThrowExpression)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)((Condition)PhpThrowExpression.class::isInstance), (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (throwExpression != null) {
            Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)throwExpression, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            if (function != null) {
                PhpReceiver receiver = new PhpReceiver();
                PhpDocComment comment = function.getDocComment();
                if (comment != null) {
                    PhpType exceptions = new PhpType();
                    for (PhpType exception : comment.getExceptionClasses()) {
                        exceptions.add(exception);
                    }
                    receiver.type = PhpCompletionSorting.getGlobalType(exceptions, position.getProject());
                }
                receiver.name = "e";
                receiver.dispreferSameName = false;
                PhpReceiver phpReceiver = receiver;
                if (phpReceiver == null) {
                    PhpCompletionSorting.$$$reportNull$$$0(8);
                }
                return phpReceiver;
            }
            return new PhpReceiver(PhpType.THROWABLE, "", false);
        }
        Object exceptionPosition = PhpPsiUtil.getParentByCondition(position, EXCEPTION_POSITION, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (exceptionPosition != null) {
            return new PhpReceiver(PhpType.THROWABLE, "", false);
        }
        Object returnOrYield = PhpPsiUtil.getParentByCondition(position, RETURN_OR_YIELD, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (returnOrYield != null) {
            Function function = (Function)PhpPsiUtil.getParentByCondition(returnOrYield, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            if (function != null) {
                PhpType type = PhpCompletionSorting.getGlobalType(function.getType(), position.getProject());
                if (returnOrYield instanceof PhpYield) {
                    type = type.filter(GENERATOR_TYPE).unpluralize();
                }
                return new PhpReceiver(type, function.getName(), true);
            }
            PhpReceiver phpReceiver = PhpReceiver.EMPTY;
            if (phpReceiver == null) {
                PhpCompletionSorting.$$$reportNull$$$0(9);
            }
            return phpReceiver;
        }
        ForeachStatement foreach = (ForeachStatement)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)ForeachStatement.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (foreach != null && PsiTreeUtil.isAncestor((PsiElement)foreach.getArray(), (PsiElement)position, (boolean)true)) {
            return new PhpReceiver(PhpType.ARRAY_TRAVERSABLE_TYPE, "array", false);
        }
        PhpExpression expression = (PhpExpression)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        while (expression != null) {
            if (expression instanceof ParenthesizedExpression || expression instanceof NewExpression || expression instanceof PhpReference) {
                expression = (PhpExpression)PhpPsiUtil.getParentByCondition((PsiElement)expression, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
                continue;
            }
            if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.MULTIPLICATIVE_EXPRESSION)) {
                return new PhpReceiver(INT_FLOAT_TYPE, "", false);
            }
            if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.ADDITIVE_EXPRESSION)) {
                BinaryExpression be = (BinaryExpression)expression;
                if (PhpCompletionSorting.isArray(be.getLeftOperand()) || PhpCompletionSorting.isArray(be.getRightOperand())) {
                    if (be.getOperationType() == PhpTokenTypes.opPLUS) {
                        return new PhpReceiver(PhpType.ARRAY, "", false);
                    }
                    PhpReceiver phpReceiver = PhpReceiver.EMPTY;
                    if (phpReceiver == null) {
                        PhpCompletionSorting.$$$reportNull$$$0(10);
                    }
                    return phpReceiver;
                }
                return new PhpReceiver(INT_FLOAT_TYPE, "", false);
            }
            if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.CONCATENATION_EXPRESSION)) {
                return new PhpReceiver(PhpType.STRING, "", false);
            }
            if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.LOGICAL_EXPRESSION, PhpElementTypes.LITERAL_LOGICAL_EXPRESSION)) {
                return new PhpReceiver(PhpType.BOOLEAN, "", false);
            }
            if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.BIT_EXPRESSION, PhpElementTypes.SHIFT_EXPRESSION)) {
                return new PhpReceiver(PhpType.INT, "", false);
            }
            if (expression instanceof SelfAssignmentExpression) {
                IElementType operationType = ((SelfAssignmentExpression)expression).getOperationType();
                PhpType type = ASSIGNMENT_OPERATION_TYPE_TO_PHP_TYPE.get(operationType);
                return new PhpReceiver(type, "", false);
            }
            if (expression instanceof AssignmentExpression) {
                PhpPsiElement variable = ((AssignmentExpression)expression).getVariable();
                if (!(variable instanceof PhpTypedElement) || PsiTreeUtil.isAncestor((PsiElement)variable, (PsiElement)position, (boolean)false)) break;
                PhpReceiver receiver = new PhpReceiver();
                if (variable instanceof Variable) {
                    PhpType type = new PhpType().add(((Variable)variable).getDocType());
                    PsiElement originalPosition = parameters.getOriginalPosition();
                    if (originalPosition != null) {
                        for (PhpNamedElement phpNamedElement : VariableImpl.collectDeclarations(position, false, variable.getName())) {
                            if (PsiTreeUtil.isAncestor((PsiElement)phpNamedElement.getParent(), (PsiElement)originalPosition, (boolean)false)) continue;
                            type.add(phpNamedElement.getType());
                        }
                    }
                    receiver.type = PhpCompletionSorting.getGlobalType(type, position.getProject());
                } else {
                    receiver.type = PhpCompletionSorting.getGlobalType(((PhpTypedElement)variable).getType(), position.getProject());
                }
                receiver.name = variable.getName();
                receiver.dispreferSameName = !(variable instanceof FieldReference);
                PhpReceiver phpReceiver = receiver;
                if (phpReceiver == null) {
                    PhpCompletionSorting.$$$reportNull$$$0(11);
                }
                return phpReceiver;
            }
            if (expression instanceof BinaryExpression && PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.EQUALITY_EXPRESSION, PhpElementTypes.RELATIONAL_EXPRESSION)) {
                PsiElement oppositeOperand = PhpCompletionSorting.getOppositeOperand(position, (BinaryExpression)expression);
                return PhpCompletionSorting.createReceiverFromOppositeOperand(position.getProject(), oppositeOperand);
            }
            if (!(expression instanceof TernaryExpression) || PsiTreeUtil.isAncestor((PsiElement)((TernaryExpression)expression).getCondition(), (PsiElement)position, (boolean)false)) break;
            PhpPsiElement trueVariant = ((TernaryExpression)expression).getTrueVariant();
            PhpPsiElement oppositeOperand = !PsiTreeUtil.isAncestor((PsiElement)trueVariant, (PsiElement)position, (boolean)false) ? trueVariant : ((TernaryExpression)expression).getFalseVariant();
            return PhpCompletionSorting.createReceiverFromOppositeOperand(position.getProject(), (PsiElement)oppositeOperand);
        }
        PhpReceiver phpReceiver = PhpReceiver.EMPTY;
        if (phpReceiver == null) {
            PhpCompletionSorting.$$$reportNull$$$0(12);
        }
        return phpReceiver;
    }

    @NotNull
    private static PhpReceiver createReceiverFromOppositeOperand(@NotNull Project project, @Nullable PsiElement oppositeOperand) {
        if (project == null) {
            PhpCompletionSorting.$$$reportNull$$$0(13);
        }
        PhpReceiver receiver = new PhpReceiver();
        if (oppositeOperand != null) {
            if (oppositeOperand instanceof PhpTypedElement) {
                receiver.type = PhpCompletionSorting.getGlobalType(((PhpTypedElement)oppositeOperand).getType(), project);
            }
            if (oppositeOperand instanceof PhpNamedElement) {
                receiver.name = ((PhpNamedElement)oppositeOperand).getName();
                receiver.dispreferSameName = true;
            }
        }
        PhpReceiver phpReceiver = receiver;
        if (phpReceiver == null) {
            PhpCompletionSorting.$$$reportNull$$$0(14);
        }
        return phpReceiver;
    }

    private static PsiElement getOppositeOperand(PsiElement position, BinaryExpression expression) {
        return PhpCompletionContributor.unwrapOperands(expression).stream().filter(e -> !PsiTreeUtil.isAncestor((PsiElement)e, (PsiElement)position, (boolean)false)).findAny().orElse(null);
    }

    @NotNull
    private static PhpType getGlobalType(@NotNull PhpType type, @NotNull Project project) {
        if (type == null) {
            PhpCompletionSorting.$$$reportNull$$$0(15);
        }
        if (project == null) {
            PhpCompletionSorting.$$$reportNull$$$0(16);
        }
        PhpType phpType = type.global(project).filterUnknown();
        if (phpType == null) {
            PhpCompletionSorting.$$$reportNull$$$0(17);
        }
        return phpType;
    }

    private static boolean isArray(@Nullable PsiElement element) {
        PhpType type;
        return element instanceof PhpTypedElement && !(type = PhpCompletionSorting.getGlobalType(((PhpTypedElement)element).getType(), element.getProject())).isAmbiguous() && PhpType.ARRAY.isConvertibleFromGlobal(element.getProject(), type);
    }

    @NotNull
    private static PhpType getType(@NotNull LookupElement element) {
        if (element == null) {
            PhpCompletionSorting.$$$reportNull$$$0(18);
        }
        PhpType type = null;
        if (element instanceof PhpLookupElement) {
            type = ((PhpLookupElement)element).getPhpType();
        } else {
            Object object = element.getObject();
            if (object instanceof PhpTypedElement) {
                type = ((PhpTypedElement)object).getGlobalType();
            } else if (PhpCompletionSorting.isFunctionKeyword(object)) {
                type = PhpType.CALLABLE;
            }
        }
        PhpType phpType = type != null ? type.filterUnknown() : PhpType.EMPTY;
        if (phpType == null) {
            PhpCompletionSorting.$$$reportNull$$$0(19);
        }
        return phpType;
    }

    private static boolean isFunctionKeyword(Object object) {
        return object instanceof String && object.equals("function");
    }

    @Nullable
    private static Project getProject(@NotNull LookupElement element) {
        if (element == null) {
            PhpCompletionSorting.$$$reportNull$$$0(20);
        }
        if (element instanceof PhpLookupElement) {
            return ((PhpLookupElement)element).getProject();
        }
        return (Project)ObjectUtils.doIfCast((Object)element.getObject(), PsiElement.class, PsiElement::getProject);
    }

    public static CompletionResultSetWrapper wrapResult(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PhpCompletionSorting.$$$reportNull$$$0(21);
        }
        if (context == null) {
            PhpCompletionSorting.$$$reportNull$$$0(22);
        }
        if (result == null) {
            PhpCompletionSorting.$$$reportNull$$$0(23);
        }
        if (parameters.getCompletionType() == CompletionType.SMART) {
            return new FilteringCompletionResultSetWrapper(context, result, parameters);
        }
        return new DelegateCompletionResultSetWrapper(result);
    }

    public static CompletionResultSetWrapper wrapMemorableResult(CompletionParameters parameters, ProcessingContext context, CompletionResultSet result, Collection<? super String> addedFieldNames, Collection<? super String> addedMethodNames) {
        final Consumer<LookupElement> namesAdder = element -> {
            if (element instanceof PhpLookupElement) {
                PhpNamedElement namedElement = ((PhpLookupElement)((Object)element)).getNamedElement();
                if (namedElement instanceof Field) {
                    addedFieldNames.add(element.getLookupString());
                } else if (namedElement instanceof Method) {
                    addedMethodNames.add(element.getLookupString());
                }
            }
        };
        if (parameters.getCompletionType() == CompletionType.SMART) {
            return new FilteringCompletionResultSetWrapper(context, result, parameters){

                @Override
                public void addElement(@NotNull LookupElement element) {
                    if (element == null) {
                        14.$$$reportNull$$$0(0);
                    }
                    super.addElement(element);
                    namesAdder.accept(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/completion/PhpCompletionSorting$14", "addElement"));
                }
            };
        }
        return new DelegateCompletionResultSetWrapper(result){

            @Override
            public void addElement(@NotNull LookupElement element) {
                if (element == null) {
                    15.$$$reportNull$$$0(0);
                }
                super.addElement(element);
                namesAdder.accept(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/completion/PhpCompletionSorting$15", "addElement"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 7, 8, 9, 10, 11, 12, 14, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting";
                break;
            }
            case 2: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapLookupElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addPhpSorting";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReceiver";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReceiverInternal";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createReceiverFromOppositeOperand";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unwrapLookupElement";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 19: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addPhpSorting";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isScalarType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createReceiverFromOppositeOperand";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getProject";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "wrapResult";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 7, 8, 9, 10, 11, 12, 14, 17, 19 -> new IllegalStateException(string);
        };
    }

    private static final class PhpPreferKeywordsByContext
    extends LookupElementWeigher {
        private static final Condition<PsiElement> DIRECT_STATEMENT_CONDITION = Conditions.and((Condition)Conditions.not(ConstantReference.class::isInstance), (Condition)PhpExpression.INSTANCEOF);
        private static final Set<String> CLASS_LEVEL_KEYWORDS = ContainerUtil.map2Set((Object[])TokenSet.orSet((TokenSet[])new TokenSet[]{PhpKeywordsCompletionContributor.CONST_FUNCTION, PhpTokenTypes.tsMODIFIERS}).getTypes(), PhpKeywordsCompletionContributor::getString);
        private final PsiElement myPosition;

        private PhpPreferKeywordsByContext(PsiElement position) {
            super("phpPreferKeywordsByContext");
            this.myPosition = position;
        }

        @Nullable
        public Boolean weigh(@NotNull LookupElement element) {
            String object;
            if (element == null) {
                PhpPreferKeywordsByContext.$$$reportNull$$$0(0);
            }
            if ((object = (String)ObjectUtils.tryCast((Object)element.getObject(), String.class)) != null) {
                GroupStatement parentGroupStatement;
                Statement positionStatement = (Statement)PhpPsiUtil.getParentByCondition(this.myPosition, false, (Condition<? super PsiElement>)Statement.INSTANCEOF, DIRECT_STATEMENT_CONDITION);
                if ((object.equals("else") || object.equals("elseif")) && positionStatement != null && PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)positionStatement, true), PhpElementTypes.IF, PhpElementTypes.ELSE_IF)) {
                    return false;
                }
                GroupStatement groupStatement = parentGroupStatement = positionStatement != null ? (GroupStatement)ObjectUtils.tryCast((Object)positionStatement.getParent(), GroupStatement.class) : null;
                if (PhpKeywordsCompletionContributor.isReturnCompletionItem(object) && parentGroupStatement != null && PhpPsiUtil.isOfType((PsiElement)positionStatement, PhpElementTypes.STATEMENT) && ArrayUtil.getLastElement((Object[])parentGroupStatement.getStatements()) == positionStatement && PhpPsiUtil.getParentOfClass((PsiElement)positionStatement, Function.class) != null) {
                    return false;
                }
                if ((object.equals("case") || object.equals("default")) && parentGroupStatement != null && parentGroupStatement.getParent() instanceof PhpCase && PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)positionStatement, true), PhpElementTypes.RETURN, PhpElementTypes.BREAK)) {
                    return false;
                }
                if (CLASS_LEVEL_KEYWORDS.contains(object) && PhpKeywordsCompletionContributor.IN_FIELD_TYPE.accepts((Object)this.myPosition)) {
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/completion/PhpCompletionSorting$PhpPreferKeywordsByContext", "weigh"));
        }
    }

    private static class PhpReceiver {
        public static final PhpReceiver EMPTY = new PhpReceiver();
        public PhpType type;
        public String name;
        public boolean dispreferSameName;
        public boolean strictComparison;

        PhpReceiver() {
        }

        PhpReceiver(PhpType type, String name, boolean dispreferSameName) {
            this.type = type;
            this.name = name;
            this.dispreferSameName = dispreferSameName;
        }
    }

    private static final class PhpReceiverTypeWeigher
    extends LookupElementWeigher {
        private final PhpType myReceiverType;
        private final boolean myInNew;
        private final boolean myStrictComparison;

        private PhpReceiverTypeWeigher(@NotNull PhpReceiver receiver, boolean inNew) {
            if (receiver == null) {
                PhpReceiverTypeWeigher.$$$reportNull$$$0(0);
            }
            super("phpReceiverType");
            this.myReceiverType = receiver.type;
            this.myInNew = inNew;
            this.myStrictComparison = receiver.strictComparison;
        }

        @Nullable
        public TypeCompatibility weigh(@NotNull LookupElement element) {
            PhpType type;
            Object object;
            if (element == null) {
                PhpReceiverTypeWeigher.$$$reportNull$$$0(1);
            }
            if ((element = PhpCompletionSorting.unwrapLookupElement(element)) instanceof PhpSmartFunctionParametersLookupElement) {
                return TypeCompatibility.INTERSECTS;
            }
            Object object2 = object = element instanceof PhpLookupElement ? ((PhpLookupElement)element).getNamedElement() : element.getObject();
            if (!(object != null && !PhpCompletionSorting.isFunctionKeyword(object) && (!(object instanceof PhpTypedElement) || !this.myInNew && (object instanceof PhpClass || object instanceof PhpUse && PhpUseImpl.resolvesToClass((PhpUse)object))) || (type = PhpCompletionSorting.getType(element)).isAmbiguous())) {
                if (PhpType.intersects((PhpType)this.myReceiverType, (PhpType)type)) {
                    return PhpReceiverTypeWeigher.isKeywordReference(object) ? TypeCompatibility.COMPATIBLE_KEYWORD : TypeCompatibility.INTERSECTS;
                }
                Project project = PhpCompletionSorting.getProject(element);
                if (project != null) {
                    return !this.myStrictComparison && this.myReceiverType.isConvertibleFromGlobal(project, type) ? TypeCompatibility.CONVERTIBLE : TypeCompatibility.INCOMPATIBLE;
                }
            }
            return TypeCompatibility.UNKNOWN;
        }

        private static boolean isKeywordReference(Object object) {
            Constant constant;
            if (PhpCompletionSorting.isFunctionKeyword(object)) {
                return true;
            }
            return object instanceof PhpNamedElement && PhpLangUtil.isGlobalNamespaceFQN(((PhpNamedElement)object).getNamespaceName()) && object instanceof Constant && PhpLangUtil.isBuiltInConstant((constant = (Constant)object).getName(), constant.getProject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$PhpReceiverTypeWeigher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "weigh";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class PhpReceiverNameWeigher
    extends LookupElementWeigher {
        private final String myName;
        private final boolean myDispreferSameName;

        private PhpReceiverNameWeigher(@NotNull String name, boolean dispreferSameName) {
            if (name == null) {
                PhpReceiverNameWeigher.$$$reportNull$$$0(0);
            }
            super("phpReceiverName");
            this.myName = name;
            this.myDispreferSameName = dispreferSameName;
        }

        @Nullable
        public Integer weigh(@NotNull LookupElement element, @NotNull WeighingContext context) {
            if (element == null) {
                PhpReceiverNameWeigher.$$$reportNull$$$0(1);
            }
            if (context == null) {
                PhpReceiverNameWeigher.$$$reportNull$$$0(2);
            }
            int weight = 0;
            PrefixMatcher prefixMatcher = context.itemMatcher(element).cloneWithPrefix(this.myName);
            if (PhpCompletionSorting.unwrapLookupElement(element) instanceof PhpSmartFunctionParametersLookupElement) {
                return -(prefixMatcher.matchingDegree(this.myName) - 1);
            }
            for (String lookupString : element.getAllLookupStrings()) {
                if (this.myDispreferSameName && this.myName.equals(lookupString)) {
                    return 1;
                }
                weight = Math.max(weight, prefixMatcher.matchingDegree(lookupString));
            }
            return -weight;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$PhpReceiverNameWeigher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "weigh";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class PhpMemberReferenceStateTypeWeigher
    extends LookupElementWeigher {
        private static final PhpMemberReferenceStateTypeWeigher STATIC_INSTANCE = new PhpMemberReferenceStateTypeWeigher(true);
        private static final PhpMemberReferenceStateTypeWeigher DYNAMIC_INSTANCE = new PhpMemberReferenceStateTypeWeigher(false);
        private final boolean myMemberReferenceStatic;

        private PhpMemberReferenceStateTypeWeigher(boolean memberReferenceStatic) {
            super("phpMemberReferenceStateTypeWeigher");
            this.myMemberReferenceStatic = memberReferenceStatic;
        }

        @Nullable
        public Boolean weigh(@NotNull LookupElement element) {
            PhpClassMember member;
            if (element == null) {
                PhpMemberReferenceStateTypeWeigher.$$$reportNull$$$0(0);
            }
            return (member = (PhpClassMember)ObjectUtils.tryCast((Object)element.getObject(), PhpClassMember.class)) == null || member.getModifier().isStatic() != this.myMemberReferenceStatic;
        }

        private static PhpMemberReferenceStateTypeWeigher create(PhpModifier.State referenceType) {
            return referenceType == PhpModifier.State.STATIC ? STATIC_INSTANCE : DYNAMIC_INSTANCE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/completion/PhpCompletionSorting$PhpMemberReferenceStateTypeWeigher", "weigh"));
        }
    }

    private static class FilteringCompletionResultSetWrapper
    extends DelegateCompletionResultSetWrapper {
        private static final Key<PhpReceiver> PHP_RECEIVER_KEY = new Key("php.receiver");
        private final PhpType myType;
        private final PhpIndex myIndex;
        private final boolean myStrictComparison;

        private FilteringCompletionResultSetWrapper(@NotNull ProcessingContext context, @NotNull CompletionResultSet result, @NotNull CompletionParameters parameters) {
            if (context == null) {
                FilteringCompletionResultSetWrapper.$$$reportNull$$$0(0);
            }
            if (result == null) {
                FilteringCompletionResultSetWrapper.$$$reportNull$$$0(1);
            }
            if (parameters == null) {
                FilteringCompletionResultSetWrapper.$$$reportNull$$$0(2);
            }
            super(result);
            PhpReceiver receiver = (PhpReceiver)context.get(PHP_RECEIVER_KEY);
            if (receiver == null) {
                receiver = PhpCompletionSorting.getReceiver(parameters);
                context.put(PHP_RECEIVER_KEY, (Object)receiver);
            }
            this.myType = receiver.type != null ? receiver.type.filterNull().filterMixed() : PhpType.EMPTY;
            this.myStrictComparison = receiver.strictComparison;
            this.myIndex = PhpIndex.getInstance((Project)parameters.getPosition().getProject());
        }

        @Override
        public void addElement(@NotNull LookupElement element) {
            PhpType type;
            if (element == null) {
                FilteringCompletionResultSetWrapper.$$$reportNull$$$0(3);
            }
            if (!this.myType.isAmbiguous() && !(type = PhpCompletionSorting.getType(element).filterNull().filterMixed()).isAmbiguous() && !PhpType.NEVER.equals((Object)type) && (this.myStrictComparison && PhpType.intersects((PhpType)type, (PhpType)this.myType) || !this.myStrictComparison && this.myType.isConvertibleFrom(type, this.myIndex))) {
                super.addElement(element);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$FilteringCompletionResultSetWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DelegateCompletionResultSetWrapper
    implements CompletionResultSetWrapper {
        private final CompletionResultSet myResult;

        private DelegateCompletionResultSetWrapper(@NotNull CompletionResultSet result) {
            if (result == null) {
                DelegateCompletionResultSetWrapper.$$$reportNull$$$0(0);
            }
            this.myResult = result;
        }

        @Override
        public void addElement(@NotNull LookupElement element) {
            if (element == null) {
                DelegateCompletionResultSetWrapper.$$$reportNull$$$0(1);
            }
            this.myResult.addElement(element);
        }

        @Override
        public void addAllElements(@NotNull Iterable<? extends LookupElement> elements) {
            if (elements == null) {
                DelegateCompletionResultSetWrapper.$$$reportNull$$$0(2);
            }
            elements.forEach(this::addElement);
        }

        @Override
        @NotNull
        public PrefixMatcher getPrefixMatcher() {
            PrefixMatcher prefixMatcher = this.myResult.getPrefixMatcher();
            if (prefixMatcher == null) {
                DelegateCompletionResultSetWrapper.$$$reportNull$$$0(3);
            }
            return prefixMatcher;
        }

        @Override
        @NotNull
        public CompletionResultSet getResult() {
            CompletionResultSet completionResultSet = this.myResult;
            if (completionResultSet == null) {
                DelegateCompletionResultSetWrapper.$$$reportNull$$$0(4);
            }
            return completionResultSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/PhpCompletionSorting$DelegateCompletionResultSetWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/PhpCompletionSorting$DelegateCompletionResultSetWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefixMatcher";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addAllElements";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    static enum TypeCompatibility {
        COMPATIBLE_KEYWORD,
        INTERSECTS,
        CONVERTIBLE,
        UNKNOWN,
        INCOMPATIBLE;

    }
}

