/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.completion.PhpDateRepresentationFormatCharactersCompletionProvider;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class PhpFunctionStringArgumentWithDescriptionCompletionProviderBase
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        StringLiteralExpression string;
        PsiElement psiElement;
        if (parameters == null) {
            PhpFunctionStringArgumentWithDescriptionCompletionProviderBase.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpFunctionStringArgumentWithDescriptionCompletionProviderBase.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PhpFunctionStringArgumentWithDescriptionCompletionProviderBase.$$$reportNull$$$0(2);
        }
        if ((psiElement = parameters.getPosition().getParent()) instanceof StringLiteralExpression && this.isExpectedArgument(string = (StringLiteralExpression)psiElement)) {
            @NotNull List<Pair<String, @Nls String>> description = this.getLookupElementsWithDescriptions();
            int rightPad = description.stream().map(it -> ((String)it.first).length()).max(Integer::compareTo).orElse(1) + 1;
            for (int i = 0; i < description.size(); ++i) {
                Pair<String, String> entry = description.get(i);
                PhpDateRepresentationFormatCharactersCompletionProvider.addStringLookupItem(result, (String)entry.getFirst(), (String)entry.getSecond(), -i, rightPad);
            }
            result.stopHere();
        }
    }

    private boolean isExpectedArgument(StringLiteralExpression string) {
        ParameterListOwner plo;
        int index = PhpCodeInsightUtil.getParameterIndex((PsiElement)string);
        if (index >= 0 && (plo = PhpPsiUtil.getParentOfClass((PsiElement)string, ParameterListOwner.class)) instanceof FunctionReference) {
            FunctionReference call = (FunctionReference)plo;
            for (Map.Entry<String, Integer> entry : this.getFunctionFqnsWithParameterIndices().entrySet()) {
                if (index != entry.getValue() || !StringUtil.equals((CharSequence)call.getName(), (CharSequence)PhpFunctionStringArgumentWithDescriptionCompletionProviderBase.getFunctionName(entry.getKey())) || !PhpFunctionStringArgumentWithDescriptionCompletionProviderBase.isResolvedToFqn(call, entry.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract @NotNull List<Pair<String, @Nls String>> getLookupElementsWithDescriptions();

    @NotNull
    protected abstract Map<String, Integer> getFunctionFqnsWithParameterIndices();

    private static String getFunctionName(String fqn) {
        String shortName = PhpLangUtil.toShortName(fqn);
        int index = shortName.lastIndexOf(46);
        return index >= 0 ? shortName.substring(index + 1) : shortName;
    }

    private static boolean isResolvedToFqn(FunctionReference call, String fqn) {
        Collection functions = call.multiResolveStrict(Function.class);
        return !functions.isEmpty() && ContainerUtil.all((Collection)functions, f -> f.getFQN().equals(fqn));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/completion/PhpFunctionStringArgumentWithDescriptionCompletionProviderBase";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

