/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.regexp.PhpRegexpLanguage;
import com.jetbrains.php.completion.PhpDateRepresentationFormatCharactersCompletionProvider;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpRegExpPatternModifierCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final PhpRegExpPatternModifier[] MODIFIERS = new PhpRegExpPatternModifier[]{new PhpRegExpPatternModifier("i", "Case insensitive match"), new PhpRegExpPatternModifier("m", "^ and $ match start/end of line "), new PhpRegExpPatternModifier("s", "Dot matches newline"), new PhpRegExpPatternModifier("x", "Ignore whitespace"), new PhpRegExpPatternModifier("A", "Anchor to start of pattern, or at the end of the most recent match"), new PhpRegExpPatternModifier("D", "$ matches only end of pattern"), new PhpRegExpPatternModifier("U", "Make quantifiers lazy"), new PhpRegExpPatternModifier("J", "Allow duplicate subpattern names"), new PhpRegExpPatternModifier("u", "Match with full unicode")};

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        Pair phpRegExpInjection;
        StringLiteralExpression string;
        if (parameters == null) {
            PhpRegExpPatternModifierCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpRegExpPatternModifierCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PhpRegExpPatternModifierCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((string = PhpPsiUtil.getParentOfClass(parameters.getOriginalPosition(), StringLiteralExpression.class)) == null) {
            return;
        }
        List files = InjectedLanguageManager.getInstance((Project)string.getProject()).getInjectedPsiFiles((PsiElement)string);
        Pair pair = phpRegExpInjection = files != null ? (Pair)ContainerUtil.find((Iterable)files, p -> ((PsiElement)p.first).getLanguage().isKindOf((Language)PhpRegexpLanguage.INSTANCE)) : null;
        if (phpRegExpInjection == null) {
            return;
        }
        TextRange injectionRange = ((TextRange)phpRegExpInjection.getSecond()).shiftRight(string.getTextRange().getStartOffset());
        if (parameters.getOffset() > injectionRange.getEndOffset()) {
            for (PhpRegExpPatternModifier modifier : MODIFIERS) {
                PhpDateRepresentationFormatCharactersCompletionProvider.addStringLookupItem(result, modifier.myShortcut, modifier.myName, 0);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/completion/PhpRegExpPatternModifierCompletionProvider";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class PhpRegExpPatternModifier {
        private final String myShortcut;
        private final String myName;

        private PhpRegExpPatternModifier(String shortcut, String name) {
            this.myShortcut = shortcut;
            this.myName = name;
        }
    }
}

