/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion.phpunit;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocDependsTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class PhpUnitDependsCompletionContributor
extends CompletionContributor
implements DumbAware {
    public PhpUnitDependsCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PhpDocDependsTag.class), new PhpDependsCompletionProvider());
    }

    private static class PhpDependsCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpDependsCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement parent;
            PsiElement position;
            if (parameters == null) {
                PhpDependsCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpDependsCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpDependsCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpCompletionContributor.afterPhpDocRefAndStaticModifier(position = parameters.getPosition().getOriginalElement(), parent = position.getParent())) {
                PhpCompletionContributor.collectMembersOfClassByDocRef(parameters, result, position, parent, false);
                return;
            }
            PhpClass containingClass = PhpPsiUtil.getParentOfClass(position, PhpClass.class);
            if (containingClass != null && PhpUnitUtil.isTestClass(containingClass)) {
                PhpDocComment docComment = PhpPsiUtil.getParentOfClass(position, PhpDocComment.class);
                if (docComment == null) {
                    return;
                }
                Set dependencies = StreamEx.of((Object[])docComment.getTagElementsByName("@depends")).map(PhpPsiElement::getFirstPsiChild).nonNull().map(PsiElement::getText).toSet();
                Method method = (Method)ObjectUtils.tryCast((Object)PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)docComment, true), Method.class);
                ((StreamEx)StreamEx.of((Object[])containingClass.getOwnMethods()).filter(m -> method == null || m != method && !dependencies.contains(m.getName()) && PhpUnitUtil.isTestMethod(containingClass, m))).map(PhpLookupElement::new).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
                if (parameters.getInvocationCount() <= 1) {
                    result.stopHere();
                    result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.more.variants", KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion")));
                    return;
                }
                PhpCompletionContributor.addClassesAndFunctions(parameters, context, result);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/phpunit/PhpUnitDependsCompletionContributor$PhpDependsCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

