/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.addDependency;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.InstalledPackageData;
import com.jetbrains.php.composer.actions.update.ComposerAvailablePackageVersionsService;
import com.jetbrains.php.composer.actions.update.ComposerUpdateAvailabilityService;
import com.jetbrains.php.composer.addDependency.ComposerPackage;
import com.jetbrains.php.composer.addDependency.ComposerPackagesUtil;
import com.jetbrains.php.composer.addDependency.ShowPackageNamesResult;
import com.jetbrains.php.composer.execution.ComposerExecution;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddDependencyForm {
    public static final int PACKAGE_VERSION_INDENT = 4;
    private JBList<@NlsSafe String> myPackageNamesList;
    private JComboBox<@NlsSafe String> myVersionComboBox;
    private JPanel myMainPanel;
    private PackageNamesModel myPackageNamesModel;
    private FilterComponent myFilterComponent;
    private JBLabel myFilterLabel;
    private JBLabel myWarningLabel;
    private JPanel myVersionPanel;
    private JBLabel myInstalledVersionLabel;
    private JPanel myAvailablePackagesPanel;
    private JBLabel myAvailableVersionLabel;
    private JBLabel myAvailableVersionValueLabel;
    private JBLabel myLoadingLabel;
    private JBLabel myLoadPackagesErrorLabel;
    private HoverHyperlinkLabel myOutputLinkLabel;
    private final boolean myShowDefaultVersion;
    private HyperlinkListener myHyperlinkListener;
    private final Map<String, ComposerPackage> myPackagesCache;
    private final Map<String, InstalledPackageData> myInstalledPackages;
    private ComposerUpdateAvailabilityService.CheckForUpdateResult myCheckForUpdateResult;
    private final PackageNamesComparator myComparator;
    private final Project myProject;
    private final VirtualFile myConfigFile;
    private ProgressIndicator myPackagesLoadingIndicator;
    private ProgressIndicator myDescriptionLoadingIndicator;

    public AddDependencyForm(boolean showSearchLabel, boolean showDefaultVersion, final @Nullable Runnable validationChangesListener, boolean minimize, @Nullable Project project, @Nullable VirtualFile composerJson) {
        this.$$$setupUI$$$();
        this.myPackagesCache = new HashMap<String, ComposerPackage>();
        this.myInstalledPackages = new HashMap<String, InstalledPackageData>();
        this.myCheckForUpdateResult = null;
        this.myComparator = new PackageNamesComparator();
        this.myShowDefaultVersion = showDefaultVersion;
        this.myProject = project;
        this.myConfigFile = composerJson;
        this.myVersionComboBox.setEnabled(false);
        this.myFilterLabel.setLabelFor((Component)this.myFilterComponent);
        this.myFilterLabel.setVisible(showSearchLabel);
        if (validationChangesListener != null) {
            this.myPackageNamesList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    validationChangesListener.run();
                }
            });
            this.myVersionComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    validationChangesListener.run();
                }
            });
        }
        this.myPackageNamesList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<String>(){

            protected void customizeCellRenderer(@NotNull JList<? extends String> list, @NlsContexts.Label String value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    3.$$$reportNull$$$0(0);
                }
                InstalledPackageData installedPackage = AddDependencyForm.this.myInstalledPackages.get(value);
                this.append(value);
                if (installedPackage != null) {
                    String availableVersion = AddDependencyForm.this.getAvailableVersion(value);
                    if (availableVersion != null) {
                        this.setIcon(AllIcons.Nodes.UpLevel);
                        @NlsSafe String repeat = StringUtil.repeat((String)" ", (int)4);
                        this.append(repeat);
                        this.append(installedPackage.getVersion(), SimpleTextAttributes.GRAY_ATTRIBUTES);
                        this.append(", ", SimpleTextAttributes.GRAY_ATTRIBUTES);
                        this.append(PhpBundle.message("framework.composer.package.version.available.0", availableVersion), SimpleTextAttributes.GRAY_ATTRIBUTES);
                    } else {
                        this.setIcon(AllIcons.Actions.Checked);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/php/composer/addDependency/AddDependencyForm$3", "customizeCellRenderer"));
            }
        });
        this.myMainPanel.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, PhpBundle.message("framework.composer.loading.packages", new Object[0])){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        AddDependencyForm.this.myPackagesLoadingIndicator = indicator;
                        AddDependencyForm.this.initModelWithReloadedPackages(indicator);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/composer/addDependency/AddDependencyForm$4$1", "run"));
                    }
                });
                AddDependencyForm.this.myMainPanel.removeAncestorListener((AncestorListener)((Object)this));
            }
        });
        this.myPackageNamesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                final String packageName = (String)AddDependencyForm.this.myPackageNamesList.getSelectedValue();
                AddDependencyForm.this.myVersionComboBox.setEnabled(packageName != null);
                AddDependencyForm.this.myVersionComboBox.removeAllItems();
                AddDependencyForm.this.setWarning(null);
                if (packageName == null) {
                    return;
                }
                InstalledPackageData installedData = AddDependencyForm.this.myInstalledPackages.get(packageName);
                if (installedData != null) {
                    AddDependencyForm.this.applyInstalledPackageDataToUi(installedData);
                    return;
                }
                ComposerPackage aPackage = AddDependencyForm.this.myPackagesCache.get(StringUtil.toLowerCase((String)packageName));
                if (aPackage != null) {
                    AddDependencyForm.this.applyPackageDataToUiIfCorresponds(aPackage);
                    return;
                }
                AddDependencyForm.this.setLoadingStatus(true);
                if (AddDependencyForm.this.myDescriptionLoadingIndicator != null) {
                    AddDependencyForm.this.myDescriptionLoadingIndicator.cancel();
                }
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(AddDependencyForm.this.myProject, PhpBundle.message("framework.composer.loading.package.description", new Object[0])){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        AddDependencyForm.this.myDescriptionLoadingIndicator = indicator;
                        AddDependencyForm.this.myVersionComboBox.removeAllItems();
                        CardLayout layout = (CardLayout)AddDependencyForm.this.myVersionPanel.getLayout();
                        layout.show(AddDependencyForm.this.myVersionPanel, "install");
                        AddDependencyForm.this.loadPackageDataAndApplyToUi(packageName, indicator);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/composer/addDependency/AddDependencyForm$5$1", "run"));
                    }
                });
            }
        });
        this.myPackageNamesList.setFixedCellWidth(10);
        this.myPackageNamesList.setFixedCellHeight(JBUIScale.scale((int)20));
        this.myWarningLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myWarningLabel.setVisible(false);
        this.myLoadPackagesErrorLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myOutputLinkLabel.setVisible(false);
        if (minimize) {
            this.myAvailablePackagesPanel.setBorder(null);
            this.myPackageNamesList.setVisibleRowCount(6);
        }
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myMainPanel);
    }

    private void loadPackageDataAndApplyToUi(@NotNull String packageName, @NotNull ProgressIndicator indicator) {
        if (packageName == null) {
            AddDependencyForm.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            AddDependencyForm.$$$reportNull$$$0(1);
        }
        ComposerPackage aPackage = null;
        String errorMessage = null;
        try {
            aPackage = ComposerPackagesUtil.getComposerPackage(packageName, this.myProject, this.myConfigFile.getPath(), indicator);
            if (aPackage == null) {
                return;
            }
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        ComposerPackage finalAPackage = aPackage;
        String finalErrorMessage = errorMessage;
        ApplicationManager.getApplication().invokeLater(() -> {
            if (finalAPackage != null) {
                this.myPackagesCache.put(StringUtil.toLowerCase((String)finalAPackage.getName()), finalAPackage);
                this.applyPackageDataToUiIfCorresponds(finalAPackage);
                return;
            }
            this.setWarning(finalErrorMessage);
            this.setLoadingStatus(false);
        });
    }

    private void setWarning(@NlsContexts.Label String text) {
        this.myWarningLabel.setText(text);
        this.myWarningLabel.setVisible(!StringUtil.isEmpty((String)text));
    }

    private void applyInstalledPackageDataToUi(@NotNull InstalledPackageData installedData) {
        if (installedData == null) {
            AddDependencyForm.$$$reportNull$$$0(2);
        }
        String packageName = installedData.getName();
        this.myVersionComboBox.removeAllItems();
        this.myInstalledVersionLabel.setText(installedData.getVersion());
        String availableVersion = this.getAvailableVersion(packageName);
        if (availableVersion != null) {
            this.myAvailableVersionValueLabel.setText(availableVersion);
            this.myAvailableVersionValueLabel.setVisible(true);
            this.myAvailableVersionLabel.setVisible(true);
        } else {
            this.myAvailableVersionValueLabel.setVisible(false);
            this.myAvailableVersionLabel.setVisible(false);
        }
        CardLayout layout = (CardLayout)this.myVersionPanel.getLayout();
        layout.show(this.myVersionPanel, "update");
        this.setWarning(null);
    }

    private void applyPackageDataToUiIfCorresponds(@NotNull ComposerPackage aPackage) {
        if (aPackage == null) {
            AddDependencyForm.$$$reportNull$$$0(3);
        }
        String value = (String)this.myPackageNamesList.getSelectedValue();
        String packageName = aPackage.getName();
        if (!packageName.equalsIgnoreCase(value)) {
            return;
        }
        this.setLoadingStatus(false);
        this.myVersionComboBox.removeAllItems();
        List<String> versions = aPackage.getVersions();
        if (this.myShowDefaultVersion) {
            this.myVersionComboBox.addItem(AddDependencyForm.getDefaultVersion());
        }
        versions.sort(ComposerPackage.VERSIONS_COMPARATOR);
        for (String s : versions) {
            this.myVersionComboBox.addItem(s);
        }
        CardLayout layout = (CardLayout)this.myVersionPanel.getLayout();
        layout.show(this.myVersionPanel, "install");
    }

    private void createUIComponents() {
        this.myFilterComponent = new MyPackageFilter();
        this.myOutputLinkLabel = new HoverHyperlinkLabel(PhpBundle.message("framework.composer.add.dependency.show.output", new Object[0]));
    }

    private void setLoadingStatus(boolean paintBusy) {
        this.myPackageNamesList.setPaintBusy(paintBusy);
        if (paintBusy) {
            this.myPackageNamesList.setEmptyText(ApplicationBundle.message((String)"label.loading.page.please.wait", (Object[])new Object[0]));
        } else {
            this.myPackageNamesList.setEmptyText(IdeCoreBundle.message((String)"message.nothingToShow", (Object[])new Object[0]));
        }
    }

    private void checkForUpdate(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            AddDependencyForm.$$$reportNull$$$0(4);
        }
        if (this.myConfigFile == null || this.myProject == null || this.myInstalledPackages.isEmpty()) {
            return;
        }
        if (!ComposerDataService.getInstance(this.myProject).isLoadUpdateAvailability()) {
            return;
        }
        indicator.setText(PhpBundle.message("framework.composer.checking.for.update", new Object[0]));
        ApplicationManager.getApplication().invokeLater(() -> this.myLoadingLabel.setVisible(true));
        ComposerExecution execution = ComposerDataService.getInstance(this.myProject).getComposerExecution();
        ComposerUpdateAvailabilityService.CheckForUpdateResult checkForUpdateResult = ComposerUpdateAvailabilityService.executeCommand(indicator, execution, this.myProject, this.myConfigFile);
        boolean success = checkForUpdateResult.myExecutionResult.isSuccess();
        ComposerAvailablePackageVersionsService packagesVersionsService = ComposerAvailablePackageVersionsService.getInstance(this.myProject, this.myConfigFile);
        if (success && packagesVersionsService != null) {
            packagesVersionsService.updateAvailableVersions(checkForUpdateResult.myReadyToUpdatePackages);
        }
        this.myCheckForUpdateResult = checkForUpdateResult;
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!success) {
                this.showError(PhpBundle.message("framework.composer.failed.check.for.update", new Object[0]), null);
            }
            this.myLoadingLabel.setVisible(false);
            this.refreshPackagesList(true);
        });
    }

    private void initModelWithReloadedPackages(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            AddDependencyForm.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().invokeLater(() -> this.setLoadingStatus(true));
        boolean successful = this.loadPackagesNames(indicator);
        indicator.checkCanceled();
        if (successful) {
            this.checkForUpdate(indicator);
        }
        ApplicationManager.getApplication().invokeLater(() -> this.setLoadingStatus(false));
    }

    private boolean loadPackagesNames(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            AddDependencyForm.$$$reportNull$$$0(6);
        }
        this.updatePackageNamesModel(new ArrayList<String>(this.myInstalledPackages.keySet()));
        ShowPackageNamesResult showPackageNamesResult = ComposerPackagesUtil.getPackagesNames(this.myProject, this.myConfigFile, indicator);
        List<String> packageNames = showPackageNamesResult.getPackageNames();
        if (packageNames != null) {
            this.updatePackageNamesModel(packageNames);
            return true;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            @NlsSafe String error = showPackageNamesResult.getError();
            this.showError(error, showPackageNamesResult.getOutput());
        });
        return false;
    }

    private void updatePackageNamesModel(List<String> packageNames) {
        String selectedValue = (String)this.myPackageNamesList.getSelectedValue();
        packageNames.sort(this.myComparator);
        this.myPackageNamesModel = new PackageNamesModel(packageNames);
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myPackageNamesList.setModel((ListModel)((Object)this.myPackageNamesModel));
            this.myPackageNamesList.setSelectedValue((Object)selectedValue, true);
        });
    }

    private void showError(@NlsContexts.Label @Nullable String message, @Nullable String output) {
        if (output != null && message != null) {
            this.myOutputLinkLabel.setText(PhpBundle.message("framework.composer.add.dependency.show.output", new Object[0]));
            if (this.myHyperlinkListener != null) {
                this.myOutputLinkLabel.removeHyperlinkListener(this.myHyperlinkListener);
            }
            this.myHyperlinkListener = e -> this.showOutput(output, message, this.myProject);
            this.myOutputLinkLabel.addHyperlinkListener(this.myHyperlinkListener);
            this.myOutputLinkLabel.setVisible(true);
        }
        this.myLoadPackagesErrorLabel.setText(message);
        this.myLoadPackagesErrorLabel.setVisible(!StringUtil.isEmpty((String)message));
    }

    protected void showOutput(String output, @NotNull @Nls String message, Project project) {
        if (message == null) {
            AddDependencyForm.$$$reportNull$$$0(7);
        }
        ComposerUtils.createOutputPopup(output, message, "", project).showInCenterOf((Component)this.myMainPanel);
    }

    JComboBox getVersionComboBox() {
        return this.myVersionComboBox;
    }

    public ValidationInfo validate() {
        if (this.myPackageNamesModel == null || this.myWarningLabel.isVisible()) {
            return new ValidationInfo("");
        }
        Object value = this.myPackageNamesList.getSelectedValue();
        if (value == null) {
            return new ValidationInfo(PhpBundle.message("framework.composer.add.dependency.no.package.selected", new Object[0]), this.myPackageNamesList);
        }
        Object version = this.myVersionComboBox.getSelectedItem();
        if (!(version instanceof String) && !this.isSelectedPackageInstalled()) {
            return new ValidationInfo(PhpBundle.message("framework.composer.add.dependency.no.version.selected", new Object[0]), this.myVersionComboBox);
        }
        return null;
    }

    @Nullable
    public ComposerPackage getSelectedPackage() {
        String value = (String)this.myPackageNamesList.getSelectedValue();
        if (value == null) {
            return null;
        }
        return this.myPackagesCache.get(StringUtil.toLowerCase((String)value));
    }

    @Nullable
    public String getSelectedPackageName() {
        return (String)this.myPackageNamesList.getSelectedValue();
    }

    @Nullable
    public String getVersion() {
        Object value = this.myVersionComboBox.getSelectedItem();
        if (!(value instanceof String)) {
            return null;
        }
        if (this.myShowDefaultVersion && AddDependencyForm.getDefaultVersion().equals(value)) {
            return null;
        }
        return (String)value;
    }

    public void removeUpdateAvailableVersion(String packageName) {
        if (this.myCheckForUpdateResult == null) {
            return;
        }
        this.myCheckForUpdateResult.myReadyToUpdatePackages.remove(packageName);
    }

    public void dispose() {
        if (this.myPackagesLoadingIndicator != null) {
            this.myPackagesLoadingIndicator.cancel();
        }
        if (this.myDescriptionLoadingIndicator != null) {
            this.myDescriptionLoadingIndicator.cancel();
        }
    }

    public boolean isSelectedPackageInstalled() {
        String value = (String)this.myPackageNamesList.getSelectedValue();
        if (value == null) {
            return false;
        }
        return this.myInstalledPackages.containsKey(value);
    }

    public boolean isSelectedPackageUpdateAvailable() {
        String value = (String)this.myPackageNamesList.getSelectedValue();
        if (value == null) {
            return false;
        }
        if (this.myCheckForUpdateResult == null || !this.myCheckForUpdateResult.myExecutionResult.isSuccess()) {
            return true;
        }
        return this.getAvailableVersion(value) != null;
    }

    @Nullable
    public String getSelectedPackageAvailableVersion() {
        String value = (String)this.myPackageNamesList.getSelectedValue();
        if (value == null) {
            return null;
        }
        return this.getAvailableVersion(value);
    }

    @Nullable
    @NlsSafe
    private String getAvailableVersion(@NlsSafe String packageName) {
        if (this.myCheckForUpdateResult == null) {
            return null;
        }
        return this.myCheckForUpdateResult.myReadyToUpdatePackages.get(packageName);
    }

    public void addInstalledPackage(String name, String version) {
        InstalledPackageData data = new InstalledPackageData(name, version);
        this.myInstalledPackages.put(data.getName(), data);
    }

    public void removeInstalledPackage(String name) {
        this.myInstalledPackages.remove(name);
    }

    public void refreshPackagesList(boolean scrollToSelection) {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myPackageNamesList.updateUI();
            String selectedValue = (String)this.myPackageNamesList.getSelectedValue();
            this.myPackageNamesModel.sort();
            this.myPackageNamesList.clearSelection();
            this.myPackageNamesList.setSelectedValue((Object)selectedValue, scrollToSelection);
        });
    }

    @Nls
    public static String getDefaultVersion() {
        return PhpBundle.message("framework.composer.package.default.version", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/addDependency/AddDependencyForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadPackageDataAndApplyToUi";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyInstalledPackageDataToUi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "applyPackageDataToUiIfCorresponds";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForUpdate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "initModelWithReloadedPackages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "loadPackagesNames";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showOutput";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JBLabel jBLabel6;
        JPanel jPanel;
        JBList jBList;
        JPanel jPanel2;
        JBLabel jBLabel7;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.setMinimumSize(new Dimension(476, 160));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, "North");
        this.myFilterLabel = jBLabel7 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel7, DynamicBundle.getBundle((String)"messages/PhpBundle", AddDependencyForm.class).getString("composer.label.filter.packages"));
        jPanel5.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        FilterComponent filterComponent = this.myFilterComponent;
        jPanel5.add((Component)filterComponent, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, "Center");
        this.myAvailablePackagesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel6.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", AddDependencyForm.class).getString("framework.composer.add.dependency.available.packages.label"), (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(250, 100), null, null));
        this.myPackageNamesList = jBList = new JBList();
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        this.myVersionPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel6.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel7, "install");
        JBLabel jBLabel8 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel8, DynamicBundle.getBundle((String)"messages/PhpBundle", AddDependencyForm.class).getString("framework.composer.label.version.to.install"));
        jPanel7.add((Component)jBLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myVersionComboBox = jComboBox;
        jPanel7.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 7, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel8, "update");
        JBLabel jBLabel9 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel9, DynamicBundle.getBundle((String)"messages/PhpBundle", AddDependencyForm.class).getString("framework.composer.label.installed.version"));
        jPanel8.add((Component)jBLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myInstalledVersionLabel = jBLabel6 = new JBLabel();
        jPanel8.add((Component)jBLabel6, new GridConstraints(0, 1, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myLoadingLabel = jBLabel5 = new JBLabel();
        jBLabel5.setEnabled(false);
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/PhpBundle", AddDependencyForm.class).getString("framework.composer.checking.for.update"));
        jBLabel5.setVisible(false);
        jPanel8.add((Component)jBLabel5, new GridConstraints(0, 6, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAvailableVersionLabel = jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/PhpBundle", AddDependencyForm.class).getString("framework.composer.available.version"));
        jPanel8.add((Component)jBLabel4, new GridConstraints(0, 4, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myAvailableVersionValueLabel = jBLabel3 = new JBLabel();
        jPanel8.add((Component)jBLabel3, new GridConstraints(0, 5, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel9, "South");
        this.myWarningLabel = jBLabel2 = new JBLabel();
        jPanel9.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 3, null, null, null));
        this.myLoadPackagesErrorLabel = jBLabel = new JBLabel();
        jBLabel.setOpaque(true);
        jBLabel.setText("");
        jBLabel.setVisible(false);
        jPanel9.add((Component)jBLabel, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myOutputLinkLabel;
        jPanel9.add((Component)hoverHyperlinkLabel, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class PackageNamesComparator
    implements Comparator<String> {
        private PackageNamesComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            boolean installed2;
            boolean installed1 = AddDependencyForm.this.myInstalledPackages.containsKey(o1);
            if (installed1 != (installed2 = AddDependencyForm.this.myInstalledPackages.containsKey(o2))) {
                return installed1 ? -1 : 1;
            }
            return StringUtil.compare((String)o1, (String)o2, (boolean)true);
        }
    }

    private final class MyPackageFilter
    extends FilterComponent {
        private MyPackageFilter() {
            super("COMPOSER_PACKAGE_FILTER", 5);
        }

        public void filter() {
            if (AddDependencyForm.this.myPackageNamesModel != null) {
                AddDependencyForm.this.myPackageNamesModel.filter(this.getFilter());
            }
        }
    }

    private final class PackageNamesModel
    extends CollectionListModel<String> {
        private final List<String> myFilteredOut;
        private final List<String> myVisible;

        private PackageNamesModel(List<String> packageNames) {
            super(packageNames);
            this.myFilteredOut = new ArrayList<String>();
            this.myVisible = packageNames;
        }

        private void filter(String filter) {
            List<String> toProcess = this.toProcess();
            toProcess.addAll(this.myFilteredOut);
            this.myFilteredOut.clear();
            ArrayList<String> filtered = new ArrayList<String>();
            for (String aPackage : toProcess) {
                if (StringUtil.containsIgnoreCase((String)aPackage, (String)filter)) {
                    filtered.add(aPackage);
                    continue;
                }
                this.myFilteredOut.add(aPackage);
            }
            this.filter(filtered);
        }

        private void filter(List<String> filtered) {
            this.myVisible.clear();
            AddDependencyForm.this.myPackageNamesList.clearSelection();
            this.myVisible.addAll(filtered);
            this.sort();
        }

        void sort() {
            this.myVisible.sort(AddDependencyForm.this.myComparator);
            this.fireContentsChanged((Object)this, 0, this.myVisible.size());
        }

        public String getElementAt(int index) {
            return this.myVisible.get(index);
        }

        private List<String> toProcess() {
            return new ArrayList<String>(this.myVisible);
        }

        public int getSize() {
            return this.myVisible.size();
        }
    }
}

