/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.addDependency;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.ComposerCommandRunner;
import com.jetbrains.php.composer.addDependency.ComposerPackage;
import com.jetbrains.php.composer.addDependency.ShowPackageNamesResult;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.json.cache.ComposerPackagesCache;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposerPackagesUtil {
    private static final Logger LOG = Logger.getInstance(ComposerPackagesUtil.class);
    @NonNls
    public static final String PACKAGIST_URL = "https://packagist.org/";
    @NonNls
    private static final String PATH_OF_PACKAGE_NAMES_LIST = "packages/list.json";
    @NonNls
    public static final String PATH_OF_PACKAGE_DESCRIPTION = "packages/";
    public static final String CURRENT_VERSION_INDICATOR = " * ";

    private ComposerPackagesUtil() {
    }

    @NotNull
    public static ShowPackageNamesResult getPackagesNames(@Nullable Project project, @Nullable VirtualFile configFile, @NotNull ProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            ComposerPackagesUtil.$$$reportNull$$$0(0);
        }
        if (project == null || configFile == null || project.isDisposed()) {
            ShowPackageNamesResult showPackageNamesResult;
            try {
                showPackageNamesResult = ShowPackageNamesResult.success(ComposerPackagesCache.fetchOrCachePackagistList());
            }
            catch (IOException e) {
                ShowPackageNamesResult showPackageNamesResult2 = ShowPackageNamesResult.error(PhpBundle.message("frameworks.composer.could.not.get.packages.info.0", e.getMessage()), null);
                if (showPackageNamesResult2 == null) {
                    ComposerPackagesUtil.$$$reportNull$$$0(2);
                }
                return showPackageNamesResult2;
            }
            if (showPackageNamesResult == null) {
                ComposerPackagesUtil.$$$reportNull$$$0(1);
            }
            return showPackageNamesResult;
        }
        ComposerExecution execution = ComposerDataService.getInstance(project).getComposerExecution();
        ComposerCommandRunner executor = new ComposerCommandRunner(execution, project, configFile.getParent().getPath(), progressIndicator);
        CapturingProcessAdapter outputCapturingAdapter = new CapturingProcessAdapter();
        List<String> command = ComposerUtils.getShowAllPackagesCommand();
        ComposerCommandRunner.ExecutionResult executionResult = executor.runCommand(command, (ProcessListener)outputCapturingAdapter);
        if (!executionResult.isSuccess()) {
            String output = executionResult.myException != null ? executionResult.myException.getMessage() : outputCapturingAdapter.getOutput().getStderr();
            ShowPackageNamesResult showPackageNamesResult = ShowPackageNamesResult.error(PhpBundle.message("framework.composer.failed.to.load.package.names", new Object[0]), StringUtil.join(command, (String)" ") + "\n" + output);
            if (showPackageNamesResult == null) {
                ComposerPackagesUtil.$$$reportNull$$$0(3);
            }
            return showPackageNamesResult;
        }
        return ComposerPackagesUtil.parsePackageNamesFromCommandOutput(outputCapturingAdapter.getOutput().getStdout());
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ShowPackageNamesResult parsePackageNamesFromCommandOutput(@NotNull String output) {
        ShowPackageNamesResult showPackageNamesResult;
        ArrayList<String> result;
        JsonArray packageNamesArray;
        block9: {
            if (output == null) {
                ComposerPackagesUtil.$$$reportNull$$$0(4);
            }
            JsonParser parser = new JsonParser();
            packageNamesArray = ComposerPackagesUtil.getArrayElement(parser.parse(output), "available");
            result = new ArrayList<String>();
            if (packageNamesArray != null) break block9;
            ShowPackageNamesResult showPackageNamesResult2 = ShowPackageNamesResult.success(result);
            if (showPackageNamesResult2 == null) {
                ComposerPackagesUtil.$$$reportNull$$$0(5);
            }
            return showPackageNamesResult2;
        }
        try {
            for (JsonElement jsonElement : packageNamesArray) {
                if (!(jsonElement instanceof JsonObject)) {
                    throw new JsonSyntaxException("Element of `available` is not an object.");
                }
                JsonElement name = ((JsonObject)jsonElement).get("name");
                result.add(name.getAsString());
            }
            showPackageNamesResult = ShowPackageNamesResult.success(result);
        }
        catch (JsonSyntaxException e) {
            LOG.warn("Failed to parse package names.\n", (Throwable)e);
            ShowPackageNamesResult showPackageNamesResult3 = ShowPackageNamesResult.error(PhpBundle.message("framework.composer.failed.to.parse.package.names", new Object[0]), output);
            if (showPackageNamesResult3 == null) {
                ComposerPackagesUtil.$$$reportNull$$$0(7);
            }
            return showPackageNamesResult3;
        }
        if (showPackageNamesResult == null) {
            ComposerPackagesUtil.$$$reportNull$$$0(6);
        }
        return showPackageNamesResult;
    }

    @Nullable
    private static JsonArray getArrayElement(@Nullable JsonElement element, @NotNull String propertyName) {
        if (propertyName == null) {
            ComposerPackagesUtil.$$$reportNull$$$0(8);
        }
        if (!(element instanceof JsonObject)) {
            throw new JsonSyntaxException("Parsed element is not an object.");
        }
        JsonObject object = (JsonObject)element;
        JsonElement available = object.get(propertyName);
        if (available == null) {
            return null;
        }
        if (!(available instanceof JsonArray)) {
            throw new JsonSyntaxException("'" + propertyName + "' is not an array");
        }
        return (JsonArray)available;
    }

    @NotNull
    public static List<String> getPackagistPackageNames() throws IOException {
        List list = (List)ComposerPackagesUtil.loadJSON(PATH_OF_PACKAGE_NAMES_LIST, reader -> ComposerPackagesUtil.parsePackageNamesFromPackagist(reader));
        if (list == null) {
            ComposerPackagesUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private static List<String> parsePackageNamesFromPackagist(@NotNull Reader reader) throws IOException {
        ArrayList<String> arrayList;
        if (reader == null) {
            ComposerPackagesUtil.$$$reportNull$$$0(10);
        }
        JsonParser parser = new JsonParser();
        try {
            JsonArray packageNamesArray = ComposerPackagesUtil.getArrayElement(parser.parse(reader), "packageNames");
            if (packageNamesArray == null) {
                throw new JsonSyntaxException("No 'packageNames' found");
            }
            ArrayList<String> result = new ArrayList<String>();
            for (JsonElement jsonElement : packageNamesArray) {
                result.add(jsonElement.getAsString());
            }
            arrayList = result;
        }
        catch (JsonIOException e) {
            LOG.warn((Throwable)e);
            throw new IOException(PhpBundle.message("framework.composer.failed.to.load.package.names", new Object[0]));
        }
        catch (JsonSyntaxException e) {
            LOG.warn("Failed to parse package names.\n", (Throwable)e);
            throw new IOException(PhpBundle.message("framework.composer.failed.to.parse.package.names", new Object[0]));
        }
        if (arrayList == null) {
            ComposerPackagesUtil.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static <T> T loadJSON(@NonNls String path, final @NotNull ThrowableConvertor<? super Reader, ? extends T, IOException> convertor) throws IOException {
        if (convertor == null) {
            ComposerPackagesUtil.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        try {
            return (T)HttpRequests.request((String)(PACKAGIST_URL + path)).productNameAsUserAgent().connect(new HttpRequests.RequestProcessor<T>(){

                public T process(@NotNull HttpRequests.Request request) throws IOException {
                    if (request == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return convertor.convert((Object)request.getReader());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/jetbrains/php/composer/addDependency/ComposerPackagesUtil$1", "process"));
                }
            });
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
    }

    @NotNull
    public static ComposerPackage getPackagistPackage(String name) throws IOException {
        ComposerPackage composerPackage = (ComposerPackage)ComposerPackagesUtil.loadJSON(PATH_OF_PACKAGE_DESCRIPTION + StringUtil.toLowerCase((String)name) + ".json", reader -> ComposerPackagesUtil.parsePackageDescriptionJSON(name, reader));
        if (composerPackage == null) {
            ComposerPackagesUtil.$$$reportNull$$$0(13);
        }
        return composerPackage;
    }

    @Nullable
    public static ComposerPackage getComposerPackage(@NotNull String packageName, @Nullable Project project, @Nullable String configFile, @NotNull ProgressIndicator indicator) throws IOException {
        if (packageName == null) {
            ComposerPackagesUtil.$$$reportNull$$$0(14);
        }
        if (indicator == null) {
            ComposerPackagesUtil.$$$reportNull$$$0(15);
        }
        if (project == null || configFile == null) {
            return ComposerPackagesUtil.getPackagistPackage(packageName);
        }
        ComposerExecution execution = ComposerDataService.getInstance(project).getComposerExecution();
        ComposerCommandRunner executor = new ComposerCommandRunner(execution, project, PathUtil.getParentPath((String)configFile), indicator);
        CapturingProcessAdapter outputCapturingAdapter = new CapturingProcessAdapter();
        ComposerCommandRunner.ExecutionResult executionResult = executor.runCommand(ComposerUtils.getShowPackageDetailsCommand(packageName), (ProcessListener)outputCapturingAdapter);
        if (executionResult.myProgressIndicatorCancelled) {
            return null;
        }
        if (!executionResult.isSuccess()) {
            throw new IOException(PhpBundle.message("frameworks.composer.could.not.get.package.info", new Object[0]));
        }
        return ComposerPackagesUtil.parsePackageDescriptionCommandOutput(packageName, outputCapturingAdapter.getOutput().getStdout());
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static ComposerPackage parsePackageDescriptionCommandOutput(@NotNull String packageName, @NotNull String output) throws IOException {
        List<String> versions;
        if (packageName == null) {
            ComposerPackagesUtil.$$$reportNull$$$0(16);
        }
        if (output == null) {
            ComposerPackagesUtil.$$$reportNull$$$0(17);
        }
        String versionsLine = null;
        String descriptionLine = null;
        for (String line : StringUtil.splitByLines((String)output)) {
            String trimmedLine = line.trim();
            if (trimmedLine.startsWith("versions")) {
                versionsLine = trimmedLine;
            } else if (trimmedLine.startsWith("descrip.")) {
                descriptionLine = trimmedLine;
            }
            if (descriptionLine != null && versionsLine != null) break;
        }
        if ((versions = ComposerPackagesUtil.parseVersions(versionsLine)) == null) {
            throw new IOException(PhpBundle.message("framework.composer.failed.to.parse.package.description", new Object[0]));
        }
        String description = ComposerPackagesUtil.parseDescription(descriptionLine);
        if (description == null) {
            throw new IOException(PhpBundle.message("framework.composer.failed.to.parse.package.description", new Object[0]));
        }
        return new ComposerPackage(packageName, versions, description);
    }

    @Nullable
    private static String parseDescription(@Nullable String descriptionLine) {
        String description = ComposerPackagesUtil.getPropertyValue(descriptionLine);
        if (description != null && description.isEmpty()) {
            description = PhpBundle.message("framework.composer.no.description.available", new Object[0]);
        }
        return description;
    }

    @Contract(value="null -> null")
    @Nullable
    private static List<String> parseVersions(@Nullable String versionsLine) {
        String value = ComposerPackagesUtil.getPropertyValue(versionsLine);
        if (value == null) {
            return null;
        }
        Object[] versions = value.split(",");
        return ContainerUtil.map((Object[])versions, version -> StringUtil.trimStart((String)version, (String)CURRENT_VERSION_INDICATOR).trim());
    }

    @Contract(value="null -> null")
    @Nullable
    private static String getPropertyValue(String line) {
        if (line == null) {
            return null;
        }
        int semicolonIndex = line.indexOf(":");
        if (semicolonIndex == -1) {
            return null;
        }
        return line.substring(semicolonIndex + 1);
    }

    @NotNull
    public static ComposerPackage parsePackageDescriptionJSON(String name, @NotNull Reader json) throws IOException {
        if (json == null) {
            ComposerPackagesUtil.$$$reportNull$$$0(18);
        }
        JsonParser parser = new JsonParser();
        try {
            Set versions;
            JsonElement element = parser.parse(json);
            if (!(element instanceof JsonObject)) {
                throw new JsonSyntaxException("Parsed element is not an object.");
            }
            JsonObject object = (JsonObject)element;
            JsonElement aPackage = object.get("package");
            if (aPackage == null) {
                throw new JsonSyntaxException("No package found");
            }
            if (!(aPackage instanceof JsonObject)) {
                throw new JsonSyntaxException("package is not an object");
            }
            JsonObject packageObject = (JsonObject)aPackage;
            JsonElement nameElement = packageObject.get("name");
            if (nameElement == null) {
                throw new JsonSyntaxException("No name found");
            }
            String nameText = nameElement.getAsString();
            JsonElement descriptionElement = packageObject.get("description");
            if (descriptionElement == null) {
                throw new JsonSyntaxException("No description found");
            }
            String descriptionText = descriptionElement instanceof JsonNull ? PhpBundle.message("framework.composer.no.description.available", new Object[0]) : descriptionElement.getAsString();
            long downloads = 0L;
            JsonObject downloadsObject = (JsonObject)packageObject.get("downloads");
            if (downloadsObject != null) {
                downloads = downloadsObject.get("total").getAsLong();
            }
            long stars = 0L;
            JsonElement starsElement = packageObject.get("github_stars");
            if (starsElement != null && starsElement.isJsonPrimitive()) {
                stars = starsElement.getAsLong();
            }
            String sources = null;
            JsonElement repoElement = packageObject.get("repository");
            if (repoElement != null && !repoElement.isJsonNull() && repoElement.isJsonPrimitive()) {
                sources = repoElement.getAsString();
            }
            String homePage = null;
            JsonElement versionsElement = packageObject.get("versions");
            if (versionsElement == null) {
                versions = Collections.emptySet();
            } else if (versionsElement instanceof JsonArray) {
                JsonArray versionsArray = (JsonArray)versionsElement;
                versions = new HashSet();
                for (JsonElement jsonElement : versionsArray) {
                    versions.add(jsonElement.getAsString());
                }
            } else if (versionsElement instanceof JsonObject) {
                JsonObject versionsObject = (JsonObject)versionsElement;
                versions = new HashSet();
                for (Map.Entry entry : versionsObject.entrySet()) {
                    JsonElement homepageElement;
                    JsonElement value;
                    versions.add((String)entry.getKey());
                    if (homePage == null && (value = (JsonElement)entry.getValue()) instanceof JsonObject && (homepageElement = ((JsonObject)value).get("homepage")) != null && !homepageElement.isJsonNull() && homepageElement.isJsonPrimitive()) {
                        homePage = homepageElement.getAsString();
                    }
                    ComposerPackagesUtil.addAliasesToVersions((JsonElement)entry.getValue(), versions);
                }
            } else {
                throw new JsonSyntaxException("versions is not an object nor array");
            }
            return new ComposerPackage(nameText, new ArrayList<String>(versions), descriptionText, downloads, stars, homePage, sources);
        }
        catch (JsonIOException e) {
            LOG.warn((Throwable)e);
            throw new IOException(PhpBundle.message("framework.composer.failed.to.load.package.names", new Object[0]));
        }
        catch (JsonSyntaxException e) {
            LOG.warn("Failed to parse package description for " + name + ". Text:\n" + String.valueOf(json));
            LOG.warn((Throwable)e);
            throw new IOException(PhpBundle.message("framework.composer.failed.to.parse.package.description", new Object[0]));
        }
    }

    private static void addAliasesToVersions(JsonElement value, Set<? super String> versions) {
        if (!(value instanceof JsonObject)) {
            return;
        }
        JsonElement extraElement = ((JsonObject)value).get("extra");
        if (!(extraElement instanceof JsonObject)) {
            return;
        }
        JsonElement branchAliasElement = ((JsonObject)extraElement).get("branch-alias");
        if (!(branchAliasElement instanceof JsonObject)) {
            return;
        }
        for (Map.Entry entry : ((JsonObject)branchAliasElement).entrySet()) {
            JsonElement aliasElement = (JsonElement)entry.getValue();
            if (!(aliasElement instanceof JsonPrimitive)) continue;
            versions.add(aliasElement.getAsString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6, 7, 9, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/addDependency/ComposerPackagesUtil";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/addDependency/ComposerPackagesUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesNames";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePackageNamesFromCommandOutput";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagistPackageNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePackageNamesFromPackagist";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagistPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPackagesNames";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageNamesFromCommandOutput";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getArrayElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageNamesFromPackagist";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadJSON";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getComposerPackage";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageDescriptionCommandOutput";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageDescriptionJSON";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6, 7, 9, 11, 13 -> new IllegalStateException(string);
        };
    }
}

