/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.json;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.configData.ComposerConfigClient;
import com.jetbrains.php.composer.configData.PackageComposerConfigClient;
import com.jetbrains.php.composer.json.PhpComposerJsonUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ComposerOpenSettingsLineMarkerProvider
implements LineMarkerProvider {
    @NonNls
    private static final String PHP = "php";

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            ComposerOpenSettingsLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (!(element instanceof LeafPsiElement)) {
            return null;
        }
        if (!PhpComposerJsonUtils.insideComposerJson((PsiElement)element.getContainingFile())) {
            return null;
        }
        if (!PhpComposerJsonUtils.insidePackagesSection(element) || !PhpComposerJsonUtils.insidePropertyKey(element)) {
            return null;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)StringUtilRt.unquoteString((String)element.getText()), (CharSequence)PHP)) {
            return new LineMarkerInfo(element, element.getTextRange(), AllIcons.General.Settings, s -> PhpBundle.message("composer.json.open.tool.settings.intention", new Object[0]), (e, elt) -> ComposerLogMessageBuilder.Settings.PHP.show(elt.getProject()), GutterIconRenderer.Alignment.LEFT);
        }
        PackageComposerConfigClient client = ComposerConfigClient.EP_NAME.getExtensionList().stream().filter(PackageComposerConfigClient.class::isInstance).filter(i -> ((PackageComposerConfigClient)i).getFrameworkPackage().equals(StringUtilRt.unquoteString((String)element.getText()))).findAny().orElse(null);
        if (client == null || client.getSettings() == null) {
            return null;
        }
        @NotNull PsiElement element1 = element;
        ComposerLogMessageBuilder.Settings settings = client.getSettings();
        return new LineMarkerInfo(element1, element1.getTextRange(), AllIcons.General.Settings, s -> PhpBundle.message("composer.json.open.tool.settings.intention", new Object[0]), (e, elt) -> settings.show(elt.getProject()), GutterIconRenderer.Alignment.LEFT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/composer/json/ComposerOpenSettingsLineMarkerProvider", "getLineMarkerInfo"));
    }
}

