/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpClassWithMethodChooserForm {
    protected final TextFieldWithCompletion myMethodTextField;
    protected final TextFieldWithCompletion myClassTextField;
    protected JPanel myPanel;
    protected JBLabel myMethodLabelPanel;
    protected JPanel myClassFqnTextFieldWrapperPanel;
    protected JPanel myFunctionTextFieldWrapperPanel;

    public JPanel getPanel() {
        return this.myPanel;
    }

    public PhpClassWithMethodChooserForm(Project project, Disposable disposable) {
        this.$$$setupUI$$$();
        this.myMethodTextField = this.createMethodTextField(project, disposable);
        this.myFunctionTextFieldWrapperPanel.add((Component)this.myMethodTextField);
        this.myClassTextField = this.createClassTextField(project, disposable);
        this.myClassFqnTextFieldWrapperPanel.add((Component)this.myClassTextField);
    }

    public Stream<PhpClass> selectedClasses(PhpIndex index) {
        return index.getAnyByFQN(this.getClassFqn()).stream().filter(this::suggestClass);
    }

    @Nullable
    public ValidationInfo validate(@NotNull PhpIndex index) {
        ValidationInfo classTextValidation;
        if (index == null) {
            PhpClassWithMethodChooserForm.$$$reportNull$$$0(0);
        }
        if ((classTextValidation = this.validateClassText(index)) != null) {
            return classTextValidation;
        }
        ValidationInfo methodTextValidation = this.validateMethodText(index);
        if (methodTextValidation != null) {
            return methodTextValidation;
        }
        return null;
    }

    @NotNull
    protected TextFieldWithCompletion createClassTextField(Project project, Disposable disposable) {
        final PhpIndex index = PhpIndex.getInstance((Project)project);
        TextFieldWithCompletion field = new TextFieldWithCompletion(project, (TextCompletionProvider)new PhpCompletionUtil.PhpFullyQualifiedNameTextFieldCompletionProvider(){

            @Override
            protected void addCompletionVariants(@NotNull String namespaceName, @NotNull String prefix, @NotNull CompletionResultSet result) {
                if (namespaceName == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (prefix == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                PhpClassWithMethodChooserForm.this.suggestClasses(namespaceName, prefix, result, index);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "namespaceName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "prefix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/config/PhpClassWithMethodChooserForm$1";
                objectArray[2] = "addCompletionVariants";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, "", true, true, false);
        PhpCompletionUtil.installAutoCompletionAfterNamespaceSeparator((EditorTextField)field, disposable);
        field.setText("");
        TextFieldWithCompletion textFieldWithCompletion = field;
        if (textFieldWithCompletion == null) {
            PhpClassWithMethodChooserForm.$$$reportNull$$$0(1);
        }
        return textFieldWithCompletion;
    }

    @NotNull
    protected TextFieldWithCompletion createMethodTextField(Project project, Disposable disposable) {
        final PhpIndex index = PhpIndex.getInstance((Project)project);
        TextFieldWithCompletion field = new TextFieldWithCompletion(project, (TextCompletionProvider)new PhpCompletionUtil.PhpFullyQualifiedNameTextFieldCompletionProvider(){

            @Override
            protected void addCompletionVariants(@NotNull String namespaceName, @NotNull String prefix, @NotNull CompletionResultSet result) {
                String classFqn;
                if (namespaceName == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (prefix == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (!(classFqn = PhpClassWithMethodChooserForm.this.myClassTextField.getText()).isEmpty()) {
                    PhpClassWithMethodChooserForm.this.suggestMethodsForSelectedClass(index, result);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "namespaceName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "prefix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/config/PhpClassWithMethodChooserForm$2";
                objectArray[2] = "addCompletionVariants";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, "", true, true, false);
        PhpCompletionUtil.installAutoCompletionAfterNamespaceSeparator((EditorTextField)field, disposable);
        TextFieldWithCompletion textFieldWithCompletion = field;
        if (textFieldWithCompletion == null) {
            PhpClassWithMethodChooserForm.$$$reportNull$$$0(2);
        }
        return textFieldWithCompletion;
    }

    private void suggestClasses(String namespaceName, String prefix, CompletionResultSet result, PhpIndex index) {
        String namespace = PhpLangUtil.toFQN(namespaceName);
        Predicate<PhpClass> predicate = clazz -> this.suggestClass((PhpClass)clazz) && (namespaceName.isEmpty() || PhpCompletionUtil.hasNamespace((PhpNamedElement)clazz, namespace)) && !PhpLangUtil.equalsClassNames("\\___PHPSTORM_HELPERS\\", clazz.getNamespaceName());
        PhpCompletionUtil.addClasses(index, (PrefixMatcher)new CamelHumpMatcher(prefix), predicate, c -> result.addElement((LookupElement)PhpClassWithMethodChooserForm.createLookupElement((PhpNamedElement)c, this.myClassTextField)));
    }

    protected boolean suggestClass(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpClassWithMethodChooserForm.$$$reportNull$$$0(3);
        }
        return true;
    }

    protected boolean suggestFunction(@NotNull Function function) {
        if (function == null) {
            PhpClassWithMethodChooserForm.$$$reportNull$$$0(4);
        }
        return true;
    }

    public void setClassText(String value) {
        this.myClassTextField.setText(value);
    }

    public void setMethodText(String value) {
        this.myMethodTextField.setText(value);
    }

    @NotNull
    public static PhpLookupElement createLookupElement(final PhpNamedElement namedElement, final TextFieldWithCompletion textField) {
        return new PhpLookupElement(namedElement){

            @Override
            public void handleInsert(@NotNull InsertionContext context) {
                if (context == null) {
                    3.$$$reportNull$$$0(0);
                }
                textField.setText(namedElement.getFQN());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/php/config/PhpClassWithMethodChooserForm$3", "handleInsert"));
            }
        };
    }

    @NotNull
    public String getClassFqn() {
        String string = this.myClassTextField.getText();
        if (string == null) {
            PhpClassWithMethodChooserForm.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getMethodText() {
        String string = this.myMethodTextField.getText();
        if (string == null) {
            PhpClassWithMethodChooserForm.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected void suggestMethodsForSelectedClass(PhpIndex index, @NotNull CompletionResultSet result) {
        PhpClass selectedClass;
        if (result == null) {
            PhpClassWithMethodChooserForm.$$$reportNull$$$0(7);
        }
        if ((selectedClass = (PhpClass)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> this.selectedClasses(index).findFirst().orElse(null))) != null) {
            for (Method method : selectedClass.getOwnMethods()) {
                if (!this.suggestFunction((Function)method)) continue;
                result.addElement((LookupElement)new PhpLookupElement((PhpNamedElement)method));
            }
        }
    }

    protected ValidationInfo validateClassText(PhpIndex index) {
        String classFqn = this.getClassFqn();
        if (!DumbService.getInstance((Project)this.myClassTextField.getProject()).isDumb() && !classFqn.isEmpty() && this.selectedClasses(index).findAny().isEmpty()) {
            return new ValidationInfo(PhpBundle.message("custom.format.functions.dialog.validation.class.not.found", classFqn), (JComponent)this.myClassTextField);
        }
        return null;
    }

    @Nullable
    protected ValidationInfo validateMethodText(PhpIndex index) {
        String classFqn = this.getClassFqn();
        String methodText = this.getMethodText();
        if (!classFqn.isEmpty() && !DumbService.getInstance((Project)this.myClassTextField.getProject()).isDumb() && this.selectedClasses(index).noneMatch(c -> c.findMethodByName((CharSequence)methodText) != null)) {
            return new ValidationInfo(PhpBundle.message("custom.format.functions.dialog.validation.method.not.found", methodText, PhpLangUtil.toShortName(classFqn)), (JComponent)this.myMethodTextField);
        }
        return null;
    }

    public void setPreferedMethodFieldWidth(int width) {
        this.myMethodTextField.setPreferredWidth(width);
    }

    public void setPreferedClassFieldWidth(int width) {
        this.myClassTextField.setPreferredWidth(width);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/PhpClassWithMethodChooserForm";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/PhpClassWithMethodChooserForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassTextField";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodTextField";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassFqn";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "suggestClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "suggestFunction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suggestMethodsForSelectedClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setHorizontalAlignment(10);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpClassWithMethodChooserForm.class).getString("label.class.fqn"));
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClassFqnTextFieldWrapperPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMethodLabelPanel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpClassWithMethodChooserForm.class).getString("label.method.name"));
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFunctionTextFieldWrapperPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

