/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.commandLine;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.interpreters.PhpConfigurationOptionData;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterConfigurationActivity;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.run.PhpConfigurationOption;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCommandSettingsBuilder {
    private static final Function<PhpConfigurationOptionData, PhpConfigurationOption> CONFIGURATION_OPTION_ADAPTER = configurationOption -> new PhpConfigurationOption(configurationOption.getName(), configurationOption.getValue());
    @NotNull
    protected final Project myProject;
    @Nullable
    protected final PhpInterpreter myInterpreter;
    private boolean myLoadDebugExtension;
    private boolean myStartDebugger;

    public PhpCommandSettingsBuilder(@NotNull Project project, @NotNull PhpInterpreter interpreter) {
        if (project == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(0);
        }
        if (interpreter == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(1);
        }
        this.myLoadDebugExtension = false;
        this.myStartDebugger = false;
        this.myProject = project;
        this.myInterpreter = interpreter;
    }

    public PhpCommandSettingsBuilder(@NotNull Project project) {
        if (project == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(2);
        }
        this.myLoadDebugExtension = false;
        this.myStartDebugger = false;
        this.myProject = project;
        this.myInterpreter = PhpProjectConfigurationFacade.getInstance(project).getInterpreter();
    }

    @NotNull
    public PhpCommandSettingsBuilder loadDebugExtension() {
        this.myLoadDebugExtension = true;
        PhpCommandSettingsBuilder phpCommandSettingsBuilder = this;
        if (phpCommandSettingsBuilder == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(3);
        }
        return phpCommandSettingsBuilder;
    }

    @NotNull
    public PhpCommandSettingsBuilder loadAndStartDebug(boolean startDebugger) {
        this.myLoadDebugExtension = startDebugger;
        this.myStartDebugger = startDebugger;
        PhpCommandSettingsBuilder phpCommandSettingsBuilder = this;
        if (phpCommandSettingsBuilder == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(4);
        }
        return phpCommandSettingsBuilder;
    }

    @NotNull
    public PhpCommandSettingsBuilder loadAndStartDebug() {
        PhpCommandSettingsBuilder phpCommandSettingsBuilder = this.loadAndStartDebug(true);
        if (phpCommandSettingsBuilder == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(5);
        }
        return phpCommandSettingsBuilder;
    }

    @NotNull
    public PhpCommandSettings build() throws ExecutionException {
        if (this.myInterpreter == null) {
            throw new ExecutionException(PhpCommandSettingsBuilder.getInterpreterNotFoundError());
        }
        PhpCommandSettings command = this.myInterpreter.isRemote() ? this.createRemoteSettings() : this.createLocalSettings();
        String customIni = this.myInterpreter.getCustomIni();
        if (StringUtil.isNotEmpty((String)customIni)) {
            command.setCustomIni(customIni);
        }
        if (this.myLoadDebugExtension) {
            Collection<String> debugOptions = PhpCommandSettingsBuilder.getDebugOptions(this.myStartDebugger, this.myProject, this.myInterpreter);
            debugOptions.forEach(command::addOption);
        }
        command.addConfigurationOptions(ContainerUtil.map(this.myInterpreter.getConfigurationOptions(), CONFIGURATION_OPTION_ADAPTER));
        PhpCommandSettings phpCommandSettings = command;
        if (phpCommandSettings == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(6);
        }
        return phpCommandSettings;
    }

    public static Collection<String> getDebugOptions(boolean startDebugger, @NotNull Project project, @Nullable PhpInterpreter interpreter) throws ExecutionException {
        PhpProjectDebugConfiguration.State configuration;
        if (project == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(7);
        }
        if (interpreter == null || StringUtil.isEmpty((String)interpreter.getDebuggerId())) {
            return Collections.emptyList();
        }
        ArrayList<String> debugOptions = new ArrayList<String>();
        String extension = interpreter.getDebuggerExtension();
        if (StringUtil.isNotEmpty((String)extension)) {
            debugOptions.add(PhpConfigurationOption.createZendExtensionOption(extension).getText());
        }
        if (startDebugger && (configuration = PhpProjectDebugConfiguration.getInstance(project).getState()).isLocalPassConfigurationOptions()) {
            PhpDebugExtension debugExtension = PhpDebugUtil.getDebugExtensionByDebuggerId(interpreter.getDebuggerId());
            String remoteHost = null;
            if (interpreter.isRemote()) {
                PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
                if (manager == null) {
                    throw new ExecutionException(PhpRemoteInterpreterManager.getRemoteInterpreterPluginIsDisabledErrorMessage());
                }
                remoteHost = manager.getRemoteHost(project, interpreter.getName(), interpreter.getPhpSdkAdditionalData());
            }
            remoteHost = StringUtil.notNullize(remoteHost, (String)"127.0.0.1");
            List<PhpConfigurationOption> configOptions = debugExtension.getDebugConfigurationsOptions(project, remoteHost, interpreter);
            debugOptions.addAll(ContainerUtil.map(configOptions, o -> o.getText()));
        }
        return debugOptions;
    }

    @NotNull
    protected PhpCommandSettings createRemoteSettings() throws ExecutionException {
        PhpCommandSettings command;
        PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
        if (manager == null) {
            throw new ExecutionException(PhpRemoteInterpreterManager.getRemoteInterpreterPluginIsDisabledErrorMessage());
        }
        PhpCommandSettings phpCommandSettings = command = manager.createPhpCommand(this.myProject, this.myInterpreter.getPhpSdkAdditionalData());
        if (phpCommandSettings == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(8);
        }
        return phpCommandSettings;
    }

    @NotNull
    protected PhpCommandSettings createLocalSettings() throws ExecutionException {
        PhpCommandSettings command;
        PhpCommandLinePathProcessor pathProcessor = PhpCommandLinePathProcessor.LOCAL;
        assert (this.myInterpreter != null);
        String path = pathProcessor.process(PhpCommandSettingsBuilder.findPhpBinary(this.myInterpreter.getHomePath()).getPath());
        PhpCommandSettings phpCommandSettings = command = PhpCommandSettingsBuilder.create(path, pathProcessor, null);
        if (phpCommandSettings == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(9);
        }
        return phpCommandSettings;
    }

    @Nullable
    public static String validate(@NotNull Project project) {
        if (project == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(10);
        }
        return PhpCommandSettingsBuilder.validate(project, null);
    }

    @Nullable
    public static String validate(@NotNull Project project, @Nullable String interpreterName) {
        if (project == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(11);
        }
        try {
            PhpInterpreter interpreter;
            PhpInterpretersManagerImpl interpretersManager = PhpInterpretersManagerImpl.getInstance(project);
            PhpInterpreter phpInterpreter = interpreter = interpreterName == null ? PhpProjectConfigurationFacade.getInstance(project).getInterpreter() : interpretersManager.findInterpreter(interpreterName);
            if (interpreter == null) {
                interpreter = PhpInterpreterConfigurationActivity.findAndConfigureInterpreters(project, false);
            }
            if (interpreter == null) {
                return PhpCommandSettingsBuilder.getInterpreterNotFoundError();
            }
            PhpSdkAdditionalData data = interpreter.getPhpSdkAdditionalData();
            String validate = data.validate(project, null);
            if (StringUtil.isNotEmpty((String)validate)) {
                return validate;
            }
            if (!interpreter.isRemote()) {
                PhpCommandSettingsBuilder.findPhpBinary(interpreter.getHomePath());
            }
        }
        catch (ExecutionException e) {
            return e.getMessage();
        }
        return null;
    }

    public static PhpCommandSettings create(@NotNull String pathToBinary, @NotNull PhpCommandLinePathProcessor pathProcessor, @Nullable PhpSdkAdditionalData data) {
        if (pathToBinary == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(12);
        }
        if (pathProcessor == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(13);
        }
        return new PhpCommandSettings(pathToBinary, pathProcessor, data);
    }

    @NotNull
    public static PhpCommandSettings create(@NotNull Project project, boolean withDebuggerOptions) throws ExecutionException {
        if (project == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(14);
        }
        PhpCommandSettings phpCommandSettings = new PhpCommandSettingsBuilder(project).loadAndStartDebug(withDebuggerOptions).build();
        if (phpCommandSettings == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(15);
        }
        return phpCommandSettings;
    }

    @NotNull
    public static PhpCommandSettings create(@NotNull Project project, @NotNull PhpInterpreter interpreter, boolean withDebuggerOptions) throws ExecutionException {
        if (project == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(16);
        }
        if (interpreter == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(17);
        }
        PhpCommandSettings phpCommandSettings = new PhpCommandSettingsBuilder(project, interpreter).loadAndStartDebug(withDebuggerOptions).build();
        if (phpCommandSettings == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(18);
        }
        return phpCommandSettings;
    }

    @NotNull
    public static VirtualFile findPhpBinary(@Nullable String phpHome) throws ExecutionException {
        VirtualFile binary = (VirtualFile)ReadAction.nonBlocking(() -> PhpRunUtil.findFileOrDirectory(phpHome, false)).executeSynchronously();
        if (binary == null) {
            throw new ExecutionException(PhpBundle.message("validation.value.is.not.specified.or.invalid", "PHP home"));
        }
        if (binary.isDirectory()) {
            String phpExecutableName = PhpProjectConfigurationFacade.PHP_EXECUTABLE;
            VirtualFile executable = binary.findChild(phpExecutableName);
            if (executable == null) {
                throw new ExecutionException(PhpBundle.message("validation.0.not.found.at.1", phpExecutableName, binary.getPresentableUrl()));
            }
            if (executable.isDirectory()) {
                throw new ExecutionException(PhpBundle.message("validation.0.is.not.a.directory", executable.getPresentableUrl()));
            }
            VirtualFile virtualFile = executable;
            if (virtualFile == null) {
                PhpCommandSettingsBuilder.$$$reportNull$$$0(19);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = binary;
        if (virtualFile == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(20);
        }
        return virtualFile;
    }

    @Nls
    public static String getInterpreterNotFoundError() {
        return PhpBundle.message("validation.value.is.not.specified.or.invalid", PhpBundle.message("interpreter", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 8, 9, 15, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/commandLine/PhpCommandSettingsBuilder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBinary";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/commandLine/PhpCommandSettingsBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDebugExtension";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAndStartDebug";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalSettings";
                break;
            }
            case 15: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findPhpBinary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDebugOptions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 8, 9, 15, 18, 19, 20 -> new IllegalStateException(string);
        };
    }
}

