/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterDecorator;
import com.jetbrains.php.config.interpreters.PhpInterpretersConfigurable;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInterpreterComboBox
extends ComboboxWithBrowseButton {
    private static final Comparator<PhpInterpreter> INTERPRETER_COMPARATOR = Comparator.comparing(PhpInterpreter::getName);
    protected Project myProject;
    private final Condition<? super PhpSdkAdditionalData> myAdditionalDataFilter;
    private final EventDispatcher<ChangeListener> myEventDispatcher = EventDispatcher.create(ChangeListener.class);
    private boolean myAllowNoItem = true;
    @Nls
    private String myNoItemText = PhpBundle.message("no.item", new Object[0]);

    public PhpInterpreterComboBox(@Nullable Project project, @Nullable Condition<? super PhpSdkAdditionalData> filter) {
        this(project, filter, true);
    }

    public PhpInterpreterComboBox(@Nullable Project project, @Nullable Condition<? super PhpSdkAdditionalData> filter, boolean withBrowseAction) {
        super((JComboBox)new ComboBox());
        this.myProject = project;
        this.myAdditionalDataFilter = filter;
        this.setNoItemText(PhpBundle.message("no.interpreter", new Object[0]));
        this.getComboBox().setRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value instanceof MyNamedItem) {
                    ((MyNamedItem)value).render((SimpleColoredComponent)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/php/config/interpreters/PhpInterpreterComboBox$1", "customizeCellRenderer"));
            }
        });
        this.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpInterpreterComboBox.this.fireChanged();
            }
        });
        this.setPreferredSize(new Dimension(200, this.getPreferredSize().height));
        if (withBrowseAction) {
            this.initDefaultBrowseAction();
        }
    }

    protected void initDefaultBrowseAction() {
        this.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = PhpInterpreterComboBox.this.getSelectedItemName();
                String interpreterId = PhpInterpretersManagerImpl.getInstance(PhpInterpreterComboBox.this.myProject).findInterpreterId(name);
                PhpInterpretersConfigurable interpretersConfigurable = new PhpInterpretersConfigurable(PhpInterpreterComboBox.this.myProject, PhpInterpreterComboBox.this.getSelectedItemName());
                boolean isOk = PhpUiUtil.editConfigurable(PhpInterpreterComboBox.this.myProject, (Configurable)interpretersConfigurable);
                if (isOk) {
                    String newInterpreterName = PhpInterpretersManagerImpl.getInstance(PhpInterpreterComboBox.this.myProject).findInterpreterName(interpreterId);
                    PhpProjectConfigurationFacade.getInstance(PhpInterpreterComboBox.this.myProject).updateSelectedInterpreterName(name, newInterpreterName);
                    PhpInterpreterComboBox.this.reset(newInterpreterName);
                }
            }
        });
    }

    public void setProject(@Nullable Project project) {
        this.myProject = project;
    }

    public boolean isNoItemAllowed() {
        return this.myAllowNoItem;
    }

    public void setNoItemAllowed(boolean allowNoServer) {
        this.myAllowNoItem = allowNoServer;
    }

    public void setNoItemText(@Nls @NotNull String text) {
        if (text == null) {
            PhpInterpreterComboBox.$$$reportNull$$$0(0);
        }
        this.myNoItemText = text;
    }

    @Nls
    public String getNoItemText() {
        return this.myNoItemText;
    }

    @Nullable
    public String getSelectedItemName() {
        Object selectedItem = this.getComboBox().getSelectedItem();
        if (!(selectedItem instanceof MyNamedItem)) {
            return null;
        }
        return ((MyNamedItem)selectedItem).getName();
    }

    public void reset() {
        this.reset(this.getSelectedItemName());
    }

    public void reset(@Nullable String selectedItemName) {
        List<PhpInterpreter> items = this.getItems();
        ContainerUtil.sort(items, INTERPRETER_COMPARATOR);
        PhpInterpreter selected = PhpInterpretersManagerImpl.getInstance(this.myProject).findInterpreter(selectedItemName);
        this.setModel(items, items.contains(selected) ? selected : null);
    }

    @NotNull
    public List<PhpInterpreter> getItems() {
        List<PhpInterpreter> interpreters = PhpInterpretersManagerImpl.getInstance(this.myProject).getInterpreters();
        if (this.myAdditionalDataFilter == null) {
            List<PhpInterpreter> list = interpreters;
            if (list == null) {
                PhpInterpreterComboBox.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<PhpInterpreter> filtered = new ArrayList<PhpInterpreter>();
        for (PhpInterpreter interpreter : interpreters) {
            PhpSdkAdditionalData data = interpreter.getPhpSdkAdditionalData();
            if (!this.myAdditionalDataFilter.value((Object)data)) continue;
            filtered.add(interpreter);
        }
        ArrayList<PhpInterpreter> arrayList = filtered;
        if (arrayList == null) {
            PhpInterpreterComboBox.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public void setModel(@NotNull List<PhpInterpreter> items, @Nullable PhpInterpreter selectedItem) {
        MyRegularNamedItem selected;
        String selectedName;
        if (items == null) {
            PhpInterpreterComboBox.$$$reportNull$$$0(3);
        }
        MyRegularNamedItem noItem = this.isNoItemAllowed() ? new MyRegularNamedItem(null, null) : new MyRegularNamedItem(null, SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
        LinkedList<MyRegularNamedItem> myItems = new LinkedList<MyRegularNamedItem>();
        String string = selectedName = selectedItem == null ? null : selectedItem.getName();
        if (selectedItem != null) {
            PhpInterpreterDecorator decorator = selectedItem.getPhpSdkAdditionalData().getDecorator();
            MyRegularNamedItem myRegularNamedItem = selected = items.contains(selectedItem) ? new MyRegularNamedItem(selectedName, decorator) : new MyRegularNamedItem(selectedName, SimpleTextAttributes.ERROR_ATTRIBUTES, decorator);
            if (this.isNoItemAllowed()) {
                myItems.add(noItem);
            }
        } else {
            selected = noItem;
        }
        myItems.addFirst(selected);
        for (PhpInterpreter interpreter : items) {
            String interpreterName = interpreter.getName();
            if (interpreterName.equals(selectedName)) continue;
            myItems.add(new MyRegularNamedItem(interpreterName, interpreter.getPhpSdkAdditionalData().getDecorator()));
        }
        this.getComboBox().setModel(new CollectionComboBoxModel(myItems, (Object)selected));
        this.getComboBox().setSelectedItem(selected);
    }

    public void addChangeListener(@NotNull ChangeListener listener) {
        if (listener == null) {
            PhpInterpreterComboBox.$$$reportNull$$$0(4);
        }
        this.myEventDispatcher.addListener((EventListener)listener, (Disposable)this);
    }

    private void fireChanged() {
        ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpInterpreterComboBox";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpreterComboBox";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setNoItemText";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    protected static abstract class MyNamedItem {
        protected MyNamedItem() {
        }

        @Nullable
        public abstract String getName();

        public abstract void render(@NotNull SimpleColoredComponent var1);
    }

    protected class MyRegularNamedItem
    extends MyNamedItem {
        private final Icon myIcon;
        @NlsSafe
        private final String myName;
        private final SimpleTextAttributes myAttributes;
        @NlsSafe
        private final String myPhpVersion;

        public MyRegularNamedItem(@NotNull String name, @Nullable SimpleTextAttributes attributes, PhpInterpreterDecorator decorator) {
            if (attributes == null) {
                MyRegularNamedItem.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myAttributes = attributes;
            PhpInfo phpInfo = name == null ? null : PhpInterpretersPhpInfoCacheImpl.getInstance(PhpInterpreterComboBox.this.myProject).getPhpInfo(name);
            this.myPhpVersion = phpInfo != null ? phpInfo.getVersion() : null;
            this.myIcon = null;
        }

        public MyRegularNamedItem(@Nullable String name, PhpInterpreterDecorator decorator) {
            this(name, SimpleTextAttributes.REGULAR_ATTRIBUTES, decorator);
        }

        @Override
        @Nullable
        public String getName() {
            return this.myName;
        }

        @Override
        public void render(@NotNull SimpleColoredComponent wrapper) {
            if (wrapper == null) {
                MyRegularNamedItem.$$$reportNull$$$0(1);
            }
            String name = this.myName;
            String phpVersion = this.myPhpVersion;
            SimpleTextAttributes attributes = this.myAttributes;
            if (this.myIcon != null) {
                wrapper.setIcon(this.myIcon);
            }
            if (name == null) {
                wrapper.append(PhpInterpreterComboBox.this.getNoItemText(), attributes);
            } else if (phpVersion != null) {
                wrapper.append(name, attributes);
                wrapper.append(" ");
                wrapper.append("(" + phpVersion + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            } else {
                wrapper.append(name, this.myAttributes);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapper";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpreterComboBox$MyRegularNamedItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "render";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

