/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterComponent;
import com.jetbrains.php.config.interpreters.PhpLocalInterpreterComponent;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.herd.PhpHerdInterpretersManager;
import com.jetbrains.php.config.interpreters.herd.PhpHerdMainLocalInterpreterComponent;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.ui.PhpConfigurableItem;
import com.jetbrains.php.ui.PhpConfigurableWithDescription;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInterpreterConfigurable
extends PhpConfigurableItem
implements PhpConfigurableWithDescription {
    private static final Logger LOG = Logger.getInstance(PhpInterpreterConfigurable.class);
    private JPanel myMainPanel;
    private PhpInterpreterComponent myInterpreterComponent;
    @NotNull
    private final PhpInterpreter myInterpreter;

    public PhpInterpreterConfigurable(@NotNull Project project, @NotNull PhpInterpreter interpreter) {
        if (project == null) {
            PhpInterpreterConfigurable.$$$reportNull$$$0(0);
        }
        if (interpreter == null) {
            PhpInterpreterConfigurable.$$$reportNull$$$0(1);
        }
        this.myInterpreter = interpreter;
        this.init(project);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void init(@NotNull Project project) {
        if (project == null) {
            PhpInterpreterConfigurable.$$$reportNull$$$0(2);
        }
        String name = this.myInterpreter.getName();
        PhpSdkAdditionalData data = this.myInterpreter.getPhpSdkAdditionalData();
        if (this.myInterpreter.isRemote()) {
            PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
            if (manager == null) {
                LOG.warn(PhpRemoteInterpreterManager.getRemoteInterpreterPluginIsDisabledErrorMessage());
                return;
            }
            this.myInterpreterComponent = manager.createRemoteInterpreterEditor(project, name, data);
        } else {
            this.myInterpreterComponent = PhpHerdInterpretersManager.getInstance().isMainLaravelHerdInterpreter(this.myInterpreter) ? new PhpHerdMainLocalInterpreterComponent(project, data, name) : new PhpLocalInterpreterComponent(project, data, name);
        }
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)5, (int)5));
        JPanel view = this.myInterpreterComponent.getMainPanel();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)view, (int)20, (int)31);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myMainPanel.add((Component)scrollPane, "Center");
    }

    @Override
    protected JComponent createTopRightComponent() {
        return this.myInterpreterComponent.getProjectLevelComboBox();
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return this.myInterpreterComponent.isModified(this.myInterpreter.getName(), this.myInterpreter.getPhpSdkAdditionalData(), this.myInterpreter);
    }

    public void apply() throws ConfigurationException {
        try {
            this.myInterpreterComponent.apply(this.myInterpreter);
        }
        catch (RemoteSdkException | IllegalStateException e) {
            throw new ConfigurationException(PhpBundle.message("cant.save.interpreter", this.getInterpreterName(), e.getMessage()));
        }
    }

    public void reset() {
        this.myInterpreterComponent.reset(this.myInterpreter.getName(), this.myInterpreter.getPhpSdkAdditionalData(), this.myInterpreter);
    }

    public void disposeUIResources() {
        this.myInterpreterComponent.disposeUIResources();
    }

    @Nls
    public String getDisplayName() {
        return PhpBundle.message("interpreter", new Object[0]);
    }

    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public PhpInfo getLastLoadedPhpInfo() {
        return this.myInterpreterComponent.getLastLoadedPhpInfo();
    }

    @NotNull
    public String getInterpreterName() {
        String string = this.myInterpreter.getName();
        if (string == null) {
            PhpInterpreterConfigurable.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    @Nls
    public String getDescription() {
        PhpHerdInterpretersManager herdInterpretersManager = PhpHerdInterpretersManager.getInstance();
        if (herdInterpretersManager.isMainLaravelHerdInterpreter(this.myInterpreter)) {
            return PhpBundle.message("php.interpreter.configurable.description.main.laravel.herd", new Object[0]);
        }
        if (herdInterpretersManager.isLaravelHerdInterpreter(this.myInterpreter)) {
            return PhpBundle.message("php.interpreter.configurable.description.laravel.herd", new Object[0]);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpInterpreterConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpreterConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

