/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.run.remote.PhpInvalidSdkTypeException;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTextFieldWithSdkBasedBrowse
extends TextFieldWithBrowseButton {
    private static final Logger LOG = Logger.getInstance(PhpTextFieldWithSdkBasedBrowse.class);

    public void init(@Nullable Project project, @Nullable PhpSdkAdditionalData sdkData, @NotNull String title, boolean withFiles, boolean withFolders) {
        boolean isRemoteSdk;
        if (title == null) {
            PhpTextFieldWithSdkBasedBrowse.$$$reportNull$$$0(0);
        }
        boolean canBrowse = !(isRemoteSdk = sdkData instanceof RemoteSdkAdditionalData) || PhpTextFieldWithSdkBasedBrowse.producesSshSdkCredentials(sdkData);
        this.getButton().setVisible(canBrowse);
        if (isRemoteSdk) {
            if (PhpTextFieldWithSdkBasedBrowse.producesSshSdkCredentials(sdkData)) {
                try {
                    PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
                    if (manager != null) {
                        this.addActionListener(manager.createRemoteBrowserAction(project, sdkData, title, this.getTextField(), !withFiles && withFolders));
                    }
                }
                catch (PhpInvalidSdkTypeException e) {
                    LOG.warn("Can not create browse action for sdk");
                }
            }
        } else {
            this.addBrowseFolderListener(project, new FileChooserDescriptor(withFiles, withFolders, false, false, false, false));
        }
    }

    private static boolean producesSshSdkCredentials(@NotNull PhpSdkAdditionalData sdkData) {
        PhpRemoteInterpreterManager manager;
        if (sdkData == null) {
            PhpTextFieldWithSdkBasedBrowse.$$$reportNull$$$0(1);
        }
        return (manager = PhpRemoteInterpreterManager.getInstance()) != null && manager.producesSshSdkCredentials(sdkData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkData";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpTextFieldWithSdkBasedBrowse";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "producesSshSdkCredentials";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

