/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters.herd;

import com.intellij.openapi.components.Service;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.herd.PhpHerdInterpretersManager;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/php/config/interpreters/herd/PhpMacosHerdInterpretersManager;", "Lcom/jetbrains/php/config/interpreters/herd/PhpHerdInterpretersManager;", "<init>", "()V", "herdDirectory", "", "getHerdDirectory", "()Ljava/lang/String;", "herdXdebugDirectory", "getHerdXdebugDirectory", "mainInterpreterName", "getMainInterpreterName", "isValidPhpBinary", "", "path", "Ljava/nio/file/Path;", "isLaravelHerdInterpreter", "interpreter", "Lcom/jetbrains/php/config/interpreters/PhpInterpreter;", "intellij.php.impl"})
public final class PhpMacosHerdInterpretersManager
extends PhpHerdInterpretersManager {
    @NotNull
    private final String herdDirectory = System.getProperty("user.home") + "/Library/Application Support/Herd";
    @NotNull
    private final String herdXdebugDirectory;
    @NotNull
    private final String mainInterpreterName;

    private PhpMacosHerdInterpretersManager() {
        super(null);
        this.herdXdebugDirectory = "/Applications/Herd.app/Contents/Resources/xdebug";
        this.mainInterpreterName = "php";
    }

    @Override
    @NotNull
    public String getHerdDirectory() {
        return this.herdDirectory;
    }

    @Override
    @NotNull
    public String getHerdXdebugDirectory() {
        return this.herdXdebugDirectory;
    }

    @Override
    @NotNull
    public String getMainInterpreterName() {
        return this.mainInterpreterName;
    }

    @Override
    public boolean isValidPhpBinary(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CharSequence charSequence = ((Object)path.getFileName()).toString();
        return new Regex("^php(\\d{2})?$").matches(charSequence);
    }

    @Override
    public boolean isLaravelHerdInterpreter(@NotNull PhpInterpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        String string = interpreter.getHomePath();
        return string != null ? StringsKt.startsWith$default((String)string, (String)this.getHerdDirectory(), (boolean)false, (int)2, null) : false;
    }
}

