/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.phpInfo;

import com.intellij.openapi.project.Project;
import com.jetbrains.php.config.phpInfo.PhpInfoHtmlParser;
import com.jetbrains.php.config.phpInfo.PhpInfoRawParser;
import com.jetbrains.php.config.phpInfo.UserPhpInfo;
import com.jetbrains.php.debug.validation.configuration.PhpDebugConfiguration;
import com.jetbrains.php.debug.validation.configuration.Xdebug2Configuration;
import com.jetbrains.php.debug.validation.configuration.Xdebug3Configuration;
import com.jetbrains.php.debug.validation.configuration.XdebugConfiguration;
import com.jetbrains.php.debug.xdebug.XdebugUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PhpInfoParser {
    String ZEND_EXTENSION = "Zend Extension";
    String LOADED_CONFIGURATION_FILE = "Loaded Configuration File";
    String ADDITIONAL_INI_FILES_PARSED = "Additional .ini files parsed";
    String CLIENT_PORT = "xdebug.client_port";
    String CLIENT_HOST = "xdebug.client_host";
    String MODE = "xdebug.mode";
    String LOG = "xdebug.log";
    String START_WITH_REQUEST = "xdebug.start_with_request";
    String START_UPON_ERROR = "xdebug.start_upon_error";
    String DISCOVER_CLIENT_HOST = "xdebug.discover_client_host";
    String CLIENT_DISCOVERY_HEADER = "xdebug.client_discovery_header";
    String CLOUD_ID = "xdebug.cloud_id";
    String NO_VALUE = "no value";
    String OFF = "Off";
    String REMOTE_HANDLER = "xdebug.remote_handler";
    String REMOTE_ENABLE = "xdebug.remote_enable";
    String REMOTE_AUTOSTART = "xdebug.remote_autostart";
    String REMOTE_HOST = "xdebug.remote_host";
    String REMOTE_PORT = "xdebug.remote_port";
    String REMOTE_MODE = "xdebug.remote_mode";
    String REMOTE_LOG = "xdebug.remote_log";
    String REMOTE_CONNECT_BACK = "xdebug.remote_connect_back";
    String config = null;
    List<String> additionalPhpIni = new ArrayList<String>();
    String xDebugVersion = "UNKNOWN";
    boolean isLoadedByZendExtension = false;
    String protocol = "dbgp";
    String log = "";
    String host = "";
    String port = "";
    String mode = "";
    String startWithRequest = "";
    String startUponError = "";
    boolean isConnectBack = false;
    boolean discoverClientHost = false;
    boolean isRemoteEnabled = false;
    boolean autostartEnabled = false;
    String clientDiscoveryHeader = "";
    String cloudUserId = null;

    public UserPhpInfo parse(String text, Project project) {
        UserPhpInfo parse = new PhpInfoHtmlParser().parse(text, project);
        if (parse == null) {
            parse = new PhpInfoRawParser().parse(text, project);
        }
        return parse;
    }

    @Nullable
    PhpDebugConfiguration getConfiguration(String xDebugVersion, boolean isLoadedByZendExtension, String protocol, String log, String host, String port, String mode, String startWithRequest, String startUponError, boolean isConnectBack, boolean discoverClientHost, boolean isRemoteEnabled, boolean autostartEnabled, String clientDiscoveryHeader, String cloudUserId, Project project) {
        XdebugConfiguration configuration = xDebugVersion.equals("UNKNOWN") ? null : (XdebugUtil.isAtLeastXdebug3(xDebugVersion) ? new Xdebug3Configuration(project, xDebugVersion, isLoadedByZendExtension, protocol, host, port, log, isConnectBack, mode, startWithRequest, startUponError, discoverClientHost, clientDiscoveryHeader, cloudUserId) : new Xdebug2Configuration(xDebugVersion, isLoadedByZendExtension, protocol, host, port, log, isConnectBack, isRemoteEnabled, mode, autostartEnabled));
        return configuration;
    }
}

