/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.phpInfo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.config.phpInfo.PhpInfoParser;
import com.jetbrains.php.config.phpInfo.UserPhpInfo;
import com.jetbrains.php.debug.validation.configuration.PhpDebugConfiguration;
import com.jetbrains.php.debug.xdebug.XdebugUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PhpInfoRawParser
extends PhpInfoParser {
    @Override
    public UserPhpInfo parse(String text, Project project) {
        boolean xDebugSection = false;
        boolean additionalFilesParsing = false;
        for (String s : StringUtil.splitByLines((String)text, (boolean)false)) {
            if (s.startsWith(this.ZEND_EXTENSION)) {
                this.isLoadedByZendExtension = true;
            }
            if (s.startsWith("xdebug")) {
                xDebugSection = true;
            }
            if (s.startsWith(this.LOADED_CONFIGURATION_FILE)) {
                this.config = PhpInfoRawParser.getValueSubstring(s, this.LOADED_CONFIGURATION_FILE);
            }
            if (xDebugSection) {
                if (s.startsWith("\u001b[0mVersion") || s.startsWith("Version")) {
                    this.xDebugVersion = PhpInfoRawParser.getValueSubstring(s, "Version");
                }
                if (s.startsWith(this.REMOTE_CONNECT_BACK)) {
                    this.isConnectBack = true;
                }
                if (XdebugUtil.isAtLeastXdebug3(this.xDebugVersion)) {
                    String substring;
                    if (s.startsWith(this.CLIENT_HOST)) {
                        this.host = PhpInfoRawParser.getValueSubstring(s, this.CLIENT_HOST);
                    }
                    if (s.contains(this.CLIENT_PORT)) {
                        this.port = PhpInfoRawParser.getValueSubstring(s, this.CLIENT_PORT);
                    }
                    if (s.startsWith(this.MODE)) {
                        this.mode = PhpInfoRawParser.getValueSubstring(s, this.MODE);
                    }
                    if (s.startsWith(this.LOG) && !s.startsWith(this.LOG + "_")) {
                        this.log = PhpInfoRawParser.getValueSubstring(s, this.LOG);
                    }
                    if (s.startsWith(this.START_WITH_REQUEST)) {
                        this.startWithRequest = PhpInfoRawParser.getValueSubstring(s, this.START_WITH_REQUEST);
                    }
                    if (s.startsWith(this.START_UPON_ERROR)) {
                        this.startUponError = PhpInfoRawParser.getValueSubstring(s, this.START_UPON_ERROR);
                    }
                    if (s.startsWith(this.DISCOVER_CLIENT_HOST)) {
                        boolean bl = this.discoverClientHost = !this.OFF.equals(PhpInfoRawParser.getValueSubstring(s, this.DISCOVER_CLIENT_HOST));
                    }
                    if (s.startsWith(this.CLIENT_DISCOVERY_HEADER)) {
                        this.clientDiscoveryHeader = PhpInfoRawParser.getValueSubstring(s, this.CLIENT_DISCOVERY_HEADER);
                    }
                    if (s.startsWith(this.CLOUD_ID) && !this.NO_VALUE.equals(substring = PhpInfoRawParser.getValueSubstring(s, this.CLOUD_ID))) {
                        this.cloudUserId = substring;
                    }
                } else {
                    if (s.startsWith(this.REMOTE_HANDLER)) {
                        this.protocol = PhpInfoRawParser.getValueSubstring(s, this.REMOTE_HANDLER);
                    }
                    if (s.startsWith(this.REMOTE_ENABLE)) {
                        boolean bl = this.isRemoteEnabled = !this.OFF.equals(PhpInfoRawParser.getValueSubstring(s, this.REMOTE_ENABLE));
                    }
                    if (s.startsWith(this.REMOTE_AUTOSTART)) {
                        boolean bl = this.autostartEnabled = !this.OFF.equals(PhpInfoRawParser.getValueSubstring(s, this.REMOTE_AUTOSTART));
                    }
                    if (s.startsWith(this.REMOTE_HOST)) {
                        this.host = PhpInfoRawParser.getValueSubstring(s, this.REMOTE_HOST);
                    }
                    if (s.startsWith(this.REMOTE_PORT)) {
                        this.port = PhpInfoRawParser.getValueSubstring(s, this.REMOTE_PORT);
                    }
                    if (s.startsWith(this.REMOTE_MODE)) {
                        this.mode = PhpInfoRawParser.getValueSubstring(s, this.REMOTE_MODE);
                    }
                    if (s.startsWith(this.REMOTE_LOG) && !s.startsWith(this.REMOTE_LOG + "_")) {
                        this.log = PhpInfoRawParser.getValueSubstring(s, this.REMOTE_LOG);
                    }
                }
            }
            if (s.startsWith(this.ADDITIONAL_INI_FILES_PARSED)) {
                additionalFilesParsing = true;
                this.additionalPhpIni.addAll(StringUtil.split((String)StringUtil.trimTrailing((String)PhpInfoRawParser.getValueSubstring(s, this.ADDITIONAL_INI_FILES_PARSED), (char)','), (String)","));
                continue;
            }
            if (!additionalFilesParsing) continue;
            if (StringUtil.isEmptyOrSpaces((String)s) || s.startsWith("PHP API")) {
                additionalFilesParsing = false;
                continue;
            }
            this.additionalPhpIni.add(StringUtil.trimTrailing((String)s, (char)','));
        }
        PhpDebugConfiguration configuration = this.getConfiguration(this.xDebugVersion, this.isLoadedByZendExtension, this.protocol, this.log, this.host, this.port, this.mode, this.startWithRequest, this.startUponError, this.isConnectBack, this.discoverClientHost, this.isRemoteEnabled, this.autostartEnabled, this.clientDiscoveryHeader, this.cloudUserId, project);
        return new UserPhpInfo(this.config, this.additionalPhpIni, this.xDebugVersion, configuration);
    }

    @NotNull
    private static String getValueSubstring(String s, String begin) {
        if ((s = StringUtil.substringAfter((String)s, (String)begin)) != null) {
            if (s.contains("=>")) {
                String string = s.substring(s.lastIndexOf("=>") + 3);
                if (string == null) {
                    PhpInfoRawParser.$$$reportNull$$$0(0);
                }
                return string;
            }
            if (StringUtil.containsWhitespaces((CharSequence)s)) {
                String string = Objects.requireNonNullElse(StringUtil.substringAfterLast((String)s, (String)"\t"), "");
                if (string == null) {
                    PhpInfoRawParser.$$$reportNull$$$0(1);
                }
                return string;
            }
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/config/phpInfo/PhpInfoRawParser", "getValueSubstring"));
    }
}

