/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.TypeInfo;
import com.jetbrains.php.debug.actions.PhpCopyBaseAction;
import com.jetbrains.php.debug.common.PhpEvaluationResultProcessor;
import com.jetbrains.php.debug.common.PhpEvaluator;
import com.jetbrains.php.debug.common.PhpNavigatableValue;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpCopyAsBaseAction
extends PhpCopyBaseAction {
    private static final Logger LOG = Logger.getInstance(PhpCopyAsBaseAction.class);
    private final String myFunctionName;
    @NlsSafe
    private final String myText;

    public PhpCopyAsBaseAction(@NotNull String functionName, @NotNull @NlsSafe String text) {
        if (functionName == null) {
            PhpCopyAsBaseAction.$$$reportNull$$$0(0);
        }
        if (text == null) {
            PhpCopyAsBaseAction.$$$reportNull$$$0(1);
        }
        this.myFunctionName = functionName;
        this.myText = text;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PhpCopyAsBaseAction.$$$reportNull$$$0(2);
        }
        super.update(e);
        e.getPresentation().setText(this.getPresentationText());
    }

    public void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        Project project;
        if (nodeName == null) {
            PhpCopyAsBaseAction.$$$reportNull$$$0(3);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        XDebugSession session = DebuggerUIUtil.getSession((AnActionEvent)e);
        if (session != null) {
            this.perform(project, session, node, nodeName);
        }
    }

    protected void perform(final @NotNull Project project, @NotNull XDebugSession session, XValueNodeImpl node, @NotNull String nodeName) {
        XDebuggerEvaluator evaluator;
        if (project == null) {
            PhpCopyAsBaseAction.$$$reportNull$$$0(4);
        }
        if (session == null) {
            PhpCopyAsBaseAction.$$$reportNull$$$0(5);
        }
        if (nodeName == null) {
            PhpCopyAsBaseAction.$$$reportNull$$$0(6);
        }
        if (!((evaluator = session.getDebugProcess().getEvaluator()) instanceof PhpEvaluator)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Evaluator  does not support 'copy value as' action for " + nodeName);
            }
            return;
        }
        String fullName = PhpCopyAsBaseAction.getVariableFullName(node, nodeName);
        if (StringUtil.isEmpty((String)fullName)) {
            this.showErrorMessage(project, PhpBundle.message("debug.action.copy.as.was.fail.can.not.get.full.name", this.getFunctionName()));
            return;
        }
        String expression = this.wrapExpressionIntoFunction(fullName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Copy value for " + nodeName + ", full expression: " + expression);
        }
        ((PhpEvaluator)evaluator).evaluateCodeFragment(expression, new PhpEvaluationResultProcessor(){

            @Override
            public void success(@NotNull String value, @NotNull TypeInfo typeInfo, @NotNull PhpNavigatableValue navigatableValue) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (typeInfo == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (navigatableValue == null) {
                    1.$$$reportNull$$$0(2);
                }
                PhpCopyAsBaseAction.this.copyInClipboard(value);
            }

            @Override
            public void error(@NotNull @Nls String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(3);
                }
                ApplicationManager.getApplication().invokeLater(() -> PhpCopyAsBaseAction.this.showErrorMessage(project, errorMessage));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeInfo";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "navigatableValue";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/debug/actions/PhpCopyAsBaseAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "success";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void showErrorMessage(@NotNull Project project, @NotNull @Nls String errorMessage) {
        if (project == null) {
            PhpCopyAsBaseAction.$$$reportNull$$$0(7);
        }
        if (errorMessage == null) {
            PhpCopyAsBaseAction.$$$reportNull$$$0(8);
        }
        String title = PhpBundle.message("debug.action.copy.as.title", this.getFunctionName());
        Messages.showMessageDialog((Project)project, (String)errorMessage, (String)title, (Icon)Messages.getErrorIcon());
        LOG.debug(errorMessage);
    }

    @NotNull
    protected String wrapExpressionIntoFunction(@NotNull String fullName) {
        if (fullName == null) {
            PhpCopyAsBaseAction.$$$reportNull$$$0(9);
        }
        String string = this.getFunctionName() + "(" + fullName + ",true)";
        if (string == null) {
            PhpCopyAsBaseAction.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    protected String getFunctionName() {
        String string = this.myFunctionName;
        if (string == null) {
            PhpCopyAsBaseAction.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    protected String getPresentationText() {
        String string = this.myText;
        if (string == null) {
            PhpCopyAsBaseAction.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeName";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/actions/PhpCopyAsBaseAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/actions/PhpCopyAsBaseAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapExpressionIntoFunction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showErrorMessage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wrapExpressionIntoFunction";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

