/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.DuplexConsoleView;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.debug.PhpApplicationDebugConfiguration;
import com.jetbrains.php.debug.PhpDebugConnectionInfo;
import com.jetbrains.php.debug.PhpDebugSessionLogger;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpDebuggerEditorsProvider;
import com.jetbrains.php.debug.common.PhpDebugDriver;
import com.jetbrains.php.debug.common.PhpDebugNotificationUtils;
import com.jetbrains.php.debug.common.PhpDebugStrategy;
import com.jetbrains.php.debug.common.PhpDebuggerConsoleExecuteActionHandler;
import com.jetbrains.php.debug.common.PhpExceptionBreakpointHandler;
import com.jetbrains.php.debug.common.PhpExceptionBreakpointProperties;
import com.jetbrains.php.debug.common.PhpLineBreakpointHandler;
import com.jetbrains.php.debug.common.PhpLineMethodBreakpointType;
import com.jetbrains.php.debug.common.PhpMethodBreakpointProperties;
import com.jetbrains.php.debug.common.PhpMethodBreakpointRegistrationHandler;
import com.jetbrains.php.debug.common.PhpMethodBreakpointType;
import com.jetbrains.php.debug.common.PhpMethodBreakpointValidator;
import com.jetbrains.php.debug.common.PhpStackFrame;
import com.jetbrains.php.debug.common.PhpSuspendContext;
import com.jetbrains.php.debug.common.smartStepInto.PhpSmartStepIntoHandler;
import com.jetbrains.php.debug.common.smartStepInto.PhpSmartStepIntoState;
import com.jetbrains.php.debug.connection.ConnectionListener;
import com.jetbrains.php.debug.connection.ConnectionStatus;
import com.jetbrains.php.debug.connection.PhpDebugConnection;
import com.jetbrains.php.debug.stepFilters.PhpStepFiltersConfiguration;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragmentImpl;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.run.PhpExecutionUtil;
import com.jetbrains.php.run.filters.VarDumpFileFilter;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.awt.Component;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDebugProcess<S extends PhpDebugConnection>
extends XDebugProcess
implements ConnectionListener<S>,
Disposable {
    private static final Logger LOG = Logger.getInstance(PhpDebugProcess.class);
    public static final int MIN_TO_FOLD = 5;
    private final Object myLock;
    private boolean myConnected;
    private boolean myStopped;
    private String myTemporaryBreakpointId;
    private RunContentDescriptor myRunContentDescriptor;
    private final PhpSmartStepIntoHandler mySmartStepIntoHandler;
    private PhpSmartStepIntoState mySmartStepIntoState;
    private PhpStepCommand myLastStepCommand;
    @Nullable
    private S myConnection;
    @NotNull
    protected final PhpDebugDriver<S> myDriver;
    @NotNull
    private PhpDebugStrategy myStrategy;
    @NotNull
    private final PhpLineBreakpointHandler<PhpDebugProcess> myBreakpointHandler;
    private final PhpExceptionBreakpointHandler<PhpDebugProcess> myExceptionBreakpointHandler;
    private final PhpMethodBreakpointValidator myMethodBreakpointValidator;
    private final PhpMethodBreakpointRegistrationHandler<PhpDebugProcess, XBreakpoint<PhpMethodBreakpointProperties>> myMethodBreakpointHandler;
    private final PhpMethodBreakpointRegistrationHandler<PhpDebugProcess, XLineBreakpoint<PhpMethodBreakpointProperties>> myLineMethodBreakpointHandler;
    @Nullable
    private final ConsoleView myConsole;
    @Nullable
    protected ConsoleView myExternalStdoutConsole;
    protected boolean myWithExternalStdout;
    @Nullable
    private final ClientId myClientId;
    private boolean myDisposed;

    public PhpDebugProcess(final @NotNull XDebugSession session, @NotNull PhpDebugDriver<S> driver, @NotNull PhpDebugStrategy strategy, @Nullable ConsoleView console, boolean withExternalStdout) {
        if (session == null) {
            PhpDebugProcess.$$$reportNull$$$0(0);
        }
        if (driver == null) {
            PhpDebugProcess.$$$reportNull$$$0(1);
        }
        if (strategy == null) {
            PhpDebugProcess.$$$reportNull$$$0(2);
        }
        super(session);
        this.myLock = new Object();
        this.myConnected = false;
        this.myStopped = false;
        this.myTemporaryBreakpointId = null;
        this.myLastStepCommand = PhpStepCommand.RESUME;
        this.myDisposed = false;
        this.myDriver = driver;
        this.myStrategy = strategy;
        Disposer.register((Disposable)this, (Disposable)this.myStrategy);
        this.myConsole = console == null ? PhpDebugProcess.getConsoleView(session.getProject()) : console;
        this.myClientId = ClientId.getCurrentOrNull();
        this.myExternalStdoutConsole = null;
        this.myWithExternalStdout = withExternalStdout;
        this.myBreakpointHandler = new PhpLineBreakpointHandler<PhpDebugProcess>(this);
        this.myExceptionBreakpointHandler = new PhpExceptionBreakpointHandler<PhpDebugProcess>(this);
        this.myMethodBreakpointValidator = new PhpMethodBreakpointValidator();
        this.myMethodBreakpointHandler = new PhpMethodBreakpointRegistrationHandler(this, this.myMethodBreakpointValidator, PhpMethodBreakpointType.class);
        this.myLineMethodBreakpointHandler = new PhpMethodBreakpointRegistrationHandler(this, this.myMethodBreakpointValidator, PhpLineMethodBreakpointType.class);
        this.mySmartStepIntoHandler = new PhpSmartStepIntoHandler(this);
        session.setPauseActionSupported(false);
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                session.removeSessionListener((XDebugSessionListener)this);
                PhpDebugProcess.this.doStop();
                AppUIUtil.invokeOnEdt(() -> Disposer.dispose((Disposable)PhpDebugProcess.this));
            }
        });
        strategy.registerPathMappingsChangedCallback(new PathMappingsChangedCallback(){

            @Override
            public void pathMappingsChanged() {
                PhpDebugProcess.this.myBreakpointHandler.registerAllUnregisterBreakpoints();
            }
        });
    }

    @NotNull
    public static ConsoleViewImpl getConsoleView(@NotNull Project project) {
        if (project == null) {
            PhpDebugProcess.$$$reportNull$$$0(3);
        }
        String ESCAPE = "\u001b";
        final List<String> list = Arrays.asList(ESCAPE + "]8;;", ESCAPE + "\\^", ESCAPE + "\\");
        return new ConsoleViewImpl(project, false){

            @NotNull
            protected CompositeFilter createCompositeFilter() {
                Collections.sort(this.predefinedFilters, (a, b) -> {
                    if (a instanceof VarDumpFileFilter) {
                        return -1;
                    }
                    if (b instanceof VarDumpFileFilter) {
                        return 1;
                    }
                    return 0;
                });
                CompositeFilter compositeFilter = super.createCompositeFilter();
                if (compositeFilter == null) {
                    3.$$$reportNull$$$0(0);
                }
                return compositeFilter;
            }

            public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
                if (text == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (contentType == null) {
                    3.$$$reportNull$$$0(2);
                }
                for (String ansi : list) {
                    if (!text.contains(ansi)) continue;
                    text = text.replace(ansi, "");
                }
                super.print(text, contentType);
            }

            protected void updateFoldings(int startLine, int endLine) {
                super.updateFoldings(startLine, endLine);
                FoldingModel model = this.getEditor().getFoldingModel();
                String output = this.getText();
                if (!output.contains("array")) {
                    return;
                }
                HashSet<Trinity> regions = new HashSet<Trinity>();
                ArrayDeque<Integer> openIdxSq = new ArrayDeque<Integer>();
                ArrayDeque<Integer> openIdx = new ArrayDeque<Integer>();
                block6: for (int i = 0; i < output.length(); ++i) {
                    char c = output.charAt(i);
                    switch (c) {
                        case '[': {
                            openIdxSq.push(i);
                            continue block6;
                        }
                        case '{': {
                            openIdx.push(i);
                            continue block6;
                        }
                        case ']': {
                            if (openIdxSq.isEmpty() || i - (Integer)openIdxSq.peek() <= 5) continue block6;
                            regions.add(new Trinity((Object)((Integer)openIdxSq.pop()), (Object)i, (Object)"<...>"));
                            continue block6;
                        }
                        case '}': {
                            if (openIdx.isEmpty() || i - (Integer)openIdx.peek() <= 5) continue block6;
                            regions.add(new Trinity((Object)((Integer)openIdx.pop()), (Object)i, (Object)"<...>"));
                        }
                    }
                }
                model.runBatchFoldingOperation(() -> {
                    for (Trinity stringTrinity : regions) {
                        FoldRegion region = model.addFoldRegion((Integer)stringTrinity.first + 1, ((Integer)stringTrinity.second).intValue(), (String)stringTrinity.third);
                        if (region == null || !region.isExpanded()) continue;
                        region.setExpanded(true);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/debug/common/PhpDebugProcess$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "contentType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createCompositeFilter";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/debug/common/PhpDebugProcess$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "print";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    public void setStrategy(@NotNull PhpDebugStrategy strategy) {
        if (strategy == null) {
            PhpDebugProcess.$$$reportNull$$$0(4);
        }
        this.myStrategy = strategy;
    }

    @NotNull
    public final XDebuggerEditorsProvider getEditorsProvider() {
        return new PhpDebuggerEditorsProvider();
    }

    public final XBreakpointHandler<?> @NotNull [] getBreakpointHandlers() {
        XBreakpointHandler[] xBreakpointHandlerArray = new XBreakpointHandler[]{this.getLineBreakpointHandler(), this.getExceptionBreakpointHandler(), this.getMethodBreakpointHandler(), this.getLineMethodBreakpointHandler()};
        if (xBreakpointHandlerArray == null) {
            PhpDebugProcess.$$$reportNull$$$0(5);
        }
        return xBreakpointHandlerArray;
    }

    public void sessionInitialized() {
        XDebugSession session = this.getSession();
        this.myRunContentDescriptor = session.getRunContentDescriptor();
        if (this.myWithExternalStdout) {
            this.myExternalStdoutConsole = new ConsoleViewImpl(session.getProject(), true);
            PhpDebugUtil.addExternalStdoutTab(this.myRunContentDescriptor, this.myExternalStdoutConsole);
        }
    }

    @Nullable
    public RunContentDescriptor getRunContentDescriptor() {
        return this.myRunContentDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final S getConnection() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStop() {
        Object object = this.myLock;
        synchronized (object) {
            this.myStopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopped() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myConnected;
        }
    }

    public final void printErrorOutput(@NotNull String error) {
        if (error == null) {
            PhpDebugProcess.$$$reportNull$$$0(6);
        }
        this.print(error, ConsoleViewContentType.ERROR_OUTPUT);
    }

    public final void printScriptOutput(@NotNull String message) {
        if (message == null) {
            PhpDebugProcess.$$$reportNull$$$0(7);
        }
        this.print(message, ConsoleViewContentType.NORMAL_OUTPUT);
    }

    public final void print(@NotNull String message, @NotNull ConsoleViewContentType type) {
        ConsoleView consoleView;
        if (message == null) {
            PhpDebugProcess.$$$reportNull$$$0(8);
        }
        if (type == null) {
            PhpDebugProcess.$$$reportNull$$$0(9);
        }
        if ((consoleView = this.getSession().getConsoleView()) != null) {
            consoleView.print(message, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void statusChanged(@NotNull S connection, @NotNull ConnectionStatus status) {
        if (connection == null) {
            PhpDebugProcess.$$$reportNull$$$0(10);
        }
        if (status == null) {
            PhpDebugProcess.$$$reportNull$$$0(11);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (connection != this.myConnection) {
                return;
            }
        }
        switch (status) {
            case CONNECTED: {
                this.onConnect();
                break;
            }
            case DISCONNECTED: {
                boolean disconnect = false;
                Object object2 = this.myLock;
                synchronized (object2) {
                    if (this.myConnected) {
                        this.myConnected = false;
                        this.myConnection = null;
                        disconnect = true;
                        ((PhpDebugConnection)connection).removeListener(this);
                    }
                }
                if (disconnect) {
                    this.onDisconnect();
                }
                PhpDebugSessionLogger.getInstance().logSessionEnded((PhpDebugConnectionInfo)connection);
                this.refresh();
                break;
            }
        }
        this.getSession().rebuildViews();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean connect(@NotNull S connection) {
        if (connection == null) {
            PhpDebugProcess.$$$reportNull$$$0(12);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.isStopped() || this.myConnected) {
                return false;
            }
            this.myConnected = true;
            this.myConnection = connection;
            ((PhpDebugConnection)connection).addListener(this);
            ((PhpDebugConnection)connection).updateStatus();
        }
        return true;
    }

    @Nullable
    public final PhpPathMapper getPathMapper() {
        return this.myStrategy.getPathMapper();
    }

    @NotNull
    public PhpDebugStrategy getStrategy() {
        PhpDebugStrategy phpDebugStrategy = this.myStrategy;
        if (phpDebugStrategy == null) {
            PhpDebugProcess.$$$reportNull$$$0(13);
        }
        return phpDebugStrategy;
    }

    protected void onConnect() {
        this.registerHandlers();
        S connection = this.getConnection();
        assert (connection != null);
        this.initialize(connection);
    }

    protected void initialize(S connection) {
        ((PhpDebugConnection)connection).initializeConnection(new InitializeCallback(){

            @Override
            public void initialized(boolean isJitMode) {
                PhpDebugProcess.this.getLineBreakpointHandler().registerAllUnregisterBreakpoints();
                PhpDebugProcess.this.getExceptionBreakpointHandler().registerAllUnregisterBreakpoints();
                PhpDebugProcess.this.getMethodBreakpointHandler().registerAllUnregisterBreakpoints();
                PhpDebugProcess.this.getLineMethodBreakpointHandler().registerAllUnregisterBreakpoints();
                PhpDebugProcess.this.start();
            }

            @Override
            public void errorOccurred(@NotNull @Nls String errorTitle, @NotNull @Nls String errorMessage) {
                if (errorTitle == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (errorMessage == null) {
                    4.$$$reportNull$$$0(1);
                }
                PhpDebugUtil.showWarningNotification(PhpDebugProcess.this.getSession().getProject(), errorTitle, errorMessage);
                PhpDebugProcess.this.getSession().stop();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "errorTitle";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "errorMessage";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/debug/common/PhpDebugProcess$4";
                objectArray[2] = "errorOccurred";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this.myStrategy.isPrintErrorOutput(), false);
    }

    private void onDisconnect() {
        if (this.myStrategy.isStopSessionOnDisconnect()) {
            this.doStop();
            this.getSession().stop();
        }
    }

    protected void start() {
        this.myDriver.start(this);
    }

    protected final void registerHandlers() {
        this.myDriver.registerHandlers(this);
        if (this.myStrategy.isPrintErrorOutput()) {
            this.myDriver.registerErrorOutputHandler(this, new ErrorOutputHandler(){

                @Override
                public void onErrorOutput(@NotNull String errorText) {
                    if (errorText == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    PhpDebugProcess.this.printErrorOutput(errorText);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorText", "com/jetbrains/php/debug/common/PhpDebugProcess$5", "onErrorOutput"));
                }
            });
        }
    }

    private void refresh() {
        this.myTemporaryBreakpointId = null;
        this.getLineBreakpointHandler().refresh();
        this.getExceptionBreakpointHandler().refresh();
    }

    public void dispose() {
        this.myDisposed = true;
    }

    public final void log(String text) {
        StringBuilder builder2 = new StringBuilder();
        builder2.append(this.hashCode());
        builder2.append("# ");
        builder2.append(text);
        if (LOG.isDebugEnabled()) {
            LOG.debug(builder2.toString());
        }
    }

    public final void registerBreakpoint(@NotNull String remoteFilePath, int line, @Nullable String condition, @NotNull RegisterBreakpointCallback callback) {
        if (remoteFilePath == null) {
            PhpDebugProcess.$$$reportNull$$$0(14);
        }
        if (callback == null) {
            PhpDebugProcess.$$$reportNull$$$0(15);
        }
        String encoding = PhpDebugUtil.getDebugOutputEncoding(this.getSession().getProject());
        S connection = this.getConnection();
        if (connection == null) {
            callback.errorOccurred("disconnected");
            return;
        }
        this.myDriver.registerBreakpoint(connection, remoteFilePath, line, condition, encoding, callback);
    }

    public final void registerExceptionBreakpoint(@NotNull String exception, @NotNull RegisterBreakpointCallback callback) {
        if (exception == null) {
            PhpDebugProcess.$$$reportNull$$$0(16);
        }
        if (callback == null) {
            PhpDebugProcess.$$$reportNull$$$0(17);
        }
        if (!this.myDriver.isExceptionalBreakpointSupported()) {
            PhpDebugUtil.getNotificationGroup().createNotification(PhpBundle.message("debug.php.exception.breakpoint.not.supported", new Object[0]), MessageType.WARNING).notify(this.getSession().getProject());
            return;
        }
        S connection = this.getConnection();
        if (connection == null) {
            callback.errorOccurred("disconnected");
            return;
        }
        this.myDriver.registerExceptionBreakpoint(connection, exception, callback);
    }

    public final void unregisterBreakpoint(@NotNull String breakpointId, @NotNull UnregisterBreakpointCallback callback) {
        S connection;
        if (breakpointId == null) {
            PhpDebugProcess.$$$reportNull$$$0(18);
        }
        if (callback == null) {
            PhpDebugProcess.$$$reportNull$$$0(19);
        }
        if ((connection = this.getConnection()) == null) {
            callback.errorOccurred("disconnected");
            return;
        }
        this.myDriver.unregisterBreakpoint(connection, breakpointId, callback);
    }

    public void onReady(final @NotNull PhpSuspendContext suspendContext, final @Nullable String exception) {
        if (suspendContext == null) {
            PhpDebugProcess.$$$reportNull$$$0(20);
        }
        try (AccessToken ignored = ClientId.withClientId((ClientId)this.myClientId);){
            if (this.myTemporaryBreakpointId != null) {
                this.unregisterBreakpoint(this.myTemporaryBreakpointId, new UnregisterBreakpointCallback(){

                    @Override
                    public void unregistered() {
                        PhpDebugProcess.this.myTemporaryBreakpointId = null;
                        PhpDebugProcess.this.onReady(suspendContext, exception);
                    }

                    @Override
                    public void errorOccurred(@Nullable String errorMessage) {
                        PhpDebugProcess.this.myTemporaryBreakpointId = null;
                        PhpDebugProcess.this.onReady(suspendContext, exception);
                    }
                });
            } else {
                PhpStackFrame topFrame = suspendContext.getTopFrame();
                if (topFrame != null) {
                    int stopLineNumber;
                    XBreakpoint<PhpMethodBreakpointProperties> methodBreakpoint;
                    XBreakpoint<PhpMethodBreakpointProperties> methodBreakpoint2;
                    XBreakpoint<PhpExceptionBreakpointProperties> exceptionBreakpoint;
                    if (StringUtil.isNotEmpty((String)exception) && (exceptionBreakpoint = this.getExceptionBreakpointHandler().findBreakpoint(exception)) != null) {
                        this.handleBreakpoint(suspendContext, exceptionBreakpoint);
                        return;
                    }
                    XSourcePosition sourcePosition = topFrame.getSourcePosition();
                    if (this.myLastStepCommand == PhpStepCommand.RESUME && sourcePosition != null) {
                        PhpLineBreakpointHandler handler = this.getLineBreakpointHandler();
                        XLineBreakpoint<XBreakpointProperties> breakpoint = handler.findBreakpoint(sourcePosition);
                        if (breakpoint != null) {
                            this.handleBreakpoint(suspendContext, (XBreakpoint<? extends XBreakpointProperties>)breakpoint);
                            return;
                        }
                        XLineBreakpoint<?> originalBreakpoint = this.findResolvedBreakpoint(sourcePosition, handler);
                        if (originalBreakpoint != null) {
                            if (originalBreakpoint instanceof XLineBreakpointImpl) {
                                XLineBreakpointImpl lineBreakpoint = (XLineBreakpointImpl)originalBreakpoint;
                                if (PhpApplicationDebugConfiguration.getInstance().getState().isXdebugMoveToResolveBreakpoints()) {
                                    ApplicationManager.getApplication().invokeLater(() -> lineBreakpoint.setLine(sourcePosition.getLine()));
                                }
                            }
                            PhpDebugNotificationUtils.notifyIfNecessary(this.getSession().getProject(), originalBreakpoint);
                            this.handleBreakpoint(suspendContext, (XBreakpoint<? extends XBreakpointProperties>)originalBreakpoint);
                            return;
                        }
                    }
                    String stopMethodName = topFrame.getFunctionName();
                    if (this.myLastStepCommand == PhpStepCommand.AUTO_STEP_OVER && (methodBreakpoint2 = this.myMethodBreakpointValidator.findMethodBreakpoint(stopMethodName)) != null) {
                        this.handleBreakpoint(suspendContext, methodBreakpoint2);
                        return;
                    }
                    if (sourcePosition != null && (methodBreakpoint = this.myMethodBreakpointValidator.findMethodBreakpointOnLine(stopMethodName, stopLineNumber = sourcePosition.getLine())) != null) {
                        if (PhpCompletionContributor.PHP_PREDEFINED_FUNCTIONS.contains(stopMethodName)) {
                            this.handleBreakpoint(suspendContext, methodBreakpoint);
                        } else {
                            S connection = this.getConnection();
                            if (connection != null) {
                                Version xdebugVersion = connection.getEngineVersion();
                                if (xdebugVersion != null && xdebugVersion.isOrGreaterThan(Integer.valueOf(3), Integer.valueOf(2))) {
                                    this.handleBreakpoint(suspendContext, methodBreakpoint);
                                } else {
                                    this.startStepOver(true);
                                }
                            }
                        }
                        return;
                    }
                    this.getSession().positionReached((XSuspendContext)suspendContext);
                } else {
                    this.getSession().resume();
                }
            }
        }
    }

    @Nullable
    private XLineBreakpoint<?> findResolvedBreakpoint(@NotNull XSourcePosition sourcePosition, @NotNull PhpLineBreakpointHandler handler) {
        String remotePath;
        PhpPathMapper mapper;
        if (sourcePosition == null) {
            PhpDebugProcess.$$$reportNull$$$0(21);
        }
        if (handler == null) {
            PhpDebugProcess.$$$reportNull$$$0(22);
        }
        if ((mapper = this.myStrategy.getPathMapper()) != null && (remotePath = mapper.getRemoteFilePath(sourcePosition.getFile().getPath())) != null) {
            String resolvedId = handler.findResolvedBreakpoint(remotePath, sourcePosition.getLine() + 1);
            return StringUtil.isNotEmpty((String)resolvedId) ? handler.findBreakpointById(resolvedId) : null;
        }
        return null;
    }

    private void handleBreakpoint(final PhpSuspendContext suspendContext, final XBreakpoint<? extends XBreakpointProperties> breakpoint) {
        String breakpointCondition;
        XExpression condition = breakpoint.getConditionExpression();
        String string = breakpointCondition = condition == null ? null : condition.getExpression();
        if (breakpointCondition != null && !this.isConditionalBreakpointSupported(breakpoint)) {
            this.evalBoolean(breakpointCondition, new BooleanEvaluateCallback(){

                @Override
                public void evaluated(boolean result) {
                    if (result) {
                        PhpDebugProcess.this.onBreakpointReached((XBreakpoint<XBreakpointProperties>)breakpoint, suspendContext);
                    } else {
                        PhpDebugProcess.this.getSession().resume();
                    }
                }

                @Override
                public void errorOccurred() {
                    PhpDebugProcess.this.onBreakpointReached((XBreakpoint<XBreakpointProperties>)breakpoint, suspendContext);
                }
            });
        } else {
            this.onBreakpointReached(breakpoint, suspendContext);
        }
    }

    private void onBreakpointReached(final @NotNull XBreakpoint<? extends XBreakpointProperties> breakpoint, final @NotNull PhpSuspendContext suspendContext) {
        XExpression expression;
        String logExpression;
        if (breakpoint == null) {
            PhpDebugProcess.$$$reportNull$$$0(23);
        }
        if (suspendContext == null) {
            PhpDebugProcess.$$$reportNull$$$0(24);
        }
        String string = logExpression = (expression = breakpoint.getLogExpressionObject()) == null ? null : expression.getExpression();
        if (logExpression != null) {
            this.evalString(logExpression, new StringEvaluateCallback(){

                @Override
                public void evaluated(@NotNull String result) {
                    if (result == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    PhpDebugProcess.this.onBreakpointReached((XBreakpoint<XBreakpointProperties>)breakpoint, result, suspendContext);
                }

                @Override
                public void errorOccurred() {
                    PhpDebugProcess.this.onBreakpointReached((XBreakpoint<XBreakpointProperties>)breakpoint, PhpBundle.message("debug.error.cannot.evaluate.expression0", logExpression), suspendContext);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/common/PhpDebugProcess$8", "evaluated"));
                }
            });
        } else {
            this.onBreakpointReached(breakpoint, null, suspendContext);
        }
    }

    private void onBreakpointReached(@NotNull XBreakpoint<? extends XBreakpointProperties> breakpoint, @Nullable String evaluatedLogExpression, @NotNull PhpSuspendContext suspendContext) {
        if (breakpoint == null) {
            PhpDebugProcess.$$$reportNull$$$0(25);
        }
        if (suspendContext == null) {
            PhpDebugProcess.$$$reportNull$$$0(26);
        }
        if (!this.getSession().breakpointReached(breakpoint, evaluatedLogExpression, (XSuspendContext)suspendContext)) {
            this.getSession().resume();
        }
    }

    protected final boolean isConditionalBreakpointSupported(XBreakpoint<? extends XBreakpointProperties> breakpoint) {
        return this.myDriver.isConditionalBreakpointSupported(breakpoint);
    }

    @NotNull
    public final PhpLineBreakpointHandler getLineBreakpointHandler() {
        PhpLineBreakpointHandler<PhpDebugProcess> phpLineBreakpointHandler = this.myBreakpointHandler;
        if (phpLineBreakpointHandler == null) {
            PhpDebugProcess.$$$reportNull$$$0(27);
        }
        return phpLineBreakpointHandler;
    }

    @NotNull
    public PhpExceptionBreakpointHandler<PhpDebugProcess> getExceptionBreakpointHandler() {
        PhpExceptionBreakpointHandler<PhpDebugProcess> phpExceptionBreakpointHandler = this.myExceptionBreakpointHandler;
        if (phpExceptionBreakpointHandler == null) {
            PhpDebugProcess.$$$reportNull$$$0(28);
        }
        return phpExceptionBreakpointHandler;
    }

    @NotNull
    public PhpMethodBreakpointRegistrationHandler<PhpDebugProcess, XBreakpoint<PhpMethodBreakpointProperties>> getMethodBreakpointHandler() {
        PhpMethodBreakpointRegistrationHandler<PhpDebugProcess, XBreakpoint<PhpMethodBreakpointProperties>> phpMethodBreakpointRegistrationHandler = this.myMethodBreakpointHandler;
        if (phpMethodBreakpointRegistrationHandler == null) {
            PhpDebugProcess.$$$reportNull$$$0(29);
        }
        return phpMethodBreakpointRegistrationHandler;
    }

    @NotNull
    public PhpMethodBreakpointRegistrationHandler<PhpDebugProcess, XLineBreakpoint<PhpMethodBreakpointProperties>> getLineMethodBreakpointHandler() {
        PhpMethodBreakpointRegistrationHandler<PhpDebugProcess, XLineBreakpoint<PhpMethodBreakpointProperties>> phpMethodBreakpointRegistrationHandler = this.myLineMethodBreakpointHandler;
        if (phpMethodBreakpointRegistrationHandler == null) {
            PhpDebugProcess.$$$reportNull$$$0(30);
        }
        return phpMethodBreakpointRegistrationHandler;
    }

    public final void onCannotFindPathMapper(@NotNull XCompositeNode node, @NotNull Runnable reloader) {
        if (node == null) {
            PhpDebugProcess.$$$reportNull$$$0(31);
        }
        if (reloader == null) {
            PhpDebugProcess.$$$reportNull$$$0(32);
        }
        this.myStrategy.onCannotFindPathMapper(node, reloader);
    }

    public final void onCannotFindLocalPath(@NotNull XCompositeNode node, @NotNull String remoteFilePath, @NotNull Runnable reloader) {
        if (node == null) {
            PhpDebugProcess.$$$reportNull$$$0(33);
        }
        if (remoteFilePath == null) {
            PhpDebugProcess.$$$reportNull$$$0(34);
        }
        if (reloader == null) {
            PhpDebugProcess.$$$reportNull$$$0(35);
        }
        this.myStrategy.onCannotFindLocalPath(node, remoteFilePath, reloader);
    }

    public final void onCannotFindLocalFile(@NotNull XCompositeNode node, @NotNull String remoteFilePath, @NotNull String localPath, @NotNull Runnable reloader) {
        if (node == null) {
            PhpDebugProcess.$$$reportNull$$$0(36);
        }
        if (remoteFilePath == null) {
            PhpDebugProcess.$$$reportNull$$$0(37);
        }
        if (localPath == null) {
            PhpDebugProcess.$$$reportNull$$$0(38);
        }
        if (reloader == null) {
            PhpDebugProcess.$$$reportNull$$$0(39);
        }
        this.myStrategy.onCannotFindLocalFile(node, remoteFilePath, localPath, reloader);
    }

    public void onScriptOutsideProject(@NotNull XCompositeNode node, @NotNull String remoteFilePath, @NotNull VirtualFile localFile, @NotNull Runnable reloader) {
        if (node == null) {
            PhpDebugProcess.$$$reportNull$$$0(40);
        }
        if (remoteFilePath == null) {
            PhpDebugProcess.$$$reportNull$$$0(41);
        }
        if (localFile == null) {
            PhpDebugProcess.$$$reportNull$$$0(42);
        }
        if (reloader == null) {
            PhpDebugProcess.$$$reportNull$$$0(43);
        }
        this.myStrategy.onScriptOutsideProject(node, remoteFilePath, localFile, reloader);
    }

    public final void evalBoolean(@NotNull String booleanExpression, @NotNull BooleanEvaluateCallback callback) {
        if (booleanExpression == null) {
            PhpDebugProcess.$$$reportNull$$$0(44);
        }
        if (callback == null) {
            PhpDebugProcess.$$$reportNull$$$0(45);
        }
        String encoding = PhpDebugUtil.getDebugOutputEncoding(this.getSession().getProject());
        S connection = this.getConnection();
        if (connection == null) {
            callback.errorOccurred();
            return;
        }
        ((PhpDebugConnection)connection).evalBoolean(booleanExpression, encoding, callback);
    }

    public final void evalString(@NotNull String expression, @NotNull StringEvaluateCallback callback) {
        if (expression == null) {
            PhpDebugProcess.$$$reportNull$$$0(46);
        }
        if (callback == null) {
            PhpDebugProcess.$$$reportNull$$$0(47);
        }
        if (!((Boolean)ReadAction.compute(() -> this.isValidToStringArgument(expression))).booleanValue()) {
            callback.errorOccurred();
            return;
        }
        String encoding = PhpDebugUtil.getDebugOutputEncoding(this.getSession().getProject());
        S connection = this.getConnection();
        if (connection == null) {
            callback.errorOccurred();
            return;
        }
        callback.evaluate((PhpDebugConnection)connection, expression, encoding);
    }

    private static void doEval(@NotNull String expression, @NotNull StringEvaluateCallback callback, String encoding, PhpDebugConnection connection) {
        if (expression == null) {
            PhpDebugProcess.$$$reportNull$$$0(48);
        }
        if (callback == null) {
            PhpDebugProcess.$$$reportNull$$$0(49);
        }
        connection.evalString(expression, encoding, callback);
    }

    private boolean isValidToStringArgument(String expression) {
        PsiFile fragment = PsiManager.getInstance((Project)this.getSession().getProject()).findFile((VirtualFile)new LightVirtualFile("fragment." + PhpFileType.INSTANCE.getDefaultExtension(), (CharSequence)("<?php " + XdebugConnection.getToStringExpression(expression) + ";")));
        UnaryExpression castExpression = (UnaryExpression)PsiTreeUtil.findChildOfType((PsiElement)fragment, UnaryExpression.class);
        PhpPsiElement value = castExpression != null ? castExpression.getValue() : null;
        return value != null && PsiTreeUtil.findChildOfType((PsiElement)value, PsiErrorElement.class) == null;
    }

    @Nullable
    public XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.mySmartStepIntoHandler;
    }

    @Nullable
    public PhpSmartStepIntoState getSmartStepIntoState() {
        return this.mySmartStepIntoState;
    }

    public boolean isProcessingSmartStepInto() {
        return this.mySmartStepIntoState != null;
    }

    public final void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            PhpDebugProcess.$$$reportNull$$$0(50);
        }
        this.myLastStepCommand = PhpStepCommand.RESUME;
        PhpPathMapper pathMapper = this.getPathMapper();
        if (pathMapper == null) {
            this.getSession().resume();
            return;
        }
        VirtualFile file = position.getFile();
        String remoteFilePath = pathMapper.getRemoteFilePath(file);
        if (remoteFilePath == null) {
            this.getSession().resume();
            return;
        }
        S connection = this.getConnection();
        if (connection == null) {
            this.getSession().resume();
            return;
        }
        this.myDriver.registerBreakpoint(connection, remoteFilePath, position.getLine(), null, "", new RegisterBreakpointCallback(){

            @Override
            public void registered(@NotNull String breakpointId) {
                if (breakpointId == null) {
                    9.$$$reportNull$$$0(0);
                }
                PhpDebugProcess.this.myTemporaryBreakpointId = breakpointId;
                PhpDebugProcess.this.getSession().resume();
            }

            @Override
            public void errorOccurred(@Nullable String errorMessage) {
                PhpDebugProcess.this.getSession().resume();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpointId", "com/jetbrains/php/debug/common/PhpDebugProcess$9", "registered"));
            }
        });
    }

    public final void startSmartStepInto(int lineRangeStart, int lineRangeEnd, @Nullable Set<String> classReference, String ... variant) {
        if (variant == null) {
            PhpDebugProcess.$$$reportNull$$$0(51);
        }
        this.myLastStepCommand = PhpStepCommand.STEP_INTO;
        this.mySmartStepIntoState = new PhpSmartStepIntoState(classReference, variant, lineRangeStart + 1, lineRangeEnd + 1);
        this.myDriver.startSmartStepInto(this);
    }

    public void stopSmartStepInto(boolean methodWasExecuted) {
        if (!methodWasExecuted) {
            PhpDebugUtil.getNotificationGroup().createNotification(PhpBundle.message("debug.process.smart.step.into.function.was.not.executed", new Object[0]), MessageType.WARNING).notify(this.getSession().getProject());
        }
        this.mySmartStepIntoState = null;
    }

    private void startStepOver(boolean isAutoStep) {
        S connection = this.getConnection();
        if (connection == null) {
            return;
        }
        this.myLastStepCommand = isAutoStep ? PhpStepCommand.AUTO_STEP_OVER : PhpStepCommand.STEP_OVER;
        this.myDriver.startStepOver(connection);
    }

    public final void startStepOver(@Nullable XSuspendContext context) {
        this.startStepOver(false);
    }

    public void startForceStepInto(@Nullable XSuspendContext context) {
        S connection = this.getConnection();
        if (connection == null) {
            return;
        }
        this.myLastStepCommand = PhpStepCommand.STEP_INTO;
        this.myDriver.startStepInto(connection);
    }

    public final void startStepInto(@Nullable XSuspendContext context) {
        S connection = this.getConnection();
        if (connection == null) {
            return;
        }
        this.myLastStepCommand = PhpStepCommand.STEP_INTO;
        XDebugSession xDebugSession = this.getSession();
        PhpStepFiltersConfiguration.State state = PhpStepFiltersConfiguration.getInstance(xDebugSession.getProject()).getState();
        if (!state.isNothingToSkip()) {
            this.myDriver.startFilteredStepInto(this, connection, state);
        } else {
            this.myDriver.startStepInto(connection);
        }
    }

    public final void startStepOut(@Nullable XSuspendContext context) {
        S connection = this.getConnection();
        if (connection == null) {
            return;
        }
        this.myLastStepCommand = PhpStepCommand.STEP_OUT;
        this.myDriver.startStepOut(connection);
    }

    public final void stop() {
        S connection = this.getConnection();
        if (connection == null) {
            return;
        }
        this.myDriver.stop(connection);
    }

    public final void resume(@Nullable XSuspendContext context) {
        S connection = this.getConnection();
        if (connection == null) {
            return;
        }
        this.myLastStepCommand = PhpStepCommand.RESUME;
        this.myDriver.resume(connection);
    }

    public final void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        if (leftToolbar == null) {
            PhpDebugProcess.$$$reportNull$$$0(52);
        }
        if (topToolbar == null) {
            PhpDebugProcess.$$$reportNull$$$0(53);
        }
        if (settings == null) {
            PhpDebugProcess.$$$reportNull$$$0(54);
        }
        this.myDriver.registerAdditionalActions(leftToolbar, topToolbar, settings, this);
    }

    public final XValueMarkerProvider<?, ?> createValueMarkerProvider() {
        return this.myDriver.createValueMarkerProvider();
    }

    @NotNull
    public final String getSessionIdName() {
        String string = this.myDriver.getSessionIdName();
        if (string == null) {
            PhpDebugProcess.$$$reportNull$$$0(55);
        }
        return string;
    }

    @NotNull
    public List<? extends AnAction> getAdditionalBreakpointPopupMenuActions(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            PhpDebugProcess.$$$reportNull$$$0(56);
        }
        List<? extends AnAction> list = this.myStrategy.getAdditionalBreakpointPopupMenuActions(breakpoint);
        if (list == null) {
            PhpDebugProcess.$$$reportNull$$$0(57);
        }
        return list;
    }

    public boolean isExternalStdoutEnabled() {
        return this.myExternalStdoutConsole != null;
    }

    public void printExternalStdout(@NotNull String data) {
        if (data == null) {
            PhpDebugProcess.$$$reportNull$$$0(58);
        }
        if (this.myExternalStdoutConsole != null) {
            this.myExternalStdoutConsole.print(data, ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    @NotNull
    public ExecutionConsole createConsole() {
        XDebugSession session = this.getSession();
        if (this.myConsole != null) {
            Object object = !session.getProject().isDisposed() ? this.createInteractiveConsole(session, this.myConsole) : this.myConsole;
            if (object == null) {
                PhpDebugProcess.$$$reportNull$$$0(59);
            }
            return object;
        }
        ExecutionConsole executionConsole = !session.getProject().isDisposed() ? this.createInteractiveConsole(session) : super.createConsole();
        if (executionConsole == null) {
            PhpDebugProcess.$$$reportNull$$$0(60);
        }
        return executionConsole;
    }

    @NotNull
    private ExecutionConsole createInteractiveConsole(@NotNull XDebugSession session, ConsoleView console) {
        if (session == null) {
            PhpDebugProcess.$$$reportNull$$$0(61);
        }
        XDebugProcess process = session.getDebugProcess();
        PhpDebuggerConsoleExecuteActionHandler executeActionHandler = new PhpDebuggerConsoleExecuteActionHandler(process);
        ProcessHandler handler = process.getProcessHandler();
        LanguageConsoleView consoleView = PhpDebugProcess.createLanguageConsole(session, executeActionHandler, handler);
        DuplexConsoleView<ConsoleView, LanguageConsoleView> duplexConsoleView = new DuplexConsoleView<ConsoleView, LanguageConsoleView>(console, consoleView, "php.debug.console.enabled"){

            public void enableConsole(boolean primary) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (PhpDebugProcess.this.myDisposed) {
                        return;
                    }
                    super.enableConsole(primary);
                    if (!primary && !this.isPrimaryConsoleEnabled()) {
                        LanguageConsoleView console = (LanguageConsoleView)this.getSecondaryConsoleView();
                        IdeFocusManager.findInstance().requestFocus((Component)console.getCurrentEditor().getContentComponent(), true);
                    }
                });
            }
        };
        PhpPathMapper mapper = this.myStrategy.getPathMapper();
        if (mapper != null) {
            PhpExecutionUtil.addMessageFilters(session.getProject(), (ConsoleView)duplexConsoleView, mapper);
        }
        consoleView.getVirtualFile().putUserData(PhpDebuggerEditorsProvider.PHP_INTERACTIVE_CONSOLE, (Object)true);
        ((LanguageConsoleView)duplexConsoleView.getSecondaryConsoleView()).getVirtualFile().putUserData(PhpDebuggerEditorsProvider.PHP_INTERACTIVE_CONSOLE, (Object)true);
        duplexConsoleView.setEnabled(true);
        duplexConsoleView.attachToProcess(handler);
        handler.addProcessListener(PhpDebugProcess.getListener(handler, consoleView));
        Disposer.register((Disposable)this, (Disposable)duplexConsoleView);
        DuplexConsoleView<ConsoleView, LanguageConsoleView> duplexConsoleView2 = duplexConsoleView;
        if (duplexConsoleView2 == null) {
            PhpDebugProcess.$$$reportNull$$$0(62);
        }
        return duplexConsoleView2;
    }

    @NotNull
    private ExecutionConsole createInteractiveConsole(@NotNull XDebugSession session) {
        if (session == null) {
            PhpDebugProcess.$$$reportNull$$$0(63);
        }
        XDebugProcess process = session.getDebugProcess();
        PhpDebuggerConsoleExecuteActionHandler executeActionHandler = new PhpDebuggerConsoleExecuteActionHandler(process);
        ProcessHandler handler = process.getProcessHandler();
        LanguageConsoleView consoleView = PhpDebugProcess.createLanguageConsole(session, executeActionHandler, handler);
        PhpPathMapper mapper = this.myStrategy.getPathMapper();
        if (mapper != null) {
            PhpExecutionUtil.addMessageFilters(session.getProject(), (ConsoleView)consoleView, mapper);
        }
        consoleView.getVirtualFile().putUserData(PhpDebuggerEditorsProvider.PHP_INTERACTIVE_CONSOLE, (Object)true);
        handler.addProcessListener(PhpDebugProcess.getListener(handler, consoleView));
        Disposer.register((Disposable)this, (Disposable)consoleView);
        LanguageConsoleView languageConsoleView = consoleView;
        if (languageConsoleView == null) {
            PhpDebugProcess.$$$reportNull$$$0(64);
        }
        return languageConsoleView;
    }

    @NotNull
    private static ProcessListener getListener(final ProcessHandler handler, final LanguageConsoleView consoleView) {
        return new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    11.$$$reportNull$$$0(0);
                }
                handler.removeProcessListener((ProcessListener)this);
                AppUIUtil.invokeOnEdt(() -> {
                    if (consoleView.getProject().isDisposed()) {
                        return;
                    }
                    consoleView.setEditable(false);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/debug/common/PhpDebugProcess$11", "processTerminated"));
            }
        };
    }

    @NotNull
    private static LanguageConsoleView createLanguageConsole(@NotNull XDebugSession session, PhpDebuggerConsoleExecuteActionHandler executeActionHandler, ProcessHandler handler) {
        if (session == null) {
            PhpDebugProcess.$$$reportNull$$$0(65);
        }
        LanguageConsoleBuilder builder2 = new LanguageConsoleBuilder().processHandler(handler).initActions((BaseConsoleExecuteActionHandler)executeActionHandler, "php-debugger-repl").oneLineInput(false).psiFileFactory((file, currentProject) -> {
            Project project = currentProject.isDisposed() ? ProjectManager.getInstance().getDefaultProject() : currentProject;
            PsiElement context = PhpDebuggerEditorsProvider.getContextElement(project, session.getCurrentPosition());
            return new PhpExpressionCodeFragmentImpl(project, (VirtualFile)file, (IElementType)PhpElementTypes.CODE_FRAGMENT, context, true);
        }).processInputStateKey("php.debugger.console.stdin");
        LanguageConsoleView languageConsoleView = (LanguageConsoleView)WriteIntentReadAction.compute(() -> builder2.build(session.getProject(), (Language)PhpLanguage.INSTANCE));
        if (languageConsoleView == null) {
            PhpDebugProcess.$$$reportNull$$$0(66);
        }
        return languageConsoleView;
    }

    public final void registerMethodBreakpoint(PhpMethodBreakpointProperties properties, RegisterBreakpointCallback callback) {
        if (!this.myDriver.isMethodBreakpointSupported()) {
            PhpDebugUtil.getNotificationGroup().createNotification(PhpBundle.message("debug.php.method.breakpoint.dialog.title", new Object[0]), MessageType.WARNING).notify(this.getSession().getProject());
            return;
        }
        S connection = this.getConnection();
        if (connection == null) {
            callback.errorOccurred("disconnected");
            return;
        }
        this.myDriver.registerMethodBreakpoint(connection, properties, callback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 13, 27, 28, 29, 30, 55, 57, 59, 60, 62, 64, 66 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 13: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/common/PhpDebugProcess";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 14: 
            case 34: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 45: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointId";
                break;
            }
            case 20: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePosition";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 23: 
            case 25: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 31: 
            case 33: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 32: 
            case 35: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reloader";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "booleanExpression";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftToolbar";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topToolbar";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/common/PhpDebugProcess";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrategy";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineBreakpointHandler";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionBreakpointHandler";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodBreakpointHandler";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineMethodBreakpointHandler";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionIdName";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalBreakpointPopupMenuActions";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 62: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createInteractiveConsole";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "createLanguageConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleView";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setStrategy";
                break;
            }
            case 5: 
            case 13: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 64: 
            case 66: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "printErrorOutput";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "printScriptOutput";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "statusChanged";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerBreakpoint";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerExceptionBreakpoint";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "unregisterBreakpoint";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "onReady";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findResolvedBreakpoint";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "onBreakpointReached";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "onCannotFindPathMapper";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "onCannotFindLocalPath";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "onCannotFindLocalFile";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "onScriptOutsideProject";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "evalBoolean";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "evalString";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "doEval";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "startSmartStepInto";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalActions";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalBreakpointPopupMenuActions";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "printExternalStdout";
                break;
            }
            case 61: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createInteractiveConsole";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "createLanguageConsole";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 13, 27, 28, 29, 30, 55, 57, 59, 60, 62, 64, 66 -> new IllegalStateException(string);
        };
    }

    private static enum PhpStepCommand {
        STEP_INTO,
        STEP_OVER,
        STEP_OUT,
        RESUME,
        AUTO_STEP_OVER;

    }

    public static interface PathMappingsChangedCallback {
        public void pathMappingsChanged();
    }

    public static interface InitializeCallback {
        public void initialized(boolean var1);

        public void errorOccurred(@NotNull @Nls String var1, @Nls @NotNull String var2);
    }

    public static interface ErrorOutputHandler {
        public void onErrorOutput(@NotNull String var1);
    }

    public static interface RegisterBreakpointCallback {
        public void registered(@NotNull String var1);

        public void errorOccurred(@Nullable String var1);
    }

    public static interface UnregisterBreakpointCallback {
        public void unregistered();

        public void errorOccurred(@Nullable String var1);
    }

    public static interface BooleanEvaluateCallback {
        public void evaluated(boolean var1);

        public void errorOccurred();
    }

    public static interface StringEvaluateCallback {
        public void evaluated(@NotNull String var1);

        public void errorOccurred();

        default public void evaluate(PhpDebugConnection connection, String expression, String encoding) {
            connection.evalString(expression, encoding, this);
        }
    }
}

