/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.NullableConsumer;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.jetbrains.php.debug.PhpDebuggerEditorsProvider;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.TypeInfo;
import com.jetbrains.php.debug.common.PhpEvaluationResultProcessor;
import com.jetbrains.php.debug.common.PhpEvaluator;
import com.jetbrains.php.debug.common.PhpNavigatableValue;
import com.jetbrains.php.debug.common.debugConsole.PhpDebugCommandFactory;
import com.jetbrains.php.debug.common.debugConsole.PhpDebugConsoleCommand;
import com.jetbrains.php.debug.common.debugConsole.PhpEvaluationErrorHandler;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragmentImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDebuggerConsoleExecuteActionHandler
extends BaseConsoleExecuteActionHandler
implements Disposable {
    private static final Logger LOG = Logger.getInstance(PhpDebuggerConsoleExecuteActionHandler.class);
    private static final Key STRING_KEY = new Key("PHP_DEBUG_STRING");
    private static final Key NUMBER_KEY = new Key("PHP_DEBUG_NUMBER");
    private static final Key KEYWORD_KEY = new Key("PHP_DEBUG_KEYWORD");
    private XDebugProcess myDebugProcess;
    @Nullable
    private PhpDebugConsoleCommand myCommand;

    public PhpDebuggerConsoleExecuteActionHandler(@NotNull XDebugProcess debugProcess) {
        if (debugProcess == null) {
            PhpDebuggerConsoleExecuteActionHandler.$$$reportNull$$$0(0);
        }
        super(true);
        this.myDebugProcess = debugProcess;
        debugProcess.getSession().addSessionListener(new XDebugSessionListener(){

            public void stackFrameChanged() {
                this.updateConsoleContext();
            }

            private void updateConsoleContext() {
                XDebugSession session = PhpDebuggerConsoleExecuteActionHandler.this.myDebugProcess.getSession();
                ConsoleView consoleView = session.getConsoleView();
                if (consoleView instanceof LanguageConsoleView) {
                    ApplicationManager.getApplication().runReadAction(() -> {
                        PsiElement context = PhpDebuggerEditorsProvider.getContextElement(session.getProject(), session.getCurrentPosition());
                        PhpExpressionCodeFragmentImpl consolePsiFile = (PhpExpressionCodeFragmentImpl)((LanguageConsoleView)consoleView).getFile();
                        consolePsiFile.setContext(context);
                    });
                }
            }

            public void sessionResumed() {
                this.updateConsoleContext();
            }

            public void sessionPaused() {
                this.updateConsoleContext();
            }
        });
    }

    protected void beforeExecution(@NotNull LanguageConsoleView consoleView) {
        PsiFile file;
        PhpProjectDebugConfiguration.State state;
        boolean importContext;
        if (consoleView == null) {
            PhpDebuggerConsoleExecuteActionHandler.$$$reportNull$$$0(1);
        }
        XSourcePosition position = (importContext = (state = PhpProjectDebugConfiguration.getInstance((file = consoleView.getFile()).getProject()).getState()).isImportUseStatementsFromContext()) ? this.myDebugProcess.getSession().getCurrentPosition() : null;
        this.myCommand = PhpDebugCommandFactory.createCommand(file, position);
    }

    public boolean isEmptyCommandExecutionAllowed() {
        return false;
    }

    protected void execute(@NotNull String text, final @NotNull LanguageConsoleView console) {
        String textToEvaluate;
        if (text == null) {
            PhpDebuggerConsoleExecuteActionHandler.$$$reportNull$$$0(2);
        }
        if (console == null) {
            PhpDebuggerConsoleExecuteActionHandler.$$$reportNull$$$0(3);
        }
        if (this.myDebugProcess == null) {
            LOG.warn("Can not evaluate expression, debugger process is already disposed");
            return;
        }
        final PhpDebugConsoleCommand command = this.myCommand;
        this.myCommand = null;
        final XDebuggerEvaluator evaluator = this.myDebugProcess.getEvaluator();
        if (!(evaluator instanceof PhpEvaluator)) {
            return;
        }
        String string = textToEvaluate = command == null ? text : command.prepareCommandText(text);
        if (StringUtil.isEmpty((String)textToEvaluate)) {
            return;
        }
        ((PhpEvaluator)evaluator).evaluateCodeFragment(textToEvaluate, new PhpEvaluationResultProcessor(){

            @Override
            public void success(final @NotNull String value, @NotNull TypeInfo typeInfo, @NotNull PhpNavigatableValue navigatableValue) {
                if (value == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (typeInfo == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (navigatableValue == null) {
                    2.$$$reportNull$$$0(2);
                }
                XDebugSession session = PhpDebuggerConsoleExecuteActionHandler.this.myDebugProcess.getSession();
                if (command != null) {
                    if (command.isError(value)) {
                        PhpDebuggerConsoleExecuteActionHandler.this.printResult(console, value, ConsoleViewContentType.NORMAL_OUTPUT);
                        this.error(null);
                        return;
                    }
                    command.updateSession(session);
                }
                final ConsoleViewContentType type = ConsoleViewContentType.getConsoleViewType((Key)PhpDebuggerConsoleExecuteActionHandler.getValueKey(typeInfo));
                PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(session.getProject()).getState();
                if (state.isShowArrayChildrenInRepl() && (navigatableValue.isArray() || navigatableValue.isObject())) {
                    PhpEvaluationResultProcessor processor2 = new PhpEvaluationResultProcessor(){

                        @Override
                        public void success(@NotNull String value2, @NotNull TypeInfo typeInfo, @NotNull PhpNavigatableValue navigatableValue) {
                            if (value2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (typeInfo == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (navigatableValue == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            PhpDebuggerConsoleExecuteActionHandler.this.printResult(console, value2, type);
                        }

                        @Override
                        public void error(@NotNull String errorMessage) {
                            if (errorMessage == null) {
                                1.$$$reportNull$$$0(3);
                            }
                            PhpDebuggerConsoleExecuteActionHandler.this.printResult(console, value, type);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "value";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "typeInfo";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "navigatableValue";
                                    break;
                                }
                                case 3: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "errorMessage";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/jetbrains/php/debug/common/PhpDebuggerConsoleExecuteActionHandler$2$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "success";
                                    break;
                                }
                                case 3: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "error";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    ((PhpEvaluator)evaluator).evaluateCodeFragment("var_export(" + navigatableValue.getEvaluationExpression() + ", true)", processor2);
                } else {
                    PhpDebuggerConsoleExecuteActionHandler.this.printResult(console, value, type);
                }
            }

            @Override
            public void error(@Nullable String defaultErrorMessage) {
                PhpEvaluationErrorHandler.handle((PhpEvaluator)evaluator, (NullableConsumer<? super String>)((NullableConsumer)message -> {
                    String prepared;
                    String string = prepared = StringUtil.isNotEmpty((String)defaultErrorMessage) ? StringUtil.notNullize((String)message, (String)defaultErrorMessage) : message;
                    if (StringUtil.isNotEmpty((String)prepared)) {
                        PhpDebuggerConsoleExecuteActionHandler.this.printResult(console, prepared, ConsoleViewContentType.ERROR_OUTPUT);
                    }
                }));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "typeInfo";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "navigatableValue";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/debug/common/PhpDebuggerConsoleExecuteActionHandler$2";
                objectArray[2] = "success";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private static Key getValueKey(TypeInfo typeInfo) {
        if (typeInfo.isBoolean() || typeInfo.isNull()) {
            Key key = KEYWORD_KEY;
            if (key == null) {
                PhpDebuggerConsoleExecuteActionHandler.$$$reportNull$$$0(4);
            }
            return key;
        }
        if (typeInfo.isNumber()) {
            Key key = NUMBER_KEY;
            if (key == null) {
                PhpDebuggerConsoleExecuteActionHandler.$$$reportNull$$$0(5);
            }
            return key;
        }
        if (typeInfo.isString()) {
            Key key = STRING_KEY;
            if (key == null) {
                PhpDebuggerConsoleExecuteActionHandler.$$$reportNull$$$0(6);
            }
            return key;
        }
        Key key = ProcessOutputTypes.STDOUT;
        if (key == null) {
            PhpDebuggerConsoleExecuteActionHandler.$$$reportNull$$$0(7);
        }
        return key;
    }

    protected void printResult(@NotNull LanguageConsoleView console, @NotNull String result, @NotNull ConsoleViewContentType contentType) {
        if (console == null) {
            PhpDebuggerConsoleExecuteActionHandler.$$$reportNull$$$0(8);
        }
        if (result == null) {
            PhpDebuggerConsoleExecuteActionHandler.$$$reportNull$$$0(9);
        }
        if (contentType == null) {
            PhpDebuggerConsoleExecuteActionHandler.$$$reportNull$$$0(10);
        }
        console.print("\u200c", ConsoleViewContentType.NORMAL_OUTPUT);
        console.print(result, contentType);
        console.print("\n\n", ConsoleViewContentType.NORMAL_OUTPUT);
    }

    public void dispose() {
        if (this.myDebugProcess instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myDebugProcess));
        } else {
            this.myDebugProcess = null;
        }
    }

    static {
        ConsoleViewContentType.registerNewConsoleViewType((Key)STRING_KEY, (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        ConsoleViewContentType.registerNewConsoleViewType((Key)NUMBER_KEY, (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
        ConsoleViewContentType.registerNewConsoleViewType((Key)KEYWORD_KEY, (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/common/PhpDebuggerConsoleExecuteActionHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/common/PhpDebuggerConsoleExecuteActionHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "beforeExecution";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "printResult";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

