/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.connection;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.util.connection.PhpConnectionInitCallback;
import com.jetbrains.php.util.connection.PhpDebugConnectionException;
import com.jetbrains.php.util.connection.PhpProgressAwareInitCallback;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpConnectionInitializationTask
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance(PhpConnectionInitializationTask.class);
    @NotNull
    private final ThrowableRunnable<? extends PhpDebugConnectionException> myRunnable;
    @Nullable
    private final PhpConnectionInitCallback myCallback;
    @NotNull
    @Nls
    private final String myConnectionType;
    private final long myTimeoutMs;
    private final Semaphore myDone;
    @Nls
    private String myError;

    public PhpConnectionInitializationTask(@NotNull ThrowableRunnable<? extends PhpDebugConnectionException> runnable, @Nullable PhpConnectionInitCallback callback, @NotNull @Nls String connectionType, long timeoutMs) {
        if (runnable == null) {
            PhpConnectionInitializationTask.$$$reportNull$$$0(0);
        }
        if (connectionType == null) {
            PhpConnectionInitializationTask.$$$reportNull$$$0(1);
        }
        super(null, PhpBundle.message("xdebug.initializing.debugger.connection", connectionType), true, ALWAYS_BACKGROUND);
        this.myDone = new Semaphore();
        this.myError = null;
        this.myRunnable = runnable;
        this.myCallback = callback;
        this.myConnectionType = connectionType;
        this.myTimeoutMs = timeoutMs;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            PhpConnectionInitializationTask.$$$reportNull$$$0(2);
        }
        this.executeInCurrentProcess();
    }

    private void executeInCurrentProcess() {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Initializing incoming PHP debug sessions connection");
            }
            this.myRunnable.run();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Initialized incoming PHP debug sessions connection");
            }
        }
        catch (PhpDebugConnectionException e) {
            this.myError = e.getMessage();
        }
        finally {
            this.myDone.up();
        }
    }

    private void executeWithProgressAndWait() {
        Ref indicator = new Ref(null);
        this.myDone.down();
        ApplicationManager.getApplication().invokeLater(() -> {
            indicator.set((Object)new BackgroundableProcessIndicator((Task.Backgroundable)this));
            ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)this, (ProgressIndicator)indicator.get());
        });
        this.myDone.waitFor(this.myTimeoutMs);
        if (StringUtil.isEmpty((String)this.myError) && !this.myDone.isUp()) {
            this.myError = PhpBundle.message("xdebug.initializing.connection.failed.with.timeout", this.myConnectionType);
        }
        if (((BackgroundableProcessIndicator)indicator.get()).isRunning()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Cancel initialization of incoming PHP debug sessions connection");
            }
            ((BackgroundableProcessIndicator)indicator.get()).cancel();
        }
    }

    public boolean execute() {
        boolean executeInProgress;
        boolean bl = executeInProgress = !(this.myCallback instanceof PhpProgressAwareInitCallback) || ((PhpProgressAwareInitCallback)this.myCallback).wrapInProgress();
        if (executeInProgress) {
            this.executeWithProgressAndWait();
        } else {
            this.executeInCurrentProcess();
        }
        if (this.myCallback != null) {
            this.myCallback.onInit(this.myError);
        }
        return StringUtil.isEmpty((String)this.myError);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/connection/PhpConnectionInitializationTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

