/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.listener;

import com.intellij.execution.ExecutionException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.net.NetUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.connection.PhpDebugServer;
import com.jetbrains.php.debug.xdebug.XdebugExtension;
import com.jetbrains.php.debug.xdebug.cloud.XdebugCloudSettings;
import com.jetbrains.php.debug.xdebug.cloud.connection.XdebugCloudConnectionManager;
import com.jetbrains.php.debug.xdebug.connection.XdebugExternalConnectionsProjectManager;
import com.jetbrains.php.debug.xdebug.connection.XdebugServerConnectionManager;
import com.jetbrains.php.debug.zend.ZendDebuggerExtension;
import com.jetbrains.php.debug.zend.connection.ZendDebuggerExternalConnectionsProjectManager;
import com.jetbrains.php.debug.zend.connection.ZendDebuggerServerConnectionManager;
import com.jetbrains.php.debug.zend.settingsBroadcasting.ZendDebuggerBroadcastingServer;
import com.jetbrains.php.debug.zend.settingsBroadcasting.ZendDebuggerBroadcastingServerConnectionManager;
import com.jetbrains.php.util.connection.ServerConnection;
import com.jetbrains.php.util.connection.ServerConnectionListener;
import com.jetbrains.php.util.connection.ServerConnectionStatus;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpDebugExternalConnectionsAccepter
implements ServerConnectionListener<ServerConnection>,
Disposable {
    public static final String NOTIFICATION_ID = "PhpDebugListener";
    private final List<ServerConnection> myServerConnectionList;
    private final Object myLock;
    private final Project myProject;
    private final PhpProjectDebugConfiguration myProjectDebugConfiguration;
    private volatile boolean isDisposing;

    public PhpDebugExternalConnectionsAccepter(@NotNull Project project) {
        if (project == null) {
            PhpDebugExternalConnectionsAccepter.$$$reportNull$$$0(0);
        }
        this.myServerConnectionList = new ArrayList<ServerConnection>();
        this.myLock = new Object();
        this.isDisposing = false;
        this.myProject = project;
        this.myProjectDebugConfiguration = PhpProjectDebugConfiguration.getInstance(project);
        XdebugExternalConnectionsProjectManager.getInstance(this.myProject);
        ZendDebuggerExternalConnectionsProjectManager.getInstance(this.myProject);
    }

    public static PhpDebugExternalConnectionsAccepter getInstance(Project project) {
        return (PhpDebugExternalConnectionsAccepter)project.getService(PhpDebugExternalConnectionsAccepter.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreListeningState() {
        PhpProjectDebugConfiguration.State state = this.myProjectDebugConfiguration.getState();
        Object object = this.myLock;
        synchronized (object) {
            if (state.isListeningStarted() && !this.isStarted()) {
                this.start();
                ((StateChangedListener)this.myProject.getMessageBus().syncPublisher(StateChangedListener.TOPIC)).stateChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSwitch() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.isStarted()) {
                this.stop();
            } else {
                this.start();
            }
        }
        ((StateChangedListener)this.myProject.getMessageBus().syncPublisher(StateChangedListener.TOPIC)).stateChanged();
    }

    private void start() {
        PhpProjectDebugConfiguration.State state = this.myProjectDebugConfiguration.getState();
        if (state.isXDebugCanAcceptExternalConnections()) {
            XdebugCloudSettings.State cloudState = XdebugCloudSettings.getInstance(this.myProject).getState();
            if (cloudState.isEnabled()) {
                try {
                    this.start(XdebugCloudConnectionManager.getInstance().start(cloudState.getCloudId(), cloudState.getCloudHost(), cloudState.getCloudPort(), error -> {
                        if (StringUtil.isNotEmpty((String)error)) {
                            this.notify(PhpBundle.message("xdebug.cloud.cannot.connect", new Object[0]), error, new AnAction[0]);
                        }
                    }));
                }
                catch (ExecutionException e) {
                    this.notify(PhpBundle.message("xdebug.cloud.cannot.connect", new Object[0]), e.getMessage(), new AnAction[0]);
                }
            } else {
                this.connectToXDebugPort(state);
            }
        }
        if (state.isZendDebuggerCanAcceptExternalConnections()) {
            int zendDebuggerDebugPort = state.getZendDebuggerDebugPort();
            try {
                this.start((PhpDebugServer)ZendDebuggerServerConnectionManager.getInstance().start(zendDebuggerDebugPort));
            }
            catch (ExecutionException e) {
                this.notify(PhpBundle.message("debug.cannot.start.listening.for.connections.from.0", ZendDebuggerExtension.INSTANCE.getName()), e.getMessage(), new AnAction[0]);
            }
            try {
                int settingsBroadcastingPort = state.getZendDebuggerSettingsBroadcastingPort();
                this.start(ZendDebuggerBroadcastingServerConnectionManager.getInstance().start(this.myProject, settingsBroadcastingPort, zendDebuggerDebugPort));
            }
            catch (ExecutionException e) {
                this.notify(PhpBundle.message("debug.cannot.start", ZendDebuggerBroadcastingServer.getDescriptiveNameText()), e.getMessage(), new AnAction[0]);
            }
        }
        state.setListeningStarted(this.isStarted());
    }

    private void connectToXDebugPort(PhpProjectDebugConfiguration.State state) {
        HashSet<Integer> xDebugDebugPorts = new HashSet<Integer>(state.getXDebugDebugPorts());
        int busyPorts = 0;
        for (Integer port : xDebugDebugPorts) {
            try {
                this.start((PhpDebugServer)XdebugServerConnectionManager.getInstance().start(port));
            }
            catch (ExecutionException e) {
                ++busyPorts;
            }
        }
        if (busyPorts == xDebugDebugPorts.size()) {
            int availableSocketPort;
            try {
                availableSocketPort = NetUtils.findAvailableSocketPort();
            }
            catch (IOException ex) {
                this.notify(PhpBundle.message("debug.cannot.find.port", new Object[0]), PhpBundle.message("debug.check.firewall", new Object[0]), new AnAction[0]);
                return;
            }
            List<Integer> ports = state.getXDebugDebugPorts();
            ports.add(availableSocketPort);
            state.setXDebugDebugPorts(ports);
            this.notify(PhpBundle.message("debug.cannot.start.listening.for.connections.from.0", XdebugExtension.INSTANCE.getName()), PhpBundle.message("debug.ports.is.updated", availableSocketPort, "xdebug.client_port=" + availableSocketPort), new AnAction(this, PhpBundle.message("action.copy.port.to.clipboard.text", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(new StringSelection(String.valueOf(availableSocketPort)), null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/debug/listener/PhpDebugExternalConnectionsAccepter$1", "actionPerformed"));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        Object object = this.myLock;
        synchronized (object) {
            for (ServerConnection serverConnection : this.myServerConnectionList) {
                serverConnection.removeListener(this);
                if (serverConnection instanceof PhpDebugServer) {
                    ((PhpDebugServer)serverConnection).unregisterExternalConnectionListener(this);
                    continue;
                }
                if (!(serverConnection instanceof ZendDebuggerBroadcastingServer)) continue;
                ((ZendDebuggerBroadcastingServer)serverConnection).unregisterExternalConnectionListener(this);
            }
            this.myServerConnectionList.clear();
            PhpProjectDebugConfiguration.State state = this.myProjectDebugConfiguration.getState();
            state.setListeningStarted(this.isStarted());
        }
    }

    private void start(@NotNull PhpDebugServer<?> debugServer) throws ExecutionException {
        if (debugServer == null) {
            PhpDebugExternalConnectionsAccepter.$$$reportNull$$$0(1);
        }
        debugServer.addListener(this);
        debugServer.registerExternalConnectionListener(this);
        this.myServerConnectionList.add(debugServer);
    }

    private void start(@NotNull ZendDebuggerBroadcastingServer broadcastingServer) throws ExecutionException {
        if (broadcastingServer == null) {
            PhpDebugExternalConnectionsAccepter.$$$reportNull$$$0(2);
        }
        broadcastingServer.addListener(this);
        broadcastingServer.registerExternalConnectionListener(this);
        this.myServerConnectionList.add(broadcastingServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.myLock;
        synchronized (object) {
            return !this.myServerConnectionList.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statusChanged(@NotNull ServerConnection serverConnection, @NotNull ServerConnectionStatus status) {
        if (serverConnection == null) {
            PhpDebugExternalConnectionsAccepter.$$$reportNull$$$0(3);
        }
        if (status == null) {
            PhpDebugExternalConnectionsAccepter.$$$reportNull$$$0(4);
        }
        Object object = this.myLock;
        synchronized (object) {
            switch (status) {
                case STARTED: 
                case STOPPED: {
                    this.myServerConnectionList.remove(serverConnection);
                    if (this.isDisposing) break;
                    this.myProjectDebugConfiguration.getState().setListeningStarted(this.isStarted());
                }
            }
        }
    }

    public void dispose() {
        this.isDisposing = true;
        this.stop();
    }

    private void notify(@NotNull @Nls String title, @Nls @NotNull String text, AnAction ... anActions) {
        if (title == null) {
            PhpDebugExternalConnectionsAccepter.$$$reportNull$$$0(5);
        }
        if (text == null) {
            PhpDebugExternalConnectionsAccepter.$$$reportNull$$$0(6);
        }
        Notification notification = new Notification(NOTIFICATION_ID, title, text, NotificationType.WARNING);
        notification.addActions(List.of(anActions));
        Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
    }

    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugServer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "broadcastingServer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverConnection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/listener/PhpDebugExternalConnectionsAccepter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "statusChanged";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "notify";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface StateChangedListener {
        public static final Topic<StateChangedListener> TOPIC = Topic.create((String)"stateChanged", StateChangedListener.class);

        public void stateChanged();
    }
}

