/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.template;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.php.util.PhpConfigurationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTemplateDebugStateService
implements PersistentStateComponent<State> {
    private final Project myProject;
    private String myCachePath;

    public PhpTemplateDebugStateService(Project project) {
        this.myProject = project;
    }

    public boolean isWellConfigured() {
        return !StringUtil.isEmptyOrSpaces((String)this.myCachePath);
    }

    @NlsSafe
    public String getCachePath() {
        return this.myCachePath;
    }

    public void setCachePath(String cachePath) {
        this.myCachePath = cachePath;
    }

    @Nullable
    public State getState() {
        return new State(this.myCachePath);
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            PhpTemplateDebugStateService.$$$reportNull$$$0(0);
        }
        this.myCachePath = state.getCachePath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/php/debug/template/PhpTemplateDebugStateService", "loadState"));
    }

    @Tag(value="TemplateDebugState")
    public static class State {
        private String myCachePath;

        public State() {
            this(null);
        }

        private State(@Nullable String cachePath) {
            this.myCachePath = cachePath;
        }

        @Transient
        @Nullable
        public String getCachePath() {
            return this.myCachePath;
        }

        public void setCachePath(String cachePath) {
            this.myCachePath = cachePath;
        }

        @Tag(value="cachePath")
        @Nullable
        public String getSerializedCachePath() {
            return PhpConfigurationUtil.serializePath(this.myCachePath);
        }

        public void setSerializedCachePath(@Nullable String cachePath) {
            this.myCachePath = PhpConfigurationUtil.deserializePath(cachePath);
        }
    }
}

