/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.template;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.php.debug.template.PhpTemplateDebugStateService;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class PhpTemplateLanguagePathMapper {
    public static final ExtensionPointName<PhpTemplateLanguagePathMapper> EP_NAME = ExtensionPointName.create((String)"com.intellij.php.debug.templateLanguage");

    public abstract boolean isTemplateFileType(@NotNull FileType var1);

    public abstract boolean isGeneratedFile(@NotNull VirtualFile var1, @NotNull Project var2);

    public abstract XSourcePosition mapToPhp(@NotNull XSourcePosition var1, @NotNull Project var2, @NotNull PhpPathMapper var3);

    public abstract XSourcePosition mapToTemplate(@Nullable XSourcePosition var1, @NotNull Project var2, @NotNull PhpPathMapper var3);

    public static boolean isTemplateFile(@NotNull VirtualFile file) {
        if (file == null) {
            PhpTemplateLanguagePathMapper.$$$reportNull$$$0(0);
        }
        FileType fileType = file.getFileType();
        return ContainerUtil.exists((Object[])((PhpTemplateLanguagePathMapper[])EP_NAME.getExtensions()), handler -> handler.isTemplateFileType(fileType));
    }

    public static PhpTemplateLanguagePathMapper getInstance(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            PhpTemplateLanguagePathMapper.$$$reportNull$$$0(1);
        }
        if (project == null) {
            PhpTemplateLanguagePathMapper.$$$reportNull$$$0(2);
        }
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)PhpFileType.INSTANCE) || FileTypeRegistry.getInstance().isFileOfType(file, (FileType)PlainTextFileType.INSTANCE) ? (PhpTemplateLanguagePathMapper)ContainerUtil.find((Object[])((PhpTemplateLanguagePathMapper[])EP_NAME.getExtensions()), handler -> handler.isGeneratedFile(file, project)) : (PhpTemplateLanguagePathMapper)ContainerUtil.find((Object[])((PhpTemplateLanguagePathMapper[])EP_NAME.getExtensions()), handler -> handler.isTemplateFileType(file.getFileType()));
    }

    @NotNull
    public static Collection<VirtualFile> getTemplatesMappingPaths(@NotNull Project project) {
        if (project == null) {
            PhpTemplateLanguagePathMapper.$$$reportNull$$$0(3);
        }
        SmartList mappingPaths = new SmartList();
        for (PhpTemplateLanguagePathMapper mapper : (PhpTemplateLanguagePathMapper[])EP_NAME.getExtensions()) {
            mappingPaths.addAll(mapper.getTemplateMappingPaths(project));
        }
        SmartList smartList = mappingPaths;
        if (smartList == null) {
            PhpTemplateLanguagePathMapper.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    @NotNull
    protected Collection<VirtualFile> getTemplateMappingPaths(@NotNull Project project) {
        PhpTemplateDebugStateService stateService;
        if (project == null) {
            PhpTemplateLanguagePathMapper.$$$reportNull$$$0(5);
        }
        if ((stateService = this.getTemplateDebugInstance(project)) == null || !stateService.isWellConfigured()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                PhpTemplateLanguagePathMapper.$$$reportNull$$$0(6);
            }
            return list;
        }
        String cachePath = stateService.getCachePath();
        VirtualFile cacheDir = cachePath != null ? VfsUtil.findFile((Path)Paths.get(cachePath, new String[0]), (boolean)true) : null;
        List list = cacheDir != null ? new SmartList((Object)cacheDir) : ContainerUtil.emptyList();
        if (list == null) {
            PhpTemplateLanguagePathMapper.$$$reportNull$$$0(7);
        }
        return list;
    }

    protected abstract PhpTemplateDebugStateService getTemplateDebugInstance(@NotNull Project var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/template/PhpTemplateLanguagePathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/template/PhpTemplateLanguagePathMapper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplatesMappingPaths";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateMappingPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTemplatesMappingPaths";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateMappingPaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

