/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.listener.PhpDebugExternalConnectionsAccepter;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public abstract class PhpIncomingRemoteConnectionDialog
extends DialogWrapper {
    private JPanel myNorthPanel;
    private JTextField myServerNameTextField;
    private JTextField myOriginalUrlTextField;
    private JTextField myRemotePathTextField;
    private JTextField myServerPortTextField;
    private JLabel myUrlLabel;
    protected final String myRemoteFilePath;
    protected final String myServerName;
    protected final String myUrl;
    protected final int myServerPort;
    protected AbstractAction turnOffAction;
    @NotNull
    private final String myClientName;

    protected PhpIncomingRemoteConnectionDialog(@NotNull String clientName, @NotNull String remoteFilePath, @NotNull String serverName, int serverPort, @NotNull String requestUri) {
        if (clientName == null) {
            PhpIncomingRemoteConnectionDialog.$$$reportNull$$$0(0);
        }
        if (remoteFilePath == null) {
            PhpIncomingRemoteConnectionDialog.$$$reportNull$$$0(1);
        }
        if (serverName == null) {
            PhpIncomingRemoteConnectionDialog.$$$reportNull$$$0(2);
        }
        if (requestUri == null) {
            PhpIncomingRemoteConnectionDialog.$$$reportNull$$$0(3);
        }
        super((Project)null);
        this.myClientName = clientName;
        this.myRemoteFilePath = remoteFilePath;
        this.myServerName = serverName;
        this.myUrl = requestUri;
        this.myServerPort = serverPort;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.turnOffAction = new DialogWrapper.DialogWrapperAction(PhpBundle.message("button.turn.off.listening", objectArray)){

            protected void doAction(ActionEvent e) {
                PhpDebugExternalConnectionsAccepter.getInstance(PhpIncomingRemoteConnectionDialog.this.getSelectedProject()).doSwitch();
                PhpIncomingRemoteConnectionDialog.this.doCancelAction();
            }

            public void setEnabled(boolean newValue) {
                super.setEnabled(newValue);
                JButton button = PhpIncomingRemoteConnectionDialog.this.getButton((Action)((Object)this));
                if (button != null) {
                    button.setEnabled(this.isEnabled());
                }
            }

            public boolean isEnabled() {
                return PhpIncomingRemoteConnectionDialog.this.isSelected() && PhpDebugExternalConnectionsAccepter.getInstance(PhpIncomingRemoteConnectionDialog.this.getSelectedProject()).isStarted();
            }
        };
    }

    protected void init() {
        super.init();
        this.setTitle(PhpBundle.message("debug.incoming.connection.title.0", this.myClientName));
        this.setOKButtonText(PhpBundle.message("debug.accept.connection", new Object[0]));
        this.myOKAction.setEnabled(this.isSelected());
        this.setCancelButtonText(PhpBundle.message("debug.ignore.connection", new Object[0]));
        if (StringUtil.isEmptyOrSpaces((String)this.myUrl)) {
            this.myUrlLabel.setVisible(false);
            this.myOriginalUrlTextField.setVisible(false);
        } else {
            this.myOriginalUrlTextField.setText(this.myUrl);
        }
        this.myServerNameTextField.setText(this.myServerName);
        this.myRemotePathTextField.setText(this.myRemoteFilePath);
        this.myServerPortTextField.setText(String.valueOf(this.myServerPort));
        PhpUiUtil.requestFocusIfAppInactive(this);
    }

    protected Action @NotNull [] createActions() {
        this.turnOffAction.putValue("ShortDescription", PhpBundle.message("button.turn.off.listening.descr", new Object[0]));
        Action[] actionArray = new Action[]{this.turnOffAction, this.myOKAction, this.myCancelAction};
        if (actionArray == null) {
            PhpIncomingRemoteConnectionDialog.$$$reportNull$$$0(4);
        }
        return actionArray;
    }

    protected abstract Project getSelectedProject();

    protected abstract boolean isSelected();

    protected JComponent createNorthPanel() {
        return this.myNorthPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestUri";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/ui/PhpIncomingRemoteConnectionDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/ui/PhpIncomingRemoteConnectionDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JLabel jLabel;
        JPanel jPanel;
        this.myNorthPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 15, 0), -1, -1, false, false));
        this.myUrlLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpIncomingRemoteConnectionDialog.class).getString("PhpIncomingConnectionDialog.request.uri"));
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpIncomingRemoteConnectionDialog.class).getString("PhpIncomingConnectionDialog.file.path.on.server"));
        jPanel.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpIncomingRemoteConnectionDialog.class).getString("PhpIncomingConnectionDialog.server.name"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myServerNameTextField = jTextField4 = new JTextField();
        jTextField4.setEditable(false);
        jPanel.add((Component)jTextField4, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myOriginalUrlTextField = jTextField3 = new JTextField();
        jTextField3.setEditable(false);
        jPanel.add((Component)jTextField3, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myRemotePathTextField = jTextField2 = new JTextField();
        jTextField2.setEditable(false);
        jPanel.add((Component)jTextField2, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpIncomingRemoteConnectionDialog.class).getString("PhpIncomingConnectionDialog.server.port"));
        jPanel.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myServerPortTextField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel.setLabelFor(jTextField3);
        jLabel2.setLabelFor(jTextField2);
        jLabel3.setLabelFor(jTextField4);
        jLabel4.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myNorthPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

