/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.stepFilters.PhpStepFiltersConfiguration;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StackGetRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StackGetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.model.DbgpStackFrame;
import com.jetbrains.php.debug.xdebug.handlers.DbgpResponseHandler;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class XdebugAddMethodToSkipListAction
extends DumbAwareAction {
    public static final String ID = "XdebugAddMethodToSkipListAction";
    public static final String SPECIAL_FUNCTION_PREFIX = "{";
    PhpDebugProcess<XdebugConnection> myProcess;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            XdebugAddMethodToSkipListAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            XdebugAddMethodToSkipListAction.$$$reportNull$$$0(1);
        }
        XDebugSession debugSession = (XDebugSession)e.getData(XDebugSession.DATA_KEY);
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && debugSession != null && debugSession.getDebugProcess() instanceof PhpDebugProcess);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            XdebugAddMethodToSkipListAction.$$$reportNull$$$0(2);
        }
        if (this.myProcess != null) {
            XdebugConnection connection = this.myProcess.getConnection();
            Project project = e.getProject();
            if (project != null) {
                final PhpStepFiltersConfiguration.State configuration = PhpStepFiltersConfiguration.getInstance(project).getState();
                if (connection != null) {
                    connection.send(new StackGetRequest(), new DbgpResponseHandler<StackGetResponse>(){

                        @Override
                        public void onSuccessResponse(@NotNull StackGetResponse message) {
                            String functionName;
                            if (message == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            assert (!message.getStackFrames().isEmpty());
                            DbgpStackFrame dbgpStackFrame = message.getStackFrames().get(0);
                            ArrayList<String> skippedFunctions = new ArrayList<String>(configuration.getSkippedFunctions());
                            if (!skippedFunctions.contains(functionName = dbgpStackFrame.getFunctionName()) && !functionName.startsWith(XdebugAddMethodToSkipListAction.SPECIAL_FUNCTION_PREFIX)) {
                                skippedFunctions.add(functionName);
                                PhpDebugUtil.getNotificationGroup().createNotification(PhpBundle.message("debug.function.was.added.to.skip.list", functionName), MessageType.WARNING).notify(XdebugAddMethodToSkipListAction.this.myProcess.getSession().getProject());
                            }
                            configuration.setSkippedFunctions(skippedFunctions);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/xdebug/actions/XdebugAddMethodToSkipListAction$1", "onSuccessResponse"));
                        }
                    });
                    this.myProcess.startStepOut(this.myProcess.getSession().getSuspendContext());
                }
            }
        }
    }

    public PhpDebugProcess<XdebugConnection> getProcess() {
        return this.myProcess;
    }

    public void setProcess(PhpDebugProcess<XdebugConnection> process) {
        this.myProcess = process;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/actions/XdebugAddMethodToSkipListAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/actions/XdebugAddMethodToSkipListAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

