/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.cloud;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="PhpXdebugCloud", storages={@Storage(value="$WORKSPACE_FILE$")})
public class XdebugCloudSettings
implements PersistentStateComponent<State> {
    private static final String DEFAULT_BASE_HOST = "cloud.xdebug.com";
    private static final int DEFAULT_PORT = 9021;
    private State myState = new State();

    public static XdebugCloudSettings getInstance(@NotNull Project project) {
        if (project == null) {
            XdebugCloudSettings.$$$reportNull$$$0(0);
        }
        return (XdebugCloudSettings)project.getService(XdebugCloudSettings.class);
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            XdebugCloudSettings.$$$reportNull$$$0(1);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            XdebugCloudSettings.$$$reportNull$$$0(2);
        }
        this.myState = state;
    }

    @NotNull
    public static String calculateHost(@NotNull String cloudId, @NotNull String baseHost) {
        if (cloudId == null) {
            XdebugCloudSettings.$$$reportNull$$$0(3);
        }
        if (baseHost == null) {
            XdebugCloudSettings.$$$reportNull$$$0(4);
        }
        CRC32 checksum = new CRC32();
        checksum.update(cloudId.getBytes(StandardCharsets.UTF_8));
        int last = (int)(checksum.getValue() & 0xFL);
        char letter = (char)((long)last + 97L);
        String string = letter + "." + baseHost;
        if (string == null) {
            XdebugCloudSettings.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/cloud/XdebugCloudSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cloudId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/cloud/XdebugCloudSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calculateHost";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }

    public static class State {
        private boolean myIsEnabled = false;
        private boolean myIsOnPremiseCloud = false;
        private String myCloudId = null;
        private String myOnPremiseCloudHost = null;
        private int myOnPremisePort = 9021;

        @Attribute(value="enabled")
        public boolean isEnabled() {
            return this.myIsEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.myIsEnabled = enabled;
        }

        @Attribute(value="on_premise")
        public boolean isOnPremiseCloud() {
            return this.myIsOnPremiseCloud;
        }

        public void setOnPremiseCloud(boolean onPremiseCloud) {
            this.myIsOnPremiseCloud = onPremiseCloud;
        }

        @Attribute(value="user_id")
        @Nullable
        public String getCloudId() {
            return this.myCloudId;
        }

        public void setCloudId(@Nullable String cloudId) {
            this.myCloudId = StringUtil.trim((String)StringUtil.nullize((String)cloudId));
        }

        @Attribute(value="on_premise_host")
        @Nullable
        public String getOnPremiseCloudHost() {
            return this.myOnPremiseCloudHost;
        }

        public void setOnPremiseCloudHost(@Nullable String proxyHost) {
            this.myOnPremiseCloudHost = StringUtil.nullize((String)proxyHost);
        }

        @Attribute(value="on_premise_port")
        public int getOnPremisePort() {
            return this.myOnPremisePort;
        }

        public void setOnPremisePort(int onPremisePort) {
            this.myOnPremisePort = onPremisePort;
        }

        @Transient
        @Nullable
        public String getCloudHost() {
            if (this.myIsOnPremiseCloud) {
                return this.getOnPremiseCloudHost();
            }
            return StringUtil.isNotEmpty((String)this.myCloudId) ? XdebugCloudSettings.calculateHost(this.myCloudId, XdebugCloudSettings.DEFAULT_BASE_HOST) : null;
        }

        public int getCloudPort() {
            return this.myIsOnPremiseCloud ? this.getOnPremisePort() : 9021;
        }
    }
}

