/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.dbgp.messages;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.io.URLUtil;
import com.jetbrains.php.debug.xdebug.dbgp.DbgpUtil;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpInputMessage;
import com.jetbrains.php.debug.xdebug.dbgp.model.DbgpProperty;
import java.io.IOException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class XdebugVariableNotification
extends DbgpInputMessage {
    private int myLineNumber;
    private DbgpProperty myProperty;
    private String myFilePath;

    @Override
    public DbgpInputMessage deserialize(Element packet) throws IOException {
        String name = packet.getAttributeValue("name");
        if (!StringUtil.equals((CharSequence)name, (CharSequence)"user")) {
            throw new IOException("Invalid type of notification");
        }
        Element locationTag = DbgpUtil.getXdebugTag(packet, "location");
        this.myProperty = XdebugVariableNotification.getPropertyChild(packet);
        if (locationTag != null) {
            String filePath = locationTag.getAttributeValue("filename");
            this.myLineNumber = StringUtilRt.parseInt((String)locationTag.getAttributeValue("lineno"), (int)0);
            String urlFilePath = StringUtil.isNotEmpty((String)filePath) ? VirtualFileManager.extractPath((String)URLUtil.decode((String)filePath)) : "<undefined>";
            this.myFilePath = SystemInfo.isWindows ? StringUtil.trimStart((String)urlFilePath, (String)"/") : urlFilePath;
        }
        return this;
    }

    @NotNull
    public String getPresentableMessage(@NotNull String encoding) {
        if (encoding == null) {
            XdebugVariableNotification.$$$reportNull$$$0(0);
        }
        String string = this.myFilePath + ":" + this.myLineNumber + ":\n" + this.myProperty.getPresentationAsInVarDump(encoding) + "\n";
        if (string == null) {
            XdebugVariableNotification.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/dbgp/messages/XdebugVariableNotification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/dbgp/messages/XdebugVariableNotification";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableMessage";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

