/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.debugger.dfa;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.codeInsight.typeInference.PhpCompositeTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaDelegateBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpIntCapableComparisonState;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.debug.xdebug.dbgp.model.DbgpProperty;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpRangeCheckDfaBasedTypeState;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStateArgumentInfo;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XdebugStackFramePrimitiveOperandDescriptor
implements PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckOperandDescriptor {
    @NotNull
    private final String myStackFrameValue;
    @NotNull
    private final DbgpProperty myProperty;
    @NotNull
    private final PhpLanguageLevel myLanguageLevel;

    public XdebugStackFramePrimitiveOperandDescriptor(@NotNull String stackFrameValue, @NotNull DbgpProperty property, @NotNull PhpLanguageLevel languageLevel) {
        if (stackFrameValue == null) {
            XdebugStackFramePrimitiveOperandDescriptor.$$$reportNull$$$0(0);
        }
        if (property == null) {
            XdebugStackFramePrimitiveOperandDescriptor.$$$reportNull$$$0(1);
        }
        if (languageLevel == null) {
            XdebugStackFramePrimitiveOperandDescriptor.$$$reportNull$$$0(2);
        }
        this.myStackFrameValue = stackFrameValue;
        this.myProperty = property;
        this.myLanguageLevel = languageLevel;
    }

    @Override
    public String getText() {
        return this.myStackFrameValue;
    }

    @Override
    public boolean isZero() {
        if (this.myProperty.isNumber()) {
            return this.myStackFrameValue.equals("0") || this.myStackFrameValue.equals("0.0");
        }
        return false;
    }

    @Override
    public boolean isEmptyString() {
        return this.myProperty.isString() && this.myStackFrameValue.isEmpty();
    }

    @Override
    @NotNull
    public List<PhpStateArgumentInfo> unwrapInfos(boolean global) {
        List<PhpStateArgumentInfo> list = Collections.emptyList();
        if (list == null) {
            XdebugStackFramePrimitiveOperandDescriptor.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Nullable
    public Integer getIntValue() {
        if (this.myProperty.isInt()) {
            try {
                return Integer.parseInt(this.myStackFrameValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean isFalse() {
        return PhpLangUtil.equalsIgnoreCase("false", this.myStackFrameValue);
    }

    @Override
    public boolean isTrue() {
        return PhpLangUtil.equalsIgnoreCase("true", this.myStackFrameValue);
    }

    @Override
    @Nullable
    public PhpDfaDelegateBasedTypeState createRangeDelegate(@NotNull PhpIntCapableComparisonState myState, @NotNull PhpDfaBasedTypeState state, boolean global) {
        if (myState == null) {
            XdebugStackFramePrimitiveOperandDescriptor.$$$reportNull$$$0(4);
        }
        if (state == null) {
            XdebugStackFramePrimitiveOperandDescriptor.$$$reportNull$$$0(5);
        }
        if (state instanceof PhpRangeCheckDfaBasedTypeState.PhpIntRangeCheckDfaBasedTypeState) {
            Integer intValue = this.getIntValue();
            if (intValue == null) {
                return null;
            }
            return new PhpCompositeTypeState("EQ", new PhpRangeCheckDfaBasedTypeState.PhpIntRangeCheckDfaBasedTypeState(PhpRangeCheckDfaBasedTypeState.Operand.GREATER_EQ, intValue), new PhpRangeCheckDfaBasedTypeState.PhpIntRangeCheckDfaBasedTypeState(PhpRangeCheckDfaBasedTypeState.Operand.LOWER_EQ, intValue));
        }
        return null;
    }

    @Override
    public boolean nonStrictNullValue() {
        if (this.myProperty.isString()) {
            return this.isEmptyString() || this.myStackFrameValue.equals("0") || this.myStackFrameValue.equals("0.0");
        }
        return this.isZero() || this.isFalse();
    }

    @Override
    public boolean isScalar() {
        return !this.myProperty.isNull();
    }

    @Override
    public boolean nonStringOrSimpleString() {
        return true;
    }

    @Override
    public boolean isAllowedAsStaticValue() {
        return true;
    }

    @Override
    public boolean isStaticConstantReference(boolean global) {
        return false;
    }

    @Override
    public boolean isStringWithoutInterpolations() {
        return this.isStringLiteralExpression();
    }

    @Override
    public boolean areOperandsEquivalent(@NotNull PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckOperandDescriptor otherOperand) {
        if (otherOperand == null) {
            XdebugStackFramePrimitiveOperandDescriptor.$$$reportNull$$$0(6);
        }
        if (otherOperand instanceof PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckOperandPsiBasedDescriptor) {
            return otherOperand.areOperandsEquivalent(this);
        }
        assert (!(otherOperand instanceof XdebugStackFramePrimitiveOperandDescriptor)) : "xdebug stack frame value should never be compared to each other";
        return false;
    }

    @Override
    public boolean canContainSideEffect(boolean global) {
        return false;
    }

    @Override
    public PhpType getTypeFromIdentityCheckOnScalar(boolean global) {
        return PhpType.EMPTY;
    }

    @Override
    public boolean isArrayCreationExpression() {
        return false;
    }

    @Override
    public boolean isStringLiteralExpression() {
        return this.myProperty.isString();
    }

    @Override
    @NotNull
    public PhpLanguageLevel getLanguageLevel() {
        PhpLanguageLevel phpLanguageLevel = this.myLanguageLevel;
        if (phpLanguageLevel == null) {
            XdebugStackFramePrimitiveOperandDescriptor.$$$reportNull$$$0(7);
        }
        return phpLanguageLevel;
    }

    @Override
    @Nullable
    public String getStringContents() {
        return this.myProperty.isString() ? StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeStringCharacters((String)this.myStackFrameValue)) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrameValue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/debugger/dfa/XdebugStackFramePrimitiveOperandDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherOperand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/dfa/XdebugStackFramePrimitiveOperandDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapInfos";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRangeDelegate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "areOperandsEquivalent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7 -> new IllegalStateException(string);
        };
    }
}

