/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.hints;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PhpCodeVisionUsageCollector
extends CounterUsagesCollector {
    public static final EventLogGroup GROUP = new EventLogGroup("php.code.vision", 2);
    public static final String CLASS_LOCATION = "class";
    public static final String INTERFACE_LOCATION = "interface";
    public static final String TRAIT_LOCATION = "trait";
    public static final String ENUM_LOCATION = "enum";
    public static final String ENUM_CASE_LOCATION = "enum case";
    public static final String CLASS_CONST_LOCATION = "class const";
    public static final String FIELD_LOCATION = "field";
    public static final String METHOD_LOCATION = "method";
    public static final String FUNCTION_LOCATION = "function";
    public static final String CONST_LOCATION = "const";
    public static final String UNKNOWN_LOCATION = "unknown";
    public static final StringEventField LOCATION_FIELD = EventFields.String((String)"location", List.of("class", "interface", "trait", "enum", "enum case", "class const", "field", "method", "function", "const", "unknown"));
    public static final CountBucketEventField COUNT_BUCKET = new CountBucketEventField("count_bucket");
    public static final EventId2<String, String> REFERENCES_CLICKED_EVENT_ID = GROUP.registerEvent("references.clicked", (EventField)LOCATION_FIELD, (EventField)COUNT_BUCKET);
    public static final EventId2<String, String> INHERITORS_CLICKED_EVENT_ID = GROUP.registerEvent("inheritors.clicked", (EventField)LOCATION_FIELD, (EventField)COUNT_BUCKET);

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void logReferenceHintClicked(PsiElement location, @NotNull String hint) {
        if (hint == null) {
            PhpCodeVisionUsageCollector.$$$reportNull$$$0(0);
        }
        REFERENCES_CLICKED_EVENT_ID.log((Object)PhpCodeVisionUsageCollector.locationByElement(location), (Object)PhpCodeVisionUsageCollector.toBucket(hint));
    }

    public static void logInheritorsHintClicked(PsiElement location, @NotNull String hint) {
        if (hint == null) {
            PhpCodeVisionUsageCollector.$$$reportNull$$$0(1);
        }
        INHERITORS_CLICKED_EVENT_ID.log((Object)PhpCodeVisionUsageCollector.locationByElement(location), (Object)PhpCodeVisionUsageCollector.toBucket(hint));
    }

    private static String locationByElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpCodeVisionUsageCollector.$$$reportNull$$$0(2);
        }
        if (element instanceof PhpClass) {
            PhpClass clazz = (PhpClass)element;
            if (clazz.isInterface()) {
                return INTERFACE_LOCATION;
            }
            if (clazz.isTrait()) {
                return TRAIT_LOCATION;
            }
            if (clazz.isEnum()) {
                return ENUM_LOCATION;
            }
            return CLASS_LOCATION;
        }
        if (element instanceof Field) {
            Field field = (Field)element;
            return field.isConstant() ? CLASS_CONST_LOCATION : FIELD_LOCATION;
        }
        if (element instanceof PhpEnumCase) {
            return ENUM_CASE_LOCATION;
        }
        if (element instanceof Method) {
            return METHOD_LOCATION;
        }
        if (element instanceof Function) {
            return FUNCTION_LOCATION;
        }
        if (element instanceof Constant) {
            return CONST_LOCATION;
        }
        return UNKNOWN_LOCATION;
    }

    private static String toBucket(String hint) {
        int[] thresholds;
        if (hint.equals("no usages")) {
            return "0";
        }
        int count = StringUtil.parseInt((String)hint.replaceAll("[^0-9]", ""), (int)-1);
        if (count == -1) {
            return "-1";
        }
        for (int threshold : thresholds = new int[]{500, 100, 50, 20}) {
            if (count < threshold) continue;
            return threshold + "+";
        }
        return "<20";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/hints/PhpCodeVisionUsageCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "logReferenceHintClicked";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "logInheritorsHintClicked";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "locationByElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CountBucketEventField
    extends StringEventField {
        private CountBucketEventField(@NotNull String name) {
            if (name == null) {
                CountBucketEventField.$$$reportNull$$$0(0);
            }
            super(name);
        }

        @NotNull
        public List<String> getValidationRule() {
            List<String> list = List.of("{regexp#integer}", "<{regexp#integer}", "{regexp#integer}+");
            if (list == null) {
                CountBucketEventField.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/hints/PhpCodeVisionUsageCollector$CountBucketEventField";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/hints/PhpCodeVisionUsageCollector$CountBucketEventField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValidationRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

