/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.internal;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCreateYoutrackIssueFromFileAction
extends DumbAwareAction {
    private static final String PREFIX = "https://youtrack.jetbrains.com/newIssue?project=WI&description=";

    private static HttpClient createClient() {
        return HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(5L)).build();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            PhpCreateYoutrackIssueFromFileAction.$$$reportNull$$$0(0);
        }
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        if (files != null && files.length > 1) {
            PhpCreateYoutrackIssueFromFileAction.openIssue(PhpCreateYoutrackIssueFromFileAction.composeText(project, files));
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            PhpCreateYoutrackIssueFromFileAction.openIssue(PhpCreateYoutrackIssueFromFileAction.create3v4lEntry(editor.getDocument().getText()));
        }
    }

    protected static void openIssue(@Nullable String entry) {
        if (entry != null) {
            BrowserUtil.browse((String)(PREFIX + URLEncoder.encode(entry, StandardCharsets.UTF_8)));
        }
    }

    private static String composeText(Project project, VirtualFile[] files) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        ArrayList futures = new ArrayList();
        for (VirtualFile file : files) {
            ContainerUtil.addIfNotNull(futures, PhpCreateYoutrackIssueFromFileAction.getAsyncFuture(project, map, file));
        }
        CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).join();
        return Arrays.stream(files).map(VirtualFile::getName).map(name -> {
            String ev4lEntry = (String)map.get(name);
            return ev4lEntry != null ? String.format("File %s: %s", name, ev4lEntry) : null;
        }).filter(Objects::nonNull).collect(Collectors.joining("\n"));
    }

    @Nullable
    private static CompletableFuture<Void> getAsyncFuture(Project project, ConcurrentHashMap<String, String> map, VirtualFile file) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        HttpRequest request = PhpCreateYoutrackIssueFromFileAction.createRequest(psiFile.getText());
        return PhpCreateYoutrackIssueFromFileAction.createClient().sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAccept(response -> {
            String location = PhpCreateYoutrackIssueFromFileAction.getLocation(response);
            if (location != null) {
                map.put(file.getName(), location);
            }
        });
    }

    @Nullable
    protected static String create3v4lEntry(String text) {
        if (text.isEmpty()) {
            return null;
        }
        HttpRequest request = PhpCreateYoutrackIssueFromFileAction.createRequest(text);
        try {
            HttpResponse<String> response = PhpCreateYoutrackIssueFromFileAction.createClient().send(request, HttpResponse.BodyHandlers.ofString());
            String location = PhpCreateYoutrackIssueFromFileAction.getLocation(response);
            if (location != null) {
                return location;
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static String getLocation(HttpResponse<String> response) {
        Optional<String> location;
        if (response.statusCode() == 302 && (location = response.headers().firstValue("Location")).isPresent()) {
            return location.get();
        }
        return null;
    }

    private static HttpRequest createRequest(String text) {
        return HttpRequest.newBuilder().uri(URI.create("https://3v4l.org/new")).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString("code=" + text)).build();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PhpCreateYoutrackIssueFromFileAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(PlatformUtils.isPhpStorm() && ApplicationManager.getApplication().isInternal());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            PhpCreateYoutrackIssueFromFileAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/internal/PhpCreateYoutrackIssueFromFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/internal/PhpCreateYoutrackIssueFromFileAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

