/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.annotator;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.impl.PhpBaseMemberReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpReplaceNullSafeInFirstClassCallableQuickFix
extends PsiUpdateModCommandAction<PsiElement> {
    public PhpReplaceNullSafeInFirstClassCallableQuickFix(@NotNull PsiElement nullSafeOrator) {
        if (nullSafeOrator == null) {
            PhpReplaceNullSafeInFirstClassCallableQuickFix.$$$reportNull$$$0(0);
        }
        super(nullSafeOrator);
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("replace.with.coalesce.operator", new Object[0]);
        if (string == null) {
            PhpReplaceNullSafeInFirstClassCallableQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement startElement) {
        if (context == null) {
            PhpReplaceNullSafeInFirstClassCallableQuickFix.$$$reportNull$$$0(2);
        }
        if (startElement == null) {
            PhpReplaceNullSafeInFirstClassCallableQuickFix.$$$reportNull$$$0(3);
        }
        if (!PhpLanguageFeature.COALESCE_OPERATOR.isSupported(context.project())) {
            return null;
        }
        PhpBaseMemberReference memberReference = (PhpBaseMemberReference)((Object)ObjectUtils.tryCast((Object)startElement.getParent(), PhpBaseMemberReference.class));
        if (memberReference == null) {
            return null;
        }
        PhpExpression classReference = memberReference.getClassReference();
        if (classReference == null) {
            return null;
        }
        if (PhpSideEffectDetector.canContainSideEffect((PsiElement)classReference)) {
            return null;
        }
        return Presentation.of((String)this.getFamilyName()).withPriority(PriorityAction.Priority.HIGH);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
        PhpBaseMemberReference memberReference;
        if (context == null) {
            PhpReplaceNullSafeInFirstClassCallableQuickFix.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            PhpReplaceNullSafeInFirstClassCallableQuickFix.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            PhpReplaceNullSafeInFirstClassCallableQuickFix.$$$reportNull$$$0(6);
        }
        if ((memberReference = (PhpBaseMemberReference)((Object)ObjectUtils.tryCast((Object)startElement.getParent(), PhpBaseMemberReference.class))) == null) {
            return;
        }
        PhpExpression classReference = memberReference.getClassReference();
        if (classReference == null) {
            return;
        }
        String classReferenceText = classReference.getText();
        PhpReplaceNullSafeInFirstClassCallableQuickFix.removeNullSafeOperators(memberReference);
        PhpBaseMemberReference topmostMemberReference = memberReference;
        while (topmostMemberReference.getParent() instanceof PhpBaseMemberReference) {
            topmostMemberReference = (PhpBaseMemberReference)topmostMemberReference.getParent();
        }
        String newExpressionText = String.format("%s != null ? %s : null", classReferenceText, topmostMemberReference.getText());
        TernaryExpression newExpression = PhpPsiElementFactory.createFromText(context.project(), TernaryExpression.class, newExpressionText);
        assert (newExpression != null);
        topmostMemberReference.replace((PsiElement)newExpression);
    }

    private static void removeNullSafeOperators(@NotNull PhpBaseMemberReference memberReference) {
        PsiElement nullSafeOperator;
        if (memberReference == null) {
            PhpReplaceNullSafeInFirstClassCallableQuickFix.$$$reportNull$$$0(7);
        }
        while (memberReference != null && (nullSafeOperator = PhpAnnotatorVisitor.getNullSafeOperator(memberReference)) != null) {
            memberReference = (PhpBaseMemberReference)((Object)ObjectUtils.tryCast((Object)nullSafeOperator.getParent(), PhpBaseMemberReference.class));
            nullSafeOperator.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullSafeOrator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpReplaceNullSafeInFirstClassCallableQuickFix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpReplaceNullSafeInFirstClassCallableQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeNullSafeOperators";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

