/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation;

import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.documentation.PhpAttributesOwnerElementDocSource;
import com.jetbrains.php.lang.documentation.PhpClassDocSource;
import com.jetbrains.php.lang.documentation.PhpDefaultDocSource;
import com.jetbrains.php.lang.documentation.PhpDocSection;
import com.jetbrains.php.lang.documentation.PhpDocSource;
import com.jetbrains.php.lang.documentation.PhpFunctionDocSource;
import com.jetbrains.php.lang.documentation.PhpNamedElementDocSource;
import com.jetbrains.php.lang.documentation.PhpNamespaceDocSource;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpClassMemberDocSource
extends PhpNamedElementDocSource {
    private final PhpClassMember myMember;
    private final PhpDocSource mySourceDelegate;

    public PhpClassMemberDocSource(PhpClassMember element, boolean isGenerationForRenderedDoc) {
        super((PhpNamedElement)element, isGenerationForRenderedDoc);
        this.myMember = element;
        this.mySourceDelegate = element instanceof Method ? new PhpFunctionDocSource((Function)((Method)element), isGenerationForRenderedDoc) : (element instanceof Field ? new PhpAttributesOwnerElementDocSource((PhpNamedElement)element, (PhpAttributesOwner)((Field)element).getParentList(), isGenerationForRenderedDoc) : (element instanceof PhpEnumCase ? new PhpNamedElementDocSource((PhpNamedElement)element, isGenerationForRenderedDoc) : new PhpDefaultDocSource((PhpPsiElement)element, isGenerationForRenderedDoc)));
    }

    @Override
    @Nullable
    public PhpDocComment getDocComment() {
        return this.mySourceDelegate.getDocComment();
    }

    @Override
    @NotNull
    @NlsSafe
    public String getTitle() {
        String title = this.mySourceDelegate.getTitle();
        PhpDocComment docComment = this.myMember.getDocComment();
        String string = title = PhpClassMemberDocSource.addSuffix(docComment, "static", "staticvar", title);
        if (string == null) {
            PhpClassMemberDocSource.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static String addSuffix(PhpDocComment docComment, String suffix, @Nullable String tag, String declaration) {
        String docTag = "@" + (tag == null ? suffix : tag);
        if (docComment != null && PhpDocUtil.hasDocTagWithName(docComment, docTag) && !declaration.contains(suffix)) {
            return suffix + " " + declaration;
        }
        return declaration;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.mySourceDelegate.getDescription();
        if (string == null) {
            PhpClassMemberDocSource.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public String getParameters() {
        return this.mySourceDelegate.getParameters();
    }

    @Override
    public String getReturnType() {
        return this.mySourceDelegate.getReturnType();
    }

    @Override
    public String getReturn() {
        return this.mySourceDelegate.getReturn();
    }

    @Override
    public String getSince() {
        return this.mySourceDelegate.getSince();
    }

    @Override
    public String getUses() {
        return this.mySourceDelegate.getUses();
    }

    @Override
    public String getLinks() {
        return this.mySourceDelegate.getLinks();
    }

    @Override
    public String getSeeItems() {
        return this.mySourceDelegate.getSeeItems();
    }

    @Override
    public String getVersion() {
        return this.mySourceDelegate.getVersion();
    }

    @Override
    public String getThrows() {
        return this.mySourceDelegate.getThrows();
    }

    @Override
    public HtmlChunk.Element getContainerInfo() {
        PhpClass clazz = this.myMember.getContainingClass();
        if (clazz == null) {
            return null;
        }
        return PhpClassMemberDocSource.getContainerInfo(clazz.getFQN(), PhpNamespaceDocSource.getIcon(clazz), (PsiElement)this.myElement);
    }

    @Override
    public String getPackage() {
        PhpClass klass = this.myMember.getContainingClass();
        if (klass != null) {
            PhpClassDocSource classSource = new PhpClassDocSource(klass, this.myIsGenerationForRenderedDoc);
            return classSource.getPackage();
        }
        return null;
    }

    @Override
    public String getSubpackage() {
        PhpClass klass = this.myMember.getContainingClass();
        if (klass != null) {
            PhpClassDocSource classSource = new PhpClassDocSource(klass, this.myIsGenerationForRenderedDoc);
            return classSource.getSubpackage();
        }
        return null;
    }

    @Override
    @Nullable
    public String getVar() {
        return this.mySourceDelegate.getVar();
    }

    @Override
    @NotNull
    public Collection<PhpDocSection> getCustomSections() {
        if (!(this.myElement instanceof Method)) {
            Collection<PhpDocSection> collection = super.getCustomSections();
            if (collection == null) {
                PhpClassMemberDocSource.$$$reportNull$$$0(2);
            }
            return collection;
        }
        Ref overriddenMember = new Ref();
        Ref implementedMember = new Ref();
        PhpClassHierarchyUtils.processSuperMethods((Method)((Method)this.myElement), (classMember, subClass, baseClass) -> {
            PhpClass containingClass = classMember.getContainingClass();
            if (containingClass != null) {
                if (containingClass.isInterface()) {
                    if (implementedMember.isNull()) {
                        implementedMember.set((Object)classMember);
                    }
                } else if (overriddenMember.isNull()) {
                    overriddenMember.set((Object)classMember);
                }
            }
            return overriddenMember.isNull() || implementedMember.isNull();
        });
        SmartList result = new SmartList();
        if (!overriddenMember.isNull()) {
            result.add(new PhpDocSection("Overrides", PhpClassMemberDocSource.getMessageWithLink((PhpClassMember)overriddenMember.get())));
        }
        if (!implementedMember.isNull()) {
            result.add(new PhpDocSection("Implements", PhpClassMemberDocSource.getMessageWithLink((PhpClassMember)implementedMember.get())));
        }
        SmartList smartList = result;
        if (smartList == null) {
            PhpClassMemberDocSource.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    private static String getMessageWithLink(PhpClassMember member) {
        @Nls StringBuilder sb = new StringBuilder();
        PhpClassMemberDocSource.appendLink(sb, member);
        return QuickDocHighlightingHelper.wrapWithInlineCodeTag((StringBuilder)sb).toString();
    }

    public static void appendLink(StringBuilder buf, PhpClassMember member) {
        PhpClassMemberDocSource.appendLink(buf, member.getFQN().replace(".", "::"), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/documentation/PhpClassMemberDocSource";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomSections";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

