/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation;

import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.documentation.PhpDocumentationProvider;
import com.jetbrains.php.lang.documentation.PhpNamedElementDocSource;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocCommentImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.highlighter.PhpHighlightingData;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFunctionDocSource
extends PhpNamedElementDocSource {
    private final Function myFunction;

    public PhpFunctionDocSource(@NotNull Function func, boolean isGenerationForRenderedDoc) {
        if (func == null) {
            PhpFunctionDocSource.$$$reportNull$$$0(0);
        }
        super((PhpNamedElement)func, isGenerationForRenderedDoc);
        this.myFunction = func;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getTitle() {
        String string = PhpDocUtil.extractDefinition((PhpNamedElement)this.myFunction, this.myIsGenerationForRenderedDoc);
        if (string == null) {
            PhpFunctionDocSource.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static void appendParameterSignature(@NotNull Parameter parameter, @NotNull StringBuilder buf, boolean phpDoc, boolean renderedDoc) {
        PsiElement defaultValue;
        if (parameter == null) {
            PhpFunctionDocSource.$$$reportNull$$$0(2);
        }
        if (buf == null) {
            PhpFunctionDocSource.$$$reportNull$$$0(3);
        }
        for (PhpAttributesList attributeList : PhpPsiUtil.getChildren((PsiElement)parameter, (Condition<? super PsiElement>)((Condition)PhpAttributesList.class::isInstance))) {
            PhpDocUtil.appendAttributeListDoc(buf, attributeList);
        }
        String declaredTypeSignature = PhpFunctionDocSource.getDeclaredTypeSignature(parameter, phpDoc, renderedDoc);
        if (StringUtil.isNotEmpty((String)declaredTypeSignature)) {
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buf, (String)declaredTypeSignature, (TextAttributesKey)PhpHighlightingData.PRIMITIVE_TYPE_HINT);
            buf.append(" ");
        }
        if (parameter.isPassByRef()) {
            buf.append("&");
        }
        if (parameter.isVariadic()) {
            buf.append("...");
        }
        if (!parameter.getName().isEmpty()) {
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buf, (String)("$" + parameter.getName()), (TextAttributesKey)PhpHighlightingData.PARAMETER);
        }
        if ((defaultValue = parameter.getDefaultValue()) != null) {
            buf.append(" = ").append(defaultValue.getText());
        }
    }

    @Nullable
    private static String getDeclaredTypeSignature(@NotNull Parameter parameter, boolean phpDoc, boolean isGenerationForRenderedDoc) {
        boolean nullable;
        PhpType type;
        ParameterImpl parameterImpl;
        if (parameter == null) {
            PhpFunctionDocSource.$$$reportNull$$$0(4);
        }
        if (parameter instanceof ParameterImpl && (parameterImpl = (ParameterImpl)parameter).isDocMethodParameter()) {
            PhpType baseType = parameterImpl.getType();
            if (parameter.isVariadic()) {
                baseType = baseType.map(t -> {
                    String base = PhpType.removeParametrisedType((String)t);
                    if ("\\array".equals(base)) {
                        return "\\array";
                    }
                    return PhpType.isPluralType((String)t) ? PhpType.unpluralize((String)t) : t;
                });
            }
            type = baseType.filterMixed();
            nullable = type.isNullable();
        } else {
            Parameter typeReferencesOwner = !phpDoc ? parameter.getTypeDeclaration() : parameter;
            List typeReferences = PhpPsiUtil.getChildren((PsiElement)typeReferencesOwner, (Condition<? super PsiElement>)ClassReference.INSTANCEOF);
            if (typeReferencesOwner == null || typeReferences.isEmpty()) {
                return null;
            }
            nullable = PhpPsiUtil.isOfType(typeReferencesOwner.getFirstChild(), PhpTokenTypes.opQUEST);
            type = typeReferencesOwner.getType();
        }
        StringBuilder buf = new StringBuilder();
        if (nullable) {
            buf.append("?");
        }
        PhpFunctionDocSource.appendType(buf, nullable ? type.filterNull() : type, parameter.getContext(), isGenerationForRenderedDoc);
        return StringUtil.trimTrailing((StringBuilder)buf, (char)'|').toString();
    }

    @Override
    public String getParameters() {
        LinkedHashMap<String, List<PhpDocParamTag>> paramsFromDocComments = new LinkedHashMap<String, List<PhpDocParamTag>>();
        PhpDocComment generatedDocComment = this.myIsGenerationForRenderedDoc ? null : PhpFunctionDocSource.generateDocComment(this.myFunction);
        HashMap<String, PhpDocParamTag> paramsFromSignature = new HashMap<String, PhpDocParamTag>();
        if (generatedDocComment != null) {
            generatedDocComment.getParamTags().forEach(p -> paramsFromSignature.put(p.getVarName(), (PhpDocParamTag)p));
        }
        if (!DumbService.isDumb((Project)this.myFunction.getProject())) {
            this.myElement.processDocs(comment -> this.processDocComment((Map<String, List<PhpDocParamTag>>)paramsFromDocComments, (PhpDocComment)comment));
        } else {
            this.processDocComment(paramsFromDocComments, this.myDocComment);
        }
        ArrayList<PhpDocParamTag> paramTags = new ArrayList<PhpDocParamTag>();
        if (this.myIsGenerationForRenderedDoc) {
            for (List value : paramsFromDocComments.values()) {
                paramTags.addAll(value);
            }
        } else {
            for (Parameter param : this.myFunction.getParameters()) {
                String paramName = param.getName();
                if (PhpFunctionDocSource.useTypeFromSignature(paramsFromSignature, paramsFromDocComments, paramName)) {
                    paramTags.add((PhpDocParamTag)paramsFromSignature.get(paramName));
                    continue;
                }
                paramTags.addAll((Collection)paramsFromDocComments.get(paramName));
            }
        }
        return PhpFunctionDocSource.appendParametersSection(paramTags, this.myIsGenerationForRenderedDoc);
    }

    @Nullable
    private static PhpDocComment generateDocComment(@NotNull Function element) {
        if (element == null) {
            PhpFunctionDocSource.$$$reportNull$$$0(5);
        }
        StringBuilder builder2 = new StringBuilder();
        builder2.append("<?php\n");
        builder2.append("/**\n");
        if (element instanceof PhpDocMethod) {
            PhpDocMethod method = (PhpDocMethod)element;
            PhpDocCommentGenerator.FunctionDocCommentGenerator.addDocMethodParameters(builder2, method);
        } else {
            PhpDocCommentGenerator.FunctionDocCommentGenerator.addParameters(builder2, element);
        }
        builder2.append("*/");
        return PhpPsiElementFactory.createFromText(element.getProject(), PhpDocComment.class, builder2.toString());
    }

    @Override
    public String getVar() {
        return null;
    }

    private boolean processDocComment(Map<String, List<PhpDocParamTag>> paramsFromDocComments, PhpDocComment comment) {
        PhpDocCommentImpl docComment = (PhpDocCommentImpl)((Object)ObjectUtils.tryCast((Object)comment, PhpDocCommentImpl.class));
        if (docComment == null) {
            return true;
        }
        List<PhpDocParamTag> paramTags = PhpFunctionDocSource.getParamTags(docComment);
        LinkedHashMap<String, List<PhpDocParamTag>> paramsFromDocComment = new LinkedHashMap<String, List<PhpDocParamTag>>();
        if (paramTags.isEmpty()) {
            return true;
        }
        this.processParamsFromDocComment(paramsFromDocComments, paramTags, paramsFromDocComment);
        return false;
    }

    private static List<PhpDocParamTag> getParamTags(PhpDocCommentImpl comment) {
        return ContainerUtil.filter(comment.getDocTagByClass(PhpDocParamTag.class), tag -> PhpDocumentationProvider.PARAM_TAGS.contains(tag.getName()));
    }

    @NlsSafe
    @NotNull
    public static String appendParametersSection(Collection<PhpDocParamTag> paramTags, boolean isGenerationForRenderedDoc) {
        String string = (String)StreamEx.of(paramTags).map(paramTag -> PhpFunctionDocSource.getParameterInfo(paramTag, true, isGenerationForRenderedDoc)).collect(Collectors.joining("<br>"));
        if (string == null) {
            PhpFunctionDocSource.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void processParamsFromDocComment(Map<String, List<PhpDocParamTag>> paramsFromDocComments, List<PhpDocParamTag> paramTags, Map<String, List<PhpDocParamTag>> paramsFromDocComment) {
        for (PhpDocParamTag paramTag : paramTags) {
            String paramName = paramTag.getVarName();
            if (paramsFromDocComments.containsKey(paramName)) continue;
            paramsFromDocComment.computeIfAbsent(paramName, p -> new ArrayList()).add(paramTag);
        }
        paramsFromDocComments.putAll(paramsFromDocComment);
    }

    private static boolean useTypeFromSignature(Map<String, PhpDocParamTag> paramsFromSignature, Map<String, List<PhpDocParamTag>> paramsFromDocComments, String name) {
        if (!paramsFromDocComments.containsKey(name)) {
            return true;
        }
        PhpDocParamTag param = paramsFromSignature.get(name);
        if (param == null) {
            return false;
        }
        PhpType typeFromSignature = param.getType();
        return !typeFromSignature.isEmpty() && ContainerUtil.all((Collection)paramsFromDocComments.get(name), t -> !typeFromSignature.equals((Object)t.getType()) && !PhpDocSignatureInspection.typesMatch(t.getProject(), t.getType(), typeFromSignature));
    }

    public static String getParameterInfo(@Nullable PhpDocParamTag paramTag, boolean addDescription, boolean isGenerationForRenderedDoc) {
        StringBuilder paramBuf = new StringBuilder();
        if (paramTag == null) {
            return paramBuf.toString();
        }
        String paramName = paramTag.getVarName();
        PhpFunctionDocSource.appendTypeFromDocTag(paramBuf, (PhpDocTag)paramTag, isGenerationForRenderedDoc);
        paramBuf.append(HtmlChunk.nbsp());
        if (paramName != null && !paramName.isEmpty()) {
            StringBuilder builder2 = new StringBuilder();
            if (paramTag.isVariadic()) {
                paramBuf.append("...");
            }
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)builder2, (String)("$" + paramName), (TextAttributesKey)PhpHighlightingData.PARAMETER);
            QuickDocHighlightingHelper.appendWrappedWithInlineCodeTag((StringBuilder)paramBuf, (CharSequence)builder2);
        }
        if (addDescription) {
            PhpFunctionDocSource.appendDescription(paramBuf, (PhpDocTag)paramTag);
        }
        return paramBuf.toString();
    }

    public static void appendDescription(StringBuilder buf, PhpDocTag tag) {
        String value = PhpDocUtil.convertFromMarkdown(tag.getProject(), tag.getTagValue());
        if (!value.isEmpty()) {
            buf.append(HtmlChunk.nbsp());
            buf.append("\u2013");
            buf.append(HtmlChunk.nbsp());
            buf.append(value);
        }
    }

    @Override
    public String getReturn() {
        PhpDocCommentImpl docComment = (PhpDocCommentImpl)((Object)ObjectUtils.tryCast((Object)this.myDocComment, PhpDocCommentImpl.class));
        if (docComment == null) {
            return null;
        }
        PhpDocReturnTag returnTag = PhpFunctionDocSource.getReturnTag(docComment);
        if (returnTag == null) {
            return null;
        }
        return PhpDocUtil.getTagInfo((PhpDocTag)returnTag, this.myIsGenerationForRenderedDoc);
    }

    private static PhpDocReturnTag getReturnTag(PhpDocCommentImpl comment) {
        return StreamEx.of(PhpDocumentationProvider.RETURN_TAGS).flatMap(s -> StreamEx.of((Object[])comment.getTagElementsByName((String)s))).select(PhpDocReturnTag.class).findFirst().orElse(null);
    }

    @Override
    public String getThrows() {
        if (this.myDocComment == null) {
            return null;
        }
        return (String)StreamEx.of(PhpDocumentationProvider.THROWS_TAGS).flatMap(s -> StreamEx.of((Object[])this.myDocComment.getTagElementsByName(s))).map(throwsTag -> PhpDocUtil.getTagInfo(throwsTag, this.myIsGenerationForRenderedDoc)).collect(Collectors.joining("<br>"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/PhpFunctionDocSource";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/PhpFunctionDocSource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "appendParametersSection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendParameterSignature";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredTypeSignature";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateDocComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6 -> new IllegalStateException(string);
        };
    }
}

