/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.findUsages;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.impl.MethodImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class PhpUsageTypeProvider
implements UsageTypeProvider {
    private static final UsageType FUNCTION_CALL = new UsageType(PhpBundle.message("function.call", new Object[0]));
    private static final UsageType METHOD_CALL = new UsageType(PhpBundle.message("method.call", new Object[0]));
    private static final UsageType CLASS_EXTENDS_LIST = new UsageType(PhpBundle.message("usage.in.extends.clause", new Object[0]));
    private static final UsageType CLASS_IMPLEMENTS_LIST = new UsageType(PhpBundle.message("usage.in.implements.clause", new Object[0]));
    private static final UsageType TYPE_HINTING = new UsageType(PhpBundle.message("usage.in.type.hinting", new Object[0]));
    private static final UsageType OVERRIDING_IMPLEMENTING = new UsageType(PhpBundle.message("overriding.implementing.methods", new Object[0]));
    private static final UsageType IMPORT_STATEMENT = new UsageType(PhpBundle.message("usage.in.import.statement", new Object[0]));
    private static final UsageType RETURN_TYPE = new UsageType(PhpBundle.message("usage.in.return.type", new Object[0]));

    public UsageType getUsageType(@NotNull PsiElement element) {
        if (element == null) {
            PhpUsageTypeProvider.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PhpPsiElement)) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof PhpUse) {
            return IMPORT_STATEMENT;
        }
        if (element instanceof ClassReference) {
            IElementType type = parent.getNode().getElementType();
            if (PhpElementTypes.EXTENDS_LIST == type) {
                return CLASS_EXTENDS_LIST;
            }
            if (PhpElementTypes.IMPLEMENTS_LIST == type) {
                return CLASS_IMPLEMENTS_LIST;
            }
            if (PhpElementTypes.NEW_EXPRESSION == type) {
                return UsageType.CLASS_NEW_OPERATOR;
            }
            if (PhpElementTypes.INSTANCEOF_EXPRESSION == type) {
                return UsageType.CLASS_INSTANCE_OF;
            }
            if (PhpElementTypes.CAST_EXPRESSION == type) {
                return UsageType.CLASS_CAST_TO;
            }
            if (PhpElementTypes.CATCH == type) {
                return UsageType.CLASS_CATCH_CLAUSE_PARAMETER_DECLARATION;
            }
            if (PhpElementTypes.FIELD_REFERENCE == type || PhpElementTypes.METHOD_REFERENCE == type || PhpElementTypes.CLASS_CONSTANT_REFERENCE == type) {
                return UsageType.CLASS_STATIC_MEMBER_ACCESS;
            }
            if (ParameterImpl.PARAMETER.contains(type)) {
                return TYPE_HINTING;
            }
            if (PhpElementTypes.RETURN_TYPE == type) {
                return RETURN_TYPE;
            }
        } else {
            if (element instanceof MethodReference) {
                MethodReference methodReference = (MethodReference)element;
                Method containingMethod = PhpPsiUtil.getParentOfClass(element, false, Method.class);
                PsiElement callMethodElement = methodReference.resolve();
                if (containingMethod != null && callMethodElement instanceof Method) {
                    Method callMethod = (Method)callMethodElement;
                    if (containingMethod == callMethod) {
                        return UsageType.RECURSION;
                    }
                    PhpNamedElement containingClass = (PhpNamedElement)PhpPsiUtil.getParentOfClass(element, true, PhpClass.class);
                    if (containingClass != null && PhpUsageTypeProvider.haveCommonSuperMethod(containingMethod, callMethod)) {
                        PhpExpression classReference = methodReference.getClassReference();
                        if (classReference != null && PhpLangUtil.equalsClassNames("parent", classReference.getText())) {
                            return UsageType.DELEGATE_TO_SUPER;
                        }
                        return UsageType.DELEGATE_TO_ANOTHER_INSTANCE;
                    }
                }
                return METHOD_CALL;
            }
            if (element instanceof MethodImpl) {
                return OVERRIDING_IMPLEMENTING;
            }
            if (element instanceof FunctionReference) {
                return FUNCTION_CALL;
            }
        }
        return null;
    }

    private static boolean haveCommonSuperMethod(@NotNull Method m1, @NotNull Method m2) {
        if (m1 == null) {
            PhpUsageTypeProvider.$$$reportNull$$$0(1);
        }
        if (m2 == null) {
            PhpUsageTypeProvider.$$$reportNull$$$0(2);
        }
        HashSet<Method> superMethods1 = new HashSet<Method>();
        HashSet<Method> superMethods2 = new HashSet<Method>();
        PhpClassHierarchyUtils.processSuperMethods((Method)m1, (classMember, subClass, baseClass) -> {
            superMethods1.add((Method)classMember);
            return true;
        });
        PhpClassHierarchyUtils.processSuperMethods((Method)m2, (classMember, subClass, baseClass) -> {
            superMethods2.add((Method)classMember);
            return true;
        });
        superMethods1.add(m1);
        superMethods2.add(m2);
        superMethods1.retainAll(superMethods2);
        return !superMethods1.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m2";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/findUsages/PhpUsageTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getUsageType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "haveCommonSuperMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

