/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PhpConstructorParensPreprocessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        PsiElement psi;
        if (element == null) {
            PhpConstructorParensPreprocessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            PhpConstructorParensPreprocessor.$$$reportNull$$$0(1);
        }
        if ((psi = element.getPsi()) != null && psi.isValid() && psi.getLanguage().is((Language)PhpLanguage.INSTANCE)) {
            PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)psi.getContainingFile(), PhpCodeStyleSettings.class);
            if (settings.PLACE_PARENS_FOR_CONSTRUCTOR != 0) {
                TextRange textRange = new PhpConstructorVisitor(psi, range, settings.PLACE_PARENS_FOR_CONSTRUCTOR).process();
                if (textRange == null) {
                    PhpConstructorParensPreprocessor.$$$reportNull$$$0(2);
                }
                return textRange;
            }
        }
        TextRange textRange = range;
        if (textRange == null) {
            PhpConstructorParensPreprocessor.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/PhpConstructorParensPreprocessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpConstructorParensPreprocessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static final class PhpConstructorVisitor
    extends PhpRecursiveElementVisitor {
        private final PsiElement myElement;
        private final TextRange myRange;
        private final int myPlaceParens;
        private final List<TextRange> myRangesToProcess;

        private PhpConstructorVisitor(@NotNull PsiElement element, @NotNull TextRange range, int placeParens) {
            if (element == null) {
                PhpConstructorVisitor.$$$reportNull$$$0(0);
            }
            if (range == null) {
                PhpConstructorVisitor.$$$reportNull$$$0(1);
            }
            this.myRangesToProcess = new SmartList();
            this.myElement = element;
            this.myRange = range;
            this.myPlaceParens = placeParens;
        }

        @NotNull
        private TextRange process() {
            Document document;
            PsiDocumentManager documentManager;
            try {
                documentManager = PsiDocumentManager.getInstance((Project)this.myElement.getProject());
                document = documentManager.getDocument(this.myElement.getContainingFile());
            }
            catch (PsiInvalidElementAccessException e) {
                TextRange textRange = this.myRange;
                if (textRange == null) {
                    PhpConstructorVisitor.$$$reportNull$$$0(2);
                }
                return textRange;
            }
            if (document != null) {
                documentManager.doPostponedOperationsAndUnblockDocument(document);
                this.myElement.accept((PsiElementVisitor)this);
                if (!this.myRangesToProcess.isEmpty()) {
                    this.myRangesToProcess.sort(Comparator.comparingInt(TextRange::getStartOffset));
                    int delta = 0;
                    for (TextRange range : this.myRangesToProcess) {
                        if (this.myPlaceParens == 2) {
                            document.deleteString(delta + range.getStartOffset(), delta + range.getEndOffset());
                            delta -= range.getLength();
                            continue;
                        }
                        if (this.myPlaceParens != 1) continue;
                        document.insertString(delta + range.getStartOffset(), (CharSequence)"()");
                        delta += 2;
                    }
                    documentManager.commitDocument(document);
                    TextRange textRange = this.myRange.grown(delta);
                    if (textRange == null) {
                        PhpConstructorVisitor.$$$reportNull$$$0(3);
                    }
                    return textRange;
                }
            }
            TextRange textRange = this.myRange;
            if (textRange == null) {
                PhpConstructorVisitor.$$$reportNull$$$0(4);
            }
            return textRange;
        }

        public void visitPhpNewExpression(NewExpression expression) {
            if (this.myRange.contains(expression.getTextRange())) {
                if (expression.getClassReference() == null) {
                    return;
                }
                ParameterList parameterList = expression.getParameterList();
                if (parameterList != null) {
                    if (ArrayUtil.isEmpty((Object[])parameterList.getParameters())) {
                        PsiElement lParen;
                        PsiElement rParen;
                        if (this.myPlaceParens == 2 && PhpPsiUtil.isOfType(rParen = expression.getLastChild(), PhpTokenTypes.chRPAREN) && PhpPsiUtil.getPrevSiblingIgnoreWhitespace(rParen, true) == parameterList && PhpPsiUtil.isOfType(lParen = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)parameterList, true), PhpTokenTypes.chLPAREN)) {
                            this.myRangesToProcess.add(TextRange.create((int)lParen.getTextOffset(), (int)(rParen.getTextOffset() + 1)));
                        }
                    } else {
                        super.visitPhpNewExpression(expression);
                    }
                } else if (this.myPlaceParens == 1) {
                    this.myRangesToProcess.add(TextRange.from((int)expression.getTextRange().getEndOffset(), (int)0));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/formatter/PhpConstructorParensPreprocessor$PhpConstructorVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpConstructorParensPreprocessor$PhpConstructorVisitor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

