/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.lang.Language;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.PsiBasedFileIndentOptionsProvider;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.psi.PhpFile;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpFileIndentOptionsProvider
extends PsiBasedFileIndentOptionsProvider {
    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsByPsiFile(@NotNull CodeStyleSettings settings, @NotNull PsiFile file) {
        PsiFile templateFile;
        if (settings == null) {
            PhpFileIndentOptionsProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PhpFileIndentOptionsProvider.$$$reportNull$$$0(1);
        }
        if (file instanceof PhpFile && (templateFile = PhpFileIndentOptionsProvider.getTemplateFile(file)) != null) {
            return FileIndentOptionsProvider.EP_NAME.getExtensionList().stream().filter(provider -> provider.useOnFullReformat() && !(provider instanceof PhpFileIndentOptionsProvider) && provider instanceof PsiBasedFileIndentOptionsProvider).map(provider -> ((PsiBasedFileIndentOptionsProvider)provider).getIndentOptionsByPsiFile(settings, templateFile)).filter(Objects::nonNull).findFirst().orElseGet(() -> settings.getCommonSettings(templateFile.getLanguage()).getIndentOptions());
        }
        return null;
    }

    @Nullable
    private static PsiFile getTemplateFile(@NotNull PsiFile file) {
        if (file == null) {
            PhpFileIndentOptionsProvider.$$$reportNull$$$0(2);
        }
        FileViewProvider fileViewProvider = file.getViewProvider();
        List allFiles = fileViewProvider.getAllFiles();
        for (PsiFile rootFile : allFiles) {
            if (rootFile instanceof PhpFile || PhpFileIndentOptionsProvider.containsOnlyWhitespaceAndPhpElements(file.getViewProvider(), (PsiElement)rootFile)) continue;
            return rootFile;
        }
        return null;
    }

    private static boolean containsOnlyWhitespaceAndPhpElements(@NotNull FileViewProvider viewProvider, @NotNull PsiElement element) {
        if (viewProvider == null) {
            PhpFileIndentOptionsProvider.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpFileIndentOptionsProvider.$$$reportNull$$$0(4);
        }
        if (!element.isValid()) {
            return true;
        }
        if (element.getTextLength() == 0) {
            return true;
        }
        if (element.getFirstChild() == null) {
            if (element instanceof OuterLanguageElement) {
                PsiElement phpElement = viewProvider.findElementAt(element.getTextRange().getStartOffset(), (Language)PhpLanguage.INSTANCE);
                return phpElement != null;
            }
            return element instanceof PsiWhiteSpace;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (PhpFileIndentOptionsProvider.containsOnlyWhitespaceAndPhpElements(viewProvider, child)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpFileIndentOptionsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndentOptionsByPsiFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTemplateFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "containsOnlyWhitespaceAndPhpElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

