/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.impl.StringLiteralExpressionImpl;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/php/lang/formatter/PhpHeredocPostFormatProcessor;", "Lcom/intellij/psi/impl/source/codeStyle/PostFormatProcessor;", "<init>", "()V", "processRange", "Lcom/intellij/openapi/util/TextRange;", "source", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "getRange", "Lkotlin/Function0;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "processElement", "processText", "rangeToReformat", "Visitor", "intellij.php.impl"})
public final class PhpHeredocPostFormatProcessor
implements PostFormatProcessor {
    private final TextRange processRange(PsiElement source, PsiFile file, Function0<? extends TextRange> getRange, CodeStyleSettings settings) {
        Document document;
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(PhpCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)customCodeStyleSettings;
        if (!(phpSettings.HEREDOC_ON_SAME_LINE && Intrinsics.areEqual((Object)file.getFileType(), (Object)PhpFileType.INSTANCE) && source.isValid())) {
            return null;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file.getProject());
        if (file.isPhysical()) {
            document = documentManager.getDocument(file);
        } else {
            document = file.getViewProvider().getDocument();
            if (document == null) {
                return null;
            }
        }
        Document document2 = document;
        TextRange textRange = (TextRange)getRange.invoke();
        Document document3 = document2;
        Intrinsics.checkNotNull((Object)document3);
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new Visitor(textRange, source, document3, settings, project).processTree();
    }

    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        PsiFile psiFile = source.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        this.processRange(source, psiFile, (Function0<? extends TextRange>)((Function0)() -> PhpHeredocPostFormatProcessor.processElement$lambda$0(source)), settings);
        return source;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)rangeToReformat, (String)"rangeToReformat");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        PsiElement psiElement = (PsiElement)source;
        PsiFile psiFile = source.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        TextRange textRange = this.processRange(psiElement, psiFile, (Function0<? extends TextRange>)((Function0)() -> PhpHeredocPostFormatProcessor.processText$lambda$0(rangeToReformat)), settings);
        if (textRange == null) {
            return rangeToReformat;
        }
        TextRange range = textRange;
        return range;
    }

    private static final TextRange processElement$lambda$0(PsiElement $source) {
        TextRange textRange = $source.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return textRange;
    }

    private static final TextRange processText$lambda$0(TextRange $rangeToReformat) {
        return $rangeToReformat;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u001a\u001a\u00020\u0003J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/php/lang/formatter/PhpHeredocPostFormatProcessor$Visitor;", "Lcom/intellij/psi/PsiRecursiveElementVisitor;", "range", "Lcom/intellij/openapi/util/TextRange;", "element", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/util/TextRange;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Document;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/openapi/project/Project;)V", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "getElement", "()Lcom/intellij/psi/PsiElement;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getSettings", "()Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "getProject", "()Lcom/intellij/openapi/project/Project;", "delta", "", "processTree", "commitDocument", "", "visitElement", "intellij.php.impl"})
    private static final class Visitor
    extends PsiRecursiveElementVisitor {
        @NotNull
        private final TextRange range;
        @NotNull
        private final PsiElement element;
        @NotNull
        private final Document document;
        @NotNull
        private final CodeStyleSettings settings;
        @NotNull
        private final Project project;
        private int delta;

        public Visitor(@NotNull TextRange range, @NotNull PsiElement element, @NotNull Document document, @NotNull CodeStyleSettings settings, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.range = range;
            this.element = element;
            this.document = document;
            this.settings = settings;
            this.project = project;
        }

        @NotNull
        public final TextRange getRange() {
            return this.range;
        }

        @NotNull
        public final PsiElement getElement() {
            return this.element;
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        @NotNull
        public final CodeStyleSettings getSettings() {
            return this.settings;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final TextRange processTree() {
            this.element.accept((PsiElementVisitor)this);
            this.range.grown(this.delta);
            return this.range;
        }

        private final void commitDocument() {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.project);
            documentManager.commitDocument(this.document);
        }

        public void visitElement(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super.visitElement(element);
            if (!(element instanceof StringLiteralExpressionImpl && ((StringLiteralExpressionImpl)element).isValid() && this.range.contains(((StringLiteralExpressionImpl)element).getTextRange()) && ((StringLiteralExpressionImpl)element).isHeredoc())) {
                return;
            }
            int parentIndentSize = IndentHelper.getInstance().getIndent(((StringLiteralExpressionImpl)element).getContainingFile(), ((StringLiteralExpressionImpl)element).getParent().getNode(), true);
            int indentSize = this.settings.getIndentSize(((StringLiteralExpressionImpl)element).getContainingFile().getFileType()) + parentIndentSize;
            String string = ((StringLiteralExpressionImpl)element).getContents();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContents(...)");
            String oldHeredocContent = string;
            String trimmedHeredocContent = StringsKt.trimIndent((String)oldHeredocContent);
            String newHeredocContent = StringsKt.prependIndent((String)trimmedHeredocContent, (String)StringsKt.repeat((CharSequence)" ", (int)indentSize)) + "\n";
            ASTNode aSTNode = ((StringLiteralExpressionImpl)element).getNode().findChildByType(PhpTokenTypes.HEREDOC_START);
            if (aSTNode == null) {
                return;
            }
            ASTNode heredocStart = aSTNode;
            ASTNode aSTNode2 = ((StringLiteralExpressionImpl)element).getNode().findChildByType(PhpTokenTypes.HEREDOC_END);
            if (aSTNode2 == null) {
                return;
            }
            ASTNode heredocEnd = aSTNode2;
            String string2 = heredocEnd.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String oldHeredocEndContent = string2;
            String trimmedHeredocEnd = StringsKt.trimIndent((String)oldHeredocEndContent);
            String newHeredocEndContent = StringsKt.prependIndent((String)trimmedHeredocEnd, (String)StringsKt.repeat((CharSequence)" ", (int)indentSize));
            String newContents = heredocStart.getText() + newHeredocContent + newHeredocEndContent;
            this.delta += newContents.length() - ((StringLiteralExpressionImpl)element).getText().length();
            this.document.replaceString(PsiTreeUtilKt.getStartOffset((PsiElement)element), PsiTreeUtilKt.getEndOffset((PsiElement)element), (CharSequence)newContents);
            this.commitDocument();
        }
    }
}

