/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.TreeTraversal;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpLanguageConstruct;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.impl.PhpYieldImpl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class PhpKeywordToLowerCaseFormatPreprocessor
implements PreFormatProcessor {
    private static final Map<String, PhpLanguageLevel> TYPES = CollectionFactory.createCaseInsensitiveStringMap(Map.ofEntries(Map.entry("array", PhpLanguageLevel.PHP530), Map.entry("callable", PhpLanguageLevel.PHP540), Map.entry("int", PhpLanguageLevel.PHP700), Map.entry("string", PhpLanguageLevel.PHP700), Map.entry("float", PhpLanguageLevel.PHP700), Map.entry("bool", PhpLanguageLevel.PHP700), Map.entry("void", PhpLanguageLevel.PHP700), Map.entry("never", PhpLanguageLevel.PHP810), Map.entry("iterable", PhpLanguageLevel.PHP710), Map.entry("object", PhpLanguageLevel.PHP720), Map.entry("false", PhpLanguageLevel.PHP800), Map.entry("null", PhpLanguageLevel.PHP800), Map.entry("true", PhpLanguageLevel.PHP820)));
    @NotNull
    private static final TokenSet tsAPPLICABLE_TYPES = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.IDENTIFIER, PhpTokenTypes.kwARRAY, PhpTokenTypes.kwCALLABLE});

    PhpKeywordToLowerCaseFormatPreprocessor() {
    }

    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        Document document;
        PsiElement psiElement;
        if (element == null) {
            PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(1);
        }
        if ((psiElement = element.getPsi()) == null || !psiElement.isValid()) {
            TextRange textRange = range;
            if (textRange == null) {
                PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        PsiFile file = psiElement.getContainingFile();
        if (!(file instanceof PhpFile) || file.getViewProvider().getBaseLanguage() != PhpLanguage.INSTANCE || file.getContext() != null) {
            TextRange textRange = range;
            if (textRange == null) {
                PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PhpCodeStyleSettings.class);
        if (!phpCodeStyleSettings.LOWER_CASE_KEYWORDS) {
            TextRange textRange = range;
            if (textRange == null) {
                PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)psiElement.getProject());
        Document document2 = document = file.isPhysical() ? documentManager.getDocument(file) : file.getViewProvider().getDocument();
        if (document == null) {
            TextRange textRange = range;
            if (textRange == null) {
                PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(5);
            }
            return textRange;
        }
        documentManager.doPostponedOperationsAndUnblockDocument(document);
        List<TextRange> candidateRanges = PhpKeywordToLowerCaseFormatPreprocessor.getCandidateRanges(psiElement);
        ArrayList<TextRange> rangesToProcess = new ArrayList<TextRange>();
        for (TextRange textRange : candidateRanges) {
            if (!range.contains(textRange)) continue;
            rangesToProcess.add(textRange);
        }
        if (!rangesToProcess.isEmpty()) {
            rangesToProcess.sort(Comparator.comparingInt(TextRange::getStartOffset));
            rangesToProcess.forEach(i -> document.replaceString(i.getStartOffset(), i.getEndOffset(), (CharSequence)StringUtil.toLowerCase((String)document.getText(i))));
            documentManager.commitDocument(document);
        }
        TextRange textRange = range;
        if (textRange == null) {
            PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @NotNull
    private static List<TextRange> getCandidateRanges(PsiElement file) {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            SmartList rangesToProcess = new SmartList();
            for (PsiElement token : SyntaxTraverser.psiTraverser((PsiElement)file).traverse(TreeTraversal.LEAVES_BFS)) {
                if (!PhpKeywordToLowerCaseFormatPreprocessor.isApplicableKeyword(token) && !PhpKeywordToLowerCaseFormatPreprocessor.isApplicableType(token) || PhpKeywordToLowerCaseFormatPreprocessor.isInComment(token)) continue;
                TextRange textRange = PhpKeywordToLowerCaseFormatPreprocessor.getTextRangeForToken(token);
                String text = token.getText();
                if (!StringUtil.hasUpperCaseChar((String)text)) continue;
                rangesToProcess.add(textRange);
            }
            return CachedValueProvider.Result.createSingleDependency((Object)rangesToProcess, (Object)file);
        });
        if (list == null) {
            PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static TextRange getTextRangeForToken(@NotNull PsiElement token) {
        LeafPsiElement from;
        if (token == null) {
            PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(8);
        }
        TextRange result = token.getTextRange();
        if (PhpPsiUtil.isOfType(token, PhpTokenTypes.kwYIELD) && token.getParent() instanceof PhpYield && (from = PhpYieldImpl.getFrom((PhpYield)token.getParent())) != null && token.equals((Object)token.getParent().getFirstChild())) {
            result = TextRange.create((int)token.getTextRange().getStartOffset(), (int)from.getTextRange().getEndOffset());
        }
        TextRange textRange = result;
        if (textRange == null) {
            PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    private static boolean isApplicableKeyword(@NotNull PsiElement element) {
        if (element == null) {
            PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(10);
        }
        if (!PhpPsiUtil.isOfType(element, PhpTokenTypes.tsKEYWORDS) && !PhpAnnotatorVisitor.isReadonlyKeyword(element.getProject(), element.getNode())) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PhpReference && !(parent instanceof PhpLanguageConstruct)) {
            return !element.getNode().equals((Object)((PhpReference)parent).getNameNode());
        }
        if (parent instanceof PhpNamedElement) {
            return !element.getNode().equals((Object)((PhpNamedElement)parent).getNameNode());
        }
        return !(parent instanceof PhpNamespaceReference);
    }

    private static boolean isApplicableType(@NotNull PsiElement element) {
        if (element == null) {
            PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(11);
        }
        if (PhpPsiUtil.isOfType(element, PhpTokenTypes.tsCAST_OPS)) {
            return true;
        }
        if (PhpPsiUtil.isOfType(element, tsAPPLICABLE_TYPES)) {
            ClassReference parent = (ClassReference)ObjectUtils.tryCast((Object)element.getParent(), ClassReference.class);
            if (parent == null) {
                return false;
            }
            PhpLanguageLevel currentLanguageLevel = PhpProjectConfigurationFacade.getInstance(element.getProject()).getLanguageLevel();
            PhpLanguageLevel requiredLanguageLevel = TYPES.get(element.getText());
            if (requiredLanguageLevel == null || currentLanguageLevel.isLessThan(requiredLanguageLevel)) {
                return false;
            }
            return parent.getParent() instanceof PhpTypeDeclaration;
        }
        return false;
    }

    private static boolean isInComment(@NotNull PsiElement element) {
        if (element == null) {
            PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(12);
        }
        return PhpPsiUtil.getParentOfClass(element, PhpDocComment.class) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/PhpKeywordToLowerCaseFormatPreprocessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpKeywordToLowerCaseFormatPreprocessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidateRanges";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRangeForToken";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTextRangeForToken";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableKeyword";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isInComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 9 -> new IllegalStateException(string);
        };
    }
}

