/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter.ui.predefinedStyle;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.formatter.ui.predefinedStyle.PearCodeStyle;
import com.jetbrains.php.refactoring.PhpNameStyle;

public final class ZendCodeStyle
extends PearCodeStyle {
    @NlsSafe
    private static final String ZEND = "Zend";

    public ZendCodeStyle() {
        super(ZEND);
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        super.apply(settings);
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(this.getLanguage());
        commonSettings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION = true;
        commonSettings.EXTENDS_KEYWORD_WRAP = 1;
        commonSettings.ALIGN_MULTILINE_EXTENDS_LIST = true;
        commonSettings.INDENT_CASE_FROM_SWITCH = true;
        commonSettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = false;
        commonSettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE = false;
        commonSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE = false;
        PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        phpSettings.ALIGN_KEY_VALUE_PAIRS = true;
        phpSettings.KEEP_RPAREN_AND_LBRACE_ON_ONE_LINE = true;
        phpSettings.VARIABLE_NAMING_STYLE = PhpNameStyle.Style.CAMEL_CASE;
    }
}

