/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpChangeParameterTypeToMatchDefaultValueFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpDeprecatedImplicitlyNullableParameterInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "intellij.php.impl"})
public final class PhpDeprecatedImplicitlyNullableParameterInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPhpParameter(Parameter parameter) {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                if (PhpPsiUtil.getParentByCondition((PsiElement)parameter, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)PhpFile.INSTANCEOF) == null) {
                    return;
                }
                PsiElement psiElement = parameter.getDefaultValue();
                if (psiElement == null) {
                    return;
                }
                PsiElement defaultValue = psiElement;
                if (!(defaultValue instanceof ConstantReference) || !PhpLangUtil.isNull((ConstantReference)defaultValue)) {
                    return;
                }
                PhpTypeDeclaration phpTypeDeclaration = parameter.getTypeDeclaration();
                if (phpTypeDeclaration == null) {
                    return;
                }
                PhpTypeDeclaration typeDeclaration = phpTypeDeclaration;
                PhpType phpType = typeDeclaration.getDeclaredType();
                Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"getDeclaredType(...)");
                PhpType type = phpType;
                if (type.isNullable() || type.isAmbiguous()) {
                    return;
                }
                PhpType phpType2 = new PhpType().add(type).add(PhpType.NULL);
                Intrinsics.checkNotNullExpressionValue((Object)phpType2, (String)"add(...)");
                PhpType newNullableType = phpType2;
                this.$holder.problem(defaultValue, PhpBundle.message("inspection.php.implicitly.marking.parameter.as.nullable.is.deprecated", new Object[0])).fix((ModCommandAction)new PhpChangeParameterTypeToMatchDefaultValueFix((PsiElement)typeDeclaration, type, newNullableType)).highlight(ProblemHighlightType.LIKE_DEPRECATED).register();
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP840;
    }
}

