/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpForeachArrayIsUsedAsValueInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpForeachArrayIsUsedAsValueInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpForeach(ForeachStatement foreach) {
                String arrayName;
                PhpPsiElement array = PhpWorkaroundUtil.getForeachArray(foreach);
                if (array instanceof Variable && !StringUtil.isEmptyOrSpaces((String)(arrayName = array.getName()))) {
                    String valueName;
                    PhpReference value;
                    String keyName;
                    Variable key = PhpWorkaroundUtil.getForeachKey(foreach);
                    if (key != null && PhpLangUtil.equalsVariableNames(arrayName, keyName = key.getName())) {
                        holder.registerProblem((PsiElement)key, PhpBundle.message("inspection.foreach.array.is.used.as.value.problem", keyName), new LocalQuickFix[0]);
                    }
                    if ((value = PhpWorkaroundUtil.getForeachValue(foreach)) != null && PhpLangUtil.equalsVariableNames(arrayName, valueName = value.getName())) {
                        holder.registerProblem((PsiElement)value, PhpBundle.message("inspection.foreach.array.is.used.as.value.problem", valueName), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpForeachArrayIsUsedAsValueInspection", "buildVisitor"));
    }
}

