/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpForeachNestedOuterKeyValueVariablesConflictInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpForeachNestedOuterKeyValueVariablesConflictInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpForeach(ForeachStatement foreach) {
                ForeachStatement outerForeach = (ForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)foreach, ForeachStatement.class, (boolean)true, (Class[])new Class[]{PhpScopeHolder.class});
                if (outerForeach != null) {
                    PhpReference foreachValue = PhpWorkaroundUtil.getForeachValue(foreach);
                    PhpReference outerForeachValue = PhpWorkaroundUtil.getForeachValue(outerForeach);
                    if (foreachValue != null) {
                        String foreachValueName = foreachValue.getName();
                        if (outerForeachValue != null && PhpLangUtil.equalsVariableNames(foreachValueName, outerForeachValue.getName())) {
                            holder.registerProblem((PsiElement)foreachValue, PhpBundle.message("inspection.nested.vs.outer.foreach.variables.conflict.problem2", foreachValueName), new LocalQuickFix[0]);
                        }
                    }
                    Variable foreachKey = PhpWorkaroundUtil.getForeachKey(foreach);
                    Variable outerForeachKey = PhpWorkaroundUtil.getForeachKey(outerForeach);
                    if (foreachKey != null) {
                        String foreachKeyName = foreachKey.getName();
                        if (outerForeachKey != null && PhpLangUtil.equalsVariableNames(foreachKeyName, outerForeachKey.getName())) {
                            holder.registerProblem((PsiElement)foreachKey, PhpBundle.message("inspection.nested.vs.outer.foreach.variables.conflict.problem1", foreachKeyName), new LocalQuickFix[0]);
                        }
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpForeachNestedOuterKeyValueVariablesConflictInspection", "buildVisitor"));
    }
}

