/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpFrontBackBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageFeatureUsagesTracker;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.annotator.PhpReplaceWithElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpLanguageFeatureUsageVisitor;
import com.jetbrains.php.lang.inspections.PhpLanguageLevelDfaProcessor;
import com.jetbrains.php.lang.inspections.PhpRemoveNumericLiteralsSeparatorsQuickFix;
import com.jetbrains.php.lang.inspections.PhpReplaceFirstClassCallableQuickFix;
import com.jetbrains.php.lang.inspections.PhpReplacePromotedFieldWithTraditionalQuickFix;
import com.jetbrains.php.lang.inspections.PhpReplaceWithTernaryExpressionQuickFix;
import com.jetbrains.php.lang.inspections.PhpSwitchComposerLanguageLevelQuickFix;
import com.jetbrains.php.lang.inspections.codeStyle.PhpExpressionWithoutClarifyingParenthesesInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.quickfix.PhpIntroduceCatchVariableQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpSwitchLanguageLevelQuickFix;
import com.jetbrains.php.lang.intentions.PhpConvertShortArrowFunctionToClosureIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpCallableFunction;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClone;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpCloneImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseListImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpLanguageLevelInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpLanguageLevelInspection.$$$reportNull$$$0(0);
        }
        return new PhpLanguageFeatureUsageVisitor(true){
            private final EnumSet<PhpLanguageFeature> myUsedFeatures;
            private final PhpLanguageLevel myCurrentLevel;
            private final boolean syncWithComposer;
            {
                super(global);
                this.myUsedFeatures = PhpLanguageFeatureUsagesTracker.getInstance().getUsedFeatures(holder.getProject());
                this.myCurrentLevel = PhpProjectConfigurationFacade.getInstance(holder.getProject()).getLanguageLevel();
                this.syncWithComposer = ComposerDataService.getInstance(holder.getProject()).syncLanguageLevel();
            }

            @Override
            protected void checkPhp7TypeHints(CharSequence name, @NotNull PsiElement psi) {
                if (psi == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.myCurrentLevel.isAtLeast(PhpLanguageLevel.PHP700)) {
                    if (this.myCurrentLevel.isLessThan(PhpLanguageLevel.PHP820) && PhpLangUtil.equalsClassNames(name, "true")) {
                        holder.registerProblem(psi, PhpBundle.message("type.primitive.true.hints.names.are.forbidden", new Object[0]), this.getFixes(PhpLanguageLevel.PHP820, new LocalQuickFix[0]));
                    }
                    if (this.myCurrentLevel.isLessThan(PhpLanguageLevel.PHP800) && (PhpLangUtil.equalsClassNames(name, "false") || PhpLangUtil.equalsClassNames(name, "null"))) {
                        holder.registerProblem(psi, PhpBundle.message("type.primitive.false.null.hints.names.are.forbidden", new Object[0]), this.getFixes(PhpLanguageLevel.PHP800, new LocalQuickFix[0]));
                    }
                }
            }

            @Override
            public void visitPhpClass(PhpClass clazz) {
                super.visitPhpClass(clazz);
                CharSequence name = clazz.getNameCS();
                ASTNode node = clazz.getNameNode();
                PsiElement psi = node != null ? node.getPsi() : null;
                this.checkPhp7ClassName(name, psi);
                this.checkPhp71ClassName(name, psi);
                this.checkPhp72ClassName(name, psi);
            }

            @Override
            public void visitPhpMethod(Method method) {
                PsiElement abstractKeyword;
                super.visitPhpMethod(method);
                this.visitPhpFunction((Function)method);
                PhpModifierList modifiers = (PhpModifierList)PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)PhpModifierList.INSTANCEOF);
                if (modifiers != null && (abstractKeyword = PhpPsiUtil.getChildOfType((PsiElement)modifiers, PhpTokenTypes.kwABSTRACT)) != null) {
                    Ref abstractFunctionOverride = new Ref((Object)false);
                    Ref ambiguity = new Ref((Object)false);
                    PhpClassHierarchyUtils.processSuperMethods((Method)method, (superMethod, subClass, baseClass) -> {
                        PhpClass superContainingClass = superMethod.getContainingClass();
                        if (superMethod.isAbstract() && superContainingClass != null && !superContainingClass.isInterface() && !superContainingClass.isTrait()) {
                            abstractFunctionOverride.set((Object)true);
                        } else {
                            ambiguity.set((Object)true);
                        }
                        return false;
                    });
                    if (((Boolean)abstractFunctionOverride.get()).booleanValue() && !((Boolean)ambiguity.get()).booleanValue()) {
                        this.checkFeature(PhpLanguageFeature.ABSTRACT_FUNCTION_OVERRIDE, abstractKeyword);
                    }
                }
            }

            @Override
            protected boolean isString(PhpType type) {
                return super.isString(type.global(holder.getProject()));
            }

            @Override
            public void visitPhpUse(PhpUse expression) {
                super.visitPhpUse(expression);
                String name = expression.getAliasName();
                PsiElement psi = expression.getLastChild();
                if (!PhpUseImpl.isOfFunction(expression) && !PhpUseImpl.isOfConst(expression)) {
                    this.checkPhp7ClassName(name, psi);
                    this.checkPhp71ClassName(name, psi);
                    this.checkPhp72ClassName(name, psi);
                }
            }

            @Override
            public void visitPhpUseList(PhpUseList useList) {
                PsiElement trailingComma;
                super.visitPhpUseList(useList);
                PsiElement parent = useList.getParent();
                if (!(parent instanceof Function) && !(parent instanceof PhpClass) && PhpProjectConfigurationFacade.getInstance(useList.getProject()).getLanguageLevel().isLessThan(PhpLanguageLevel.PHP720) && (trailingComma = PhpUseListImpl.getTrailingComma(useList)) != null) {
                    holder.registerProblem(trailingComma, PhpFrontBackBundle.message((String)"PhpLanguageFeature.trailing.comma.in.group.uses", (Object[])new Object[0]), this.getFixes(PhpLanguageLevel.PHP720, LocalQuickFix.from((ModCommandAction)new PhpDeleteElementQuickFix(trailingComma))));
                }
            }

            public void visitPhpElement(PhpPsiElement element) {
                super.visitPhpElement(element);
                if (!PhpLanguageFeature.NAMESPACED_NAME_AS_SINGLE_TOKEN.isSupported(holder.getProject())) {
                    return;
                }
                ASTNode nameNode = PhpLanguageLevelInspection.getNameNode((PsiElement)element);
                if (nameNode == null) {
                    return;
                }
                PsiElement nameIdentifier = nameNode.getPsi();
                PsiElement namespaceReference = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(nameIdentifier, true);
                if (namespaceReference instanceof PhpNamespaceReference) {
                    if (PhpPsiUtil.getPrevSibling(nameIdentifier, new Condition[0]) instanceof PsiWhiteSpace) {
                        holder.registerProblem((PsiElement)element, TextRange.create((int)namespaceReference.getTextRangeInParent().getStartOffset(), (int)nameIdentifier.getTextRangeInParent().getEndOffset()), PhpBundle.message("inspection.message.qualified.name.can.t.contain.whitespaces", new Object[0]), new LocalQuickFix[]{PhpRemoveWhiteSpacesQuickFix.INSTANCE});
                    } else if (PsiTreeUtil.getChildOfType((PsiElement)namespaceReference, PsiWhiteSpace.class) != null) {
                        holder.registerProblem(namespaceReference, PhpBundle.message("inspection.message.qualified.name.can.t.contain.whitespaces", new Object[0]), new LocalQuickFix[]{PhpRemoveWhiteSpacesQuickFix.INSTANCE});
                    }
                }
            }

            @Override
            protected void checkKeywordInFQN(PsiElement child, IElementType type) {
                if (type == PhpTokenTypes.kwFN && this.myCurrentLevel.equals((Object)PhpLanguageLevel.PHP740)) {
                    holder.registerProblem(child, PhpBundle.message("inspection.php.language.level.description", new Object[0]), new LocalQuickFix[0]);
                } else {
                    super.checkKeywordInFQN(child, type);
                }
            }

            private void checkPhp7ClassName(CharSequence name, PsiElement psi) {
                if (psi != null && this.myCurrentLevel.isAtLeast(PhpLanguageLevel.PHP700) && (PhpLangUtil.equalsClassNames(name, "int") || PhpLangUtil.equalsClassNames(name, "string") || PhpLangUtil.equalsClassNames(name, "float") || PhpLangUtil.equalsClassNames(name, "bool") || PhpLangUtil.equalsClassNames(name, "true") || PhpLangUtil.equalsClassNames(name, "false") || PhpLangUtil.equalsClassNames(name, "null"))) {
                    holder.registerProblem(psi, PhpBundle.message("primitive.hints.name.are.forbidden.in.php.7", new Object[0]), new LocalQuickFix[0]);
                }
            }

            private void checkPhp71ClassName(CharSequence name, PsiElement psi) {
                if (psi != null) {
                    if (this.myCurrentLevel.isAtLeast(PhpLanguageLevel.PHP710) && (PhpLangUtil.equalsClassNames(name, "void") || PhpLangUtil.equalsClassNames(name, "iterable"))) {
                        holder.registerProblem(psi, PhpBundle.message("classes.named.void.and.iterable.are.forbidden.in.php.7.1", new Object[0]), new LocalQuickFix[0]);
                    } else if (this.myCurrentLevel.isAtLeast(PhpLanguageLevel.PHP810) && PhpLangUtil.equalsClassNames(name, "never")) {
                        holder.registerProblem(psi, PhpBundle.message("classes.named.never.is.forbidden.in.php.8.1", new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }

            private void checkPhp72ClassName(CharSequence name, PsiElement psi) {
                if (psi != null && this.myCurrentLevel.isAtLeast(PhpLanguageLevel.PHP720) && PhpLangUtil.equalsClassNames(name, "object")) {
                    holder.registerProblem(psi, PhpBundle.message("classes.named.object.are.forbidden.in.php.7.2", new Object[0]), new LocalQuickFix[0]);
                }
            }

            public void visitPhpClone(PhpClone clone) {
                PhpCloneImpl cloneImpl;
                PhpPsiElement properties;
                if (PhpLanguageFeature.CLONE_WITH_PROPERTIES.isSupported(clone.getProject())) {
                    return;
                }
                if (clone instanceof PhpCloneImpl && (properties = (cloneImpl = (PhpCloneImpl)clone).getWithProperties()) != null) {
                    holder.registerProblem((PsiElement)properties, PhpFrontBackBundle.message((String)"PhpLanguageFeature.clone.with.properties", (Object[])new Object[0]), this.getFixes(PhpLanguageLevel.PHP850, new LocalQuickFix[0]));
                }
            }

            @Override
            public void visitPhpCallableFunction(PhpCallableFunction reference) {
                super.visitPhpCallableFunction(reference);
                if (PhpPsiUtil.isOfType(reference.getFirstChild(), PhpTokenTypes.kwCLONE) && !PhpLanguageFeature.CLONE_WITH_PROPERTIES.isSupported(reference.getProject())) {
                    holder.registerProblem((PsiElement)reference, PhpBundle.message("php.annotator.clone.as.callable", new Object[0]), this.getFixes(PhpLanguageLevel.PHP850, new LocalQuickFix[0]));
                }
            }

            public void visitPhpSwitch(PhpSwitch switchStatement) {
                if (this.myCurrentLevel.isAtLeast(PhpLanguageLevel.PHP700)) {
                    int defaults = 0;
                    for (PsiElement child = switchStatement.getLastChild(); child != null; child = child.getPrevSibling()) {
                        if (!PhpPsiUtil.isOfType(child, PhpElementTypes.CASE_DEFAULT) || defaults++ <= 0) continue;
                        holder.registerProblem(child, PhpBundle.message("switch.statements.may.only.contain.one.default.clause.in.php.7", new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }

            @Override
            public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                super.visitPhpArrayAccessExpression(expression);
                if (PhpLanguageLevel.current((Project)expression.getProject()).isLessThan(PhpLanguageLevel.PHP800)) {
                    PhpPsiElement indexValue;
                    PhpPsiElement value = expression.getValue();
                    ArrayIndex index = expression.getIndex();
                    PhpPsiElement phpPsiElement = indexValue = index != null ? index.getValue() : null;
                    if (indexValue != null) {
                        if (PhpLanguageLevelInspection.isInterpolatedString(value)) {
                            holder.registerProblem((PsiElement)indexValue, PhpBundle.message("inspection.message.interpolated.string.dereferencing.available.in.php.only", new Object[0]), this.getFixes(PhpLanguageLevel.PHP800, new LocalQuickFix[0]));
                        } else if (PhpLanguageLevelInspection.isMagicConstant(value)) {
                            holder.registerProblem((PsiElement)indexValue, PhpBundle.message("inspection.message.magic.constant.dereferencing.available.in.php.only", new Object[0]), this.getFixes(PhpLanguageLevel.PHP800, new LocalQuickFix[0]));
                        }
                    }
                }
            }

            @Override
            protected void checkFeature(@NotNull PhpLanguageFeature languageFeature, @Nls @NotNull String errorMessage, @NotNull PsiElement psiElement, @Nullable TextRange rangeInElement) {
                PhpLanguageLevel languageLevelFromDFAConditions;
                if (languageFeature == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (psiElement == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.myUsedFeatures.add(languageFeature);
                if (languageFeature == PhpLanguageFeature.DOC_TEMPLATE_TAG) {
                    return;
                }
                PhpLanguageLevel preferableLanguageLevel = this.myCurrentLevel;
                if ((languageFeature == PhpLanguageFeature.STANDALONE_NULL_FALSE || languageFeature == PhpLanguageFeature.TRUE_TYPE) && this.myCurrentLevel.isLessThan(PhpLanguageLevel.PHP710)) {
                    return;
                }
                if (!(preferableLanguageLevel.hasFeature(languageFeature) || (languageLevelFromDFAConditions = PhpLanguageLevelDfaProcessor.getCurrentLanguageLevelFromDFAConditions(psiElement)) != null && languageLevelFromDFAConditions.hasFeature(languageFeature))) {
                    for (PhpLanguageLevel level : PhpLanguageLevel.values()) {
                        if (!level.hasFeature(languageFeature)) continue;
                        preferableLanguageLevel = level;
                        break;
                    }
                    ProblemHighlightType severity = languageFeature == PhpLanguageFeature.ATTRIBUTES ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    holder.registerProblem(psiElement, errorMessage, severity, rangeInElement, this.getFixes(preferableLanguageLevel, 1.getAdditionalFixes(psiElement, languageFeature)));
                }
            }

            @NotNull
            private @NotNull LocalQuickFix @NotNull [] getFixes(PhpLanguageLevel preferableLanguageLevel, LocalQuickFix ... additionalFixes) {
                if (additionalFixes == null) {
                    1.$$$reportNull$$$0(4);
                }
                LocalQuickFix quickFix = PhpLanguageLevelInspection.getSwitchLanguageLevelQuickFix(holder.getProject(), preferableLanguageLevel, this.syncWithComposer, isOnTheFly);
                return 1.getFixes(quickFix, additionalFixes);
            }

            private static LocalQuickFix[] getAdditionalFixes(@NotNull PsiElement psiElement, @NotNull PhpLanguageFeature languageFeature) {
                LocalQuickFix[] localQuickFixArray;
                PhpPsiElement newExpressionParent;
                PsiElement binaryExpression2;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (languageFeature == null) {
                    1.$$$reportNull$$$0(6);
                }
                Object additionalFix = null;
                if (PhpLanguageFeature.NUMERIC_LITERALS_SEPARATORS == languageFeature) {
                    additionalFix = PhpRemoveNumericLiteralsSeparatorsQuickFix.INSTANCE;
                } else if (PhpLanguageFeature.NULLSAFE_DEREFERENCING == languageFeature) {
                    additionalFix = PhpRemoveQuestQuickFix.INSTANCE;
                } else if (PhpLanguageFeature.CLASS_NAME_LITERAL_ON_OBJECT == languageFeature) {
                    additionalFix = PhpReplaceWithGetClassQuickFix.INSTANCE;
                } else if (PhpLanguageFeature.PROPERTY_PROMOTION == languageFeature) {
                    additionalFix = LocalQuickFix.from((ModCommandAction)new PhpReplacePromotedFieldWithTraditionalQuickFix((Parameter)psiElement));
                } else if (PhpLanguageFeature.RETURN_VOID == languageFeature || PhpLanguageFeature.CLASS_CONSTANT_VISIBILITY == languageFeature || PhpLanguageFeature.FINAL_CLASS_CONSTANTS == languageFeature || PhpLanguageFeature.READONLY_PROPERTIES == languageFeature || PhpLanguageFeature.READONLY_CLASSES == languageFeature || PhpLanguageFeature.TYPED_CLASS_CONSTANTS == languageFeature) {
                    additionalFix = LocalQuickFix.from((ModCommandAction)new PhpDeleteElementQuickFix(psiElement));
                } else if (PhpLanguageFeature.NULLABLES == languageFeature) {
                    PsiElement opQuest;
                    PhpTypeDeclaration typeDeclaration = PhpPsiUtil.getParentOfClass(psiElement, false, PhpTypeDeclaration.class);
                    PsiElement psiElement2 = opQuest = typeDeclaration != null ? PhpPsiUtil.getChildOfType((PsiElement)typeDeclaration, PhpTokenTypes.opQUEST) : null;
                    if (opQuest != null) {
                        additionalFix = LocalQuickFix.from((ModCommandAction)new PhpDeleteElementQuickFix(opQuest));
                    }
                } else if (PhpLanguageFeature.CATCH_MULTIPLE == languageFeature) {
                    additionalFix = PhpSplitIntoMultipleCatchesQuickFix.INSTANCE;
                } else if (PhpLanguageFeature.ARROW_FUNCTION_SYNTAX == languageFeature) {
                    additionalFix = PhpConvertShortArrowFunctionToClosureQuickFix.INSTANCE;
                } else if (PhpLanguageFeature.STATIC_RETURN_TYPE_HINT == languageFeature) {
                    PhpClass phpClass = PhpPsiUtil.getParentOfClass(psiElement, true, PhpClass.class);
                    if (phpClass != null) {
                        additionalFix = new PhpReplaceWithCurrentClassQuickFix(phpClass.getName());
                    }
                } else if (PhpLanguageFeature.NON_CAPTURING_CATCHES == languageFeature) {
                    additionalFix = PhpIntroduceCatchVariableQuickFix.INSTANCE;
                } else if (PhpLanguageFeature.COALESCE_OPERATOR == languageFeature) {
                    BinaryExpression binaryExpression2 = PhpPsiUtil.getParentOfClass(psiElement, false, BinaryExpression.class);
                    if (binaryExpression2 != null && !PhpSideEffectDetector.canContainSideEffect((PsiElement)binaryExpression2)) {
                        additionalFix = PhpReplaceWithTernaryExpressionQuickFix.INSTANCE;
                    }
                } else if (PhpLanguageFeature.EXPLICIT_OCTAL_LITERAL == languageFeature) {
                    additionalFix = new PhpReplaceWithImplicitOctalNotationQuickFix(psiElement.getText());
                } else if (PhpLanguageFeature.FIRST_CLASS_CALLABLE == languageFeature && PhpLanguageLevel.current((Project)psiElement.getProject()).isAtLeast(PhpLanguageLevel.PHP710)) {
                    additionalFix = PhpReplaceFirstClassCallableQuickFix.INSTANCE;
                } else if (PhpLanguageFeature.NEW_WITHOUT_PARENTHESES == languageFeature && psiElement instanceof PhpPsiElement && (binaryExpression2 = (newExpressionParent = (PhpPsiElement)psiElement).getFirstPsiChild()) instanceof NewExpression) {
                    NewExpression expression = (NewExpression)binaryExpression2;
                    additionalFix = LocalQuickFix.from((ModCommandAction)new PhpAddParenthesesAroundNewCallQuickFix(expression));
                } else if (PhpLanguageFeature.FINAL_PROPERTY_PROMOTION == languageFeature && (binaryExpression2 = psiElement.getParent()) instanceof PhpPromotedFieldParameterImpl) {
                    PhpPromotedFieldParameterImpl promotedFieldParameter = (PhpPromotedFieldParameterImpl)binaryExpression2;
                    List<PsiElement> visibilityModifiers = PhpPsiUtil.getChildrenOfType((PsiElement)promotedFieldParameter, PhpTokenTypes.tsVISIBILITY_MODIFIERS);
                    additionalFix = visibilityModifiers.isEmpty() ? LocalQuickFix.from((ModCommandAction)new PhpReplaceWithElementQuickFix(psiElement, PhpPsiElementFactory.createFromText(promotedFieldParameter.getProject(), PhpTokenTypes.kwPUBLIC, PhpModifier.Access.PUBLIC.toString()))) : LocalQuickFix.from((ModCommandAction)new PhpDeleteElementQuickFix(psiElement));
                } else if (PhpLanguageFeature.ATTRIBUTES_ON_CONSTANTS == languageFeature) {
                    additionalFix = LocalQuickFix.from((ModCommandAction)new PhpDeleteElementQuickFix(psiElement));
                }
                if (additionalFix != null) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = additionalFix;
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                return localQuickFixArray;
            }

            @NotNull
            private static @NotNull LocalQuickFix @NotNull [] getFixes(@Nullable LocalQuickFix quickFix, @NotNull @NotNull LocalQuickFix @NotNull [] additionalFixes) {
                if (additionalFixes == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (quickFix == null) {
                    if (additionalFixes == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    return additionalFixes;
                }
                if (additionalFixes.length == 0) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{quickFix};
                    if (localQuickFixArray == null) {
                        1.$$$reportNull$$$0(9);
                    }
                    return localQuickFixArray;
                }
                LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])ArrayUtil.prepend((Object)quickFix, (Object[])additionalFixes);
                if (localQuickFixArray == null) {
                    1.$$$reportNull$$$0(10);
                }
                return localQuickFixArray;
            }

            @Override
            public void visitPhpField(Field field) {
                this.checkEnumFieldReferenceInConstantValue(field.getDefaultValue());
                super.visitPhpField(field);
            }

            @Override
            public void visitPhpConstant(Constant constant) {
                this.checkEnumFieldReferenceInConstantValue(constant.getValue());
                super.visitPhpConstant(constant);
            }

            @Override
            public void visitPhpAttribute(PhpAttribute attribute) {
                for (PsiElement parameter : attribute.getParameters()) {
                    this.checkEnumFieldReferenceInConstantValue(parameter);
                }
                super.visitPhpAttribute(attribute);
            }

            @Override
            public void visitPhpParameter(Parameter parameter) {
                this.checkEnumFieldReferenceInConstantValue(parameter.getDefaultValue());
                super.visitPhpParameter(parameter);
            }

            @Override
            public void visitPhpStaticStatement(PhpStaticStatement staticStatement) {
                for (AssignmentExpression declaration : staticStatement.getDeclarations()) {
                    this.checkEnumFieldReferenceInConstantValue((PsiElement)declaration.getValue());
                }
                super.visitPhpStaticStatement(staticStatement);
            }

            private void checkEnumFieldReferenceInConstantValue(@Nullable PsiElement value) {
                FieldReference enumFieldReference;
                if (value != null && PhpLanguageLevel.current((Project)value.getProject()).isLessThan(PhpLanguageLevel.PHP820) && (enumFieldReference = PhpLanguageLevelInspection.this.findEnumFieldReference(value)) != null) {
                    holder.registerProblem((PsiElement)enumFieldReference, PhpBundle.message("inspection.message.enum.field.reference.in.constant.expression.allowed.only.from.php", new Object[0]), this.getFixes(PhpLanguageLevel.PHP820, new LocalQuickFix[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 8, 9, 10 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psi";
                        break;
                    }
                    case 1: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "languageFeature";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiElement";
                        break;
                    }
                    case 4: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "additionalFixes";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$1";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFixes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "checkPhp7TypeHints";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "checkFeature";
                        break;
                    }
                    case 4: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "getFixes";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getAdditionalFixes";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 8, 9, 10 -> new IllegalStateException(string);
                };
            }
        };
    }

    private FieldReference findEnumFieldReference(@NotNull PsiElement value) {
        if (value == null) {
            PhpLanguageLevelInspection.$$$reportNull$$$0(1);
        }
        final Ref res = new Ref(null);
        value.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(this){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element instanceof FieldReference && PhpCodeValidationUtil.isEnumFieldReference(element)) {
                    res.set((Object)((FieldReference)element));
                    this.stopWalking();
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$2", "visitElement"));
            }
        });
        return (FieldReference)res.get();
    }

    public static boolean isMagicConstant(PhpPsiElement value) {
        return value instanceof ConstantReference && value.getName() != null && PhpLangUtil.MAGIC_CONSTANT_NAMES.contains(value.getName());
    }

    private static boolean isInterpolatedString(PhpPsiElement value) {
        return value instanceof StringLiteralExpression && !((StringLiteralExpression)value).isSingleQuote() && PhpPsiUtil.getChildByCondition((PsiElement)value, (Condition<? super PsiElement>)Variable.INSTANCEOF) != null;
    }

    @Nullable
    private static ASTNode getNameNode(@Nullable PsiElement element) {
        return element instanceof PhpNamedElement ? ((PhpNamedElement)element).getNameNode() : (element instanceof PhpReference ? ((PhpReference)element).getNameNode() : null);
    }

    @Nullable
    public static LocalQuickFix getSwitchLanguageLevelQuickFix(Project project, PhpLanguageLevel preferableLanguageLevel, boolean syncWithComposer, boolean isOnTheFly) {
        if (!syncWithComposer) {
            return PhpSwitchLanguageLevelQuickFix.getInstance(preferableLanguageLevel);
        }
        return PhpSwitchComposerLanguageLevelQuickFix.getInstance(project, preferableLanguageLevel, isOnTheFly);
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.settingLink((String)PhpBundle.message("link.label.languages.frameworks.php", new Object[0]), (String)"reference.webide.settings.project.settings.php")});
        if (optPane == null) {
            PhpLanguageLevelInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findEnumFieldReference";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class PhpAddParenthesesAroundNewCallQuickFix
    extends PsiUpdateModCommandAction<NewExpression> {
        protected PhpAddParenthesesAroundNewCallQuickFix(@NotNull NewExpression element) {
            if (element == null) {
                PhpAddParenthesesAroundNewCallQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.add.parentheses.around.new.call", new Object[0]);
            if (string == null) {
                PhpAddParenthesesAroundNewCallQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull NewExpression newExpression, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpAddParenthesesAroundNewCallQuickFix.$$$reportNull$$$0(2);
            }
            if (newExpression == null) {
                PhpAddParenthesesAroundNewCallQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpAddParenthesesAroundNewCallQuickFix.$$$reportNull$$$0(4);
            }
            ModCommand.psiUpdate((PsiElement)newExpression, newExpressionCopy -> PhpExpressionWithoutClarifyingParenthesesInspection.wrapInParens((PsiElement)newExpression));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpAddParenthesesAroundNewCallQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newExpression";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpAddParenthesesAroundNewCallQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpReplaceWithImplicitOctalNotationQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myExplicitOctalText;

        private PhpReplaceWithImplicitOctalNotationQuickFix(@NotNull @NlsSafe String explicitOctalText) {
            if (explicitOctalText == null) {
                PhpReplaceWithImplicitOctalNotationQuickFix.$$$reportNull$$$0(0);
            }
            this.myExplicitOctalText = explicitOctalText;
        }

        @NotNull
        public String getName() {
            String string = PhpBundle.message("php.replace.with", "0" + this.myExplicitOctalText.substring(2));
            if (string == null) {
                PhpReplaceWithImplicitOctalNotationQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.implicit.octal.notation", new Object[0]);
            if (string == null) {
                PhpReplaceWithImplicitOctalNotationQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceWithImplicitOctalNotationQuickFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                PhpReplaceWithImplicitOctalNotationQuickFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                PhpReplaceWithImplicitOctalNotationQuickFix.$$$reportNull$$$0(5);
            }
            PhpExpression explicitOctal = (PhpExpression)ObjectUtils.tryCast((Object)element, PhpExpression.class);
            assert (explicitOctal != null);
            PhpExpression implicitOctal = PhpPsiElementFactory.createFromText(project, PhpExpression.class, "0" + explicitOctal.getText().substring(2));
            assert (implicitOctal != null);
            explicitOctal.replace((PsiElement)implicitOctal);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "explicitOctalText";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpReplaceWithImplicitOctalNotationQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpReplaceWithImplicitOctalNotationQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpReplaceWithCurrentClassQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myClassName;

        private PhpReplaceWithCurrentClassQuickFix(@NotNull @NlsSafe String className) {
            if (className == null) {
                PhpReplaceWithCurrentClassQuickFix.$$$reportNull$$$0(0);
            }
            this.myClassName = className;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.replace.with", this.myClassName);
            if (string == null) {
                PhpReplaceWithCurrentClassQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceWithCurrentClassQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpReplaceWithCurrentClassQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpReplaceWithCurrentClassQuickFix.$$$reportNull$$$0(4);
            }
            element.replace((PsiElement)PhpPsiElementFactory.createClassReference(project, this.myClassName));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpReplaceWithCurrentClassQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpReplaceWithCurrentClassQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpConvertShortArrowFunctionToClosureQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpConvertShortArrowFunctionToClosureQuickFix();

        private PhpConvertShortArrowFunctionToClosureQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("convert.the.arrow.function.to.a.traditional.closure", new Object[0]);
            if (string == null) {
                PhpConvertShortArrowFunctionToClosureQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpConvertShortArrowFunctionToClosureQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpConvertShortArrowFunctionToClosureQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpConvertShortArrowFunctionToClosureQuickFix.$$$reportNull$$$0(3);
            }
            PhpConvertShortArrowFunctionToClosureIntention.convertArrowFunctionToClosure(project, PhpPsiUtil.getParentOfClass(element, false, Function.class));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpConvertShortArrowFunctionToClosureQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpConvertShortArrowFunctionToClosureQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpSplitIntoMultipleCatchesQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpSplitIntoMultipleCatchesQuickFix();

        private PhpSplitIntoMultipleCatchesQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.split.into.multiple.catch.statements", new Object[0]);
            if (string == null) {
                PhpSplitIntoMultipleCatchesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Catch phpCatch;
            if (project == null) {
                PhpSplitIntoMultipleCatchesQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpSplitIntoMultipleCatchesQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpSplitIntoMultipleCatchesQuickFix.$$$reportNull$$$0(3);
            }
            if ((phpCatch = PhpPsiUtil.getParentOfClass(element, false, Catch.class)) == null) {
                return;
            }
            ClassReference exceptionTypeToKeep = (ClassReference)ContainerUtil.getFirstItem((Collection)phpCatch.getExceptionTypes());
            Collection<Catch> catchesToAdd = PhpSplitIntoMultipleCatchesQuickFix.createCatchesToAdd(exceptionTypeToKeep, phpCatch);
            Catch anchorToAddAfter = phpCatch;
            for (Catch catchToAdd : catchesToAdd) {
                anchorToAddAfter = phpCatch.getParent().addAfter((PsiElement)catchToAdd, (PsiElement)anchorToAddAfter);
            }
            PhpSplitIntoMultipleCatchesQuickFix.removeAllCatchTypesExceptChosen(exceptionTypeToKeep, phpCatch);
        }

        private static Collection<Catch> createCatchesToAdd(ClassReference exceptionTypeToKeep, Catch phpCatch) {
            return phpCatch.getExceptionTypes().stream().filter(e -> exceptionTypeToKeep != e).map(e -> {
                Catch catchCopy = (Catch)phpCatch.copy();
                PhpSplitIntoMultipleCatchesQuickFix.removeAllCatchTypesExceptChosen(e, catchCopy);
                return catchCopy;
            }).collect(Collectors.toList());
        }

        private static void removeAllCatchTypesExceptChosen(ClassReference chosenExceptionType, Catch phpCatch) {
            PsiElement copy = chosenExceptionType.copy();
            Collection types = phpCatch.getExceptionTypes();
            phpCatch.deleteChildRange((PsiElement)ContainerUtil.getFirstItem((Collection)types), (PsiElement)ContainerUtil.iterateAndGetLastItem((Iterable)types));
            PsiElement lParen = PhpPsiUtil.getChildOfType((PsiElement)phpCatch, PhpTokenTypes.chLPAREN);
            phpCatch.addAfter(copy, lParen);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpSplitIntoMultipleCatchesQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpSplitIntoMultipleCatchesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpReplaceWithGetClassQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpReplaceWithGetClassQuickFix();

        private PhpReplaceWithGetClassQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.get.class.call", new Object[0]);
            if (string == null) {
                PhpReplaceWithGetClassQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceWithGetClassQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceWithGetClassQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithGetClassQuickFix.$$$reportNull$$$0(3);
            }
            PsiElement parent = element.getParent();
            String argumentText = parent.getFirstChild().getText();
            FunctionReference getClassCall = PhpPsiElementFactory.createFromText(project, FunctionReference.class, "get_class(" + argumentText + ")");
            assert (getClassCall != null);
            parent.replace((PsiElement)getClassCall);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpReplaceWithGetClassQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpReplaceWithGetClassQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpRemoveQuestQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpRemoveQuestQuickFix();

        private PhpRemoveQuestQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("annotator.fix.remove", "?");
            if (string == null) {
                PhpRemoveQuestQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpRemoveQuestQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpRemoveQuestQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpRemoveQuestQuickFix.$$$reportNull$$$0(3);
            }
            element.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpRemoveQuestQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpRemoveQuestQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpRemoveWhiteSpacesQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpRemoveWhiteSpacesQuickFix();

        private PhpRemoveWhiteSpacesQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.collapse.whitespaces", new Object[0]);
            if (string == null) {
                PhpRemoveWhiteSpacesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpNamespaceReference namespaceReference;
            if (project == null) {
                PhpRemoveWhiteSpacesQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpRemoveWhiteSpacesQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpRemoveWhiteSpacesQuickFix.$$$reportNull$$$0(3);
            }
            if ((namespaceReference = (PhpNamespaceReference)ObjectUtils.tryCast((Object)element, PhpNamespaceReference.class)) != null) {
                PhpRemoveWhiteSpacesQuickFix.removeWhitespaces(namespaceReference);
                return;
            }
            ASTNode nameNode = PhpLanguageLevelInspection.getNameNode(element);
            if (nameNode == null) {
                return;
            }
            PhpNamespaceReference prevNamespaceReference = (PhpNamespaceReference)ObjectUtils.tryCast((Object)PhpPsiUtil.getPrevSiblingIgnoreWhitespace(nameNode.getPsi(), true), PhpNamespaceReference.class);
            if (prevNamespaceReference == null) {
                return;
            }
            PhpRemoveWhiteSpacesQuickFix.getWhitespacesBetweenNamespaceAndNameNode(prevNamespaceReference, nameNode).forEach(PsiElement::delete);
            PhpRemoveWhiteSpacesQuickFix.removeWhitespaces(prevNamespaceReference);
        }

        private static void removeWhitespaces(PhpNamespaceReference namespaceReference) {
            PsiWhiteSpace[] whiteSpaces = (PsiWhiteSpace[])PsiTreeUtil.getChildrenOfType((PsiElement)namespaceReference, PsiWhiteSpace.class);
            if (whiteSpaces != null) {
                for (PsiWhiteSpace space : whiteSpaces) {
                    space.delete();
                }
            }
        }

        @NotNull
        private static Collection<PsiWhiteSpace> getWhitespacesBetweenNamespaceAndNameNode(@NotNull PhpNamespaceReference namespaceReference, ASTNode nameNode) {
            if (namespaceReference == null) {
                PhpRemoveWhiteSpacesQuickFix.$$$reportNull$$$0(4);
            }
            if (nameNode == null) {
                List<PsiWhiteSpace> list = Collections.emptyList();
                if (list == null) {
                    PhpRemoveWhiteSpacesQuickFix.$$$reportNull$$$0(5);
                }
                return list;
            }
            ArrayList<PsiWhiteSpace> whitespacesBetweenNamespaceAndNameNode = new ArrayList<PsiWhiteSpace>();
            for (PsiElement possibleWhitespace = nameNode.getPsi(); possibleWhitespace != namespaceReference; possibleWhitespace = possibleWhitespace.getPrevSibling()) {
                if (!(possibleWhitespace instanceof PsiWhiteSpace)) continue;
                whitespacesBetweenNamespaceAndNameNode.add((PsiWhiteSpace)possibleWhitespace);
            }
            ArrayList<PsiWhiteSpace> arrayList = whitespacesBetweenNamespaceAndNameNode;
            if (arrayList == null) {
                PhpRemoveWhiteSpacesQuickFix.$$$reportNull$$$0(6);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpRemoveWhiteSpacesQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaceReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageLevelInspection$PhpRemoveWhiteSpacesQuickFix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWhitespacesBetweenNamespaceAndNameNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getWhitespacesBetweenNamespaceAndNameNode";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

