/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class PhpOptionalBeforeRequiredParametersInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpOptionalBeforeRequiredParametersInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpFunction(Function function) {
                PhpOptionalBeforeRequiredParametersInspection.process(function, holder);
            }

            public void visitPhpClass(PhpClass clazz) {
                for (Method it : clazz.getOwnMethods()) {
                    PhpOptionalBeforeRequiredParametersInspection.process((Function)it, holder);
                }
            }
        };
    }

    private static void process(Function function, ProblemsHolder holder) {
        Parameter[] parameters = (Parameter[])Arrays.stream(function.getParameters()).filter(it -> !(it instanceof PhpPromotedFieldParameterImpl)).toArray(Parameter[]::new);
        if (parameters.length == 0) {
            return;
        }
        int lastRequired = ContainerUtil.lastIndexOf(Arrays.asList(parameters), p -> !p.isOptional() && !p.isVariadic());
        for (int i = 0; i < lastRequired; ++i) {
            if (!parameters[i].isOptional()) continue;
            holder.registerProblem((PsiElement)parameters[i], PhpOptionalBeforeRequiredParametersInspection.getMessage(), PhpOptionalBeforeRequiredParametersInspection.isTypedWithNullDefaultValue(parameters[i]) ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.WARNING, new LocalQuickFix[0]);
        }
    }

    private static boolean isTypedWithNullDefaultValue(Parameter parameter) {
        return !parameter.getDeclaredType().isEmpty() && PhpLangUtil.isNull(parameter.getDefaultValue());
    }

    @InspectionMessage
    public static String getMessage() {
        return PhpBundle.message("inspection.optional.before.required", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpOptionalBeforeRequiredParametersInspection", "buildVisitor"));
    }
}

