/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpFieldCanBePromotedInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpAddAttributeQuickFixBase;
import com.jetbrains.php.lang.inspections.attributes.PhpInapplicableAttributeTargetDeclarationInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpRemoveAttributeQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpModifierListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpReplacePromotedFieldWithTraditionalQuickFix
extends PsiUpdateModCommandAction<Parameter> {
    public PhpReplacePromotedFieldWithTraditionalQuickFix(@NotNull Parameter element) {
        if (element == null) {
            PhpReplacePromotedFieldWithTraditionalQuickFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)element);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull Parameter startElement, @NotNull ModPsiUpdater updater) {
        PsiElement readonlyNode;
        PhpClassFieldsList classFieldsList;
        PsiElement newVisibility;
        if (context == null) {
            PhpReplacePromotedFieldWithTraditionalQuickFix.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            PhpReplacePromotedFieldWithTraditionalQuickFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            PhpReplacePromotedFieldWithTraditionalQuickFix.$$$reportNull$$$0(3);
        }
        PhpPromotedFieldParameterImpl promotedField = (PhpPromotedFieldParameterImpl)startElement;
        Project project = context.project();
        PhpModifier modifier = promotedField.getModifier();
        PhpClass containingClass = PhpPsiUtil.getParentOfClass((PsiElement)startElement, PhpClass.class);
        if (containingClass == null) {
            return;
        }
        List<PsiElement> tokens = PhpPsiUtil.getChildrenOfType((PsiElement)promotedField, PhpTokenTypes.tsVISIBILITY_MODIFIERS);
        PsiElement visibility = (PsiElement)ContainerUtil.find(tokens, it -> !PhpModifierListImpl.isSetOperationModifier(it));
        PsiElement setVisibility = PhpModifierListImpl.getSetOperationModifierPsiElement((PsiElement)promotedField);
        PsiElement finalKeyword = promotedField.getFinalKeyword();
        if (visibility == null && setVisibility == null && finalKeyword == null && !promotedField.hasPropertyHooksContainer() && !promotedField.isReadonly()) {
            return;
        }
        PsiElement defaultValue = promotedField.getDefaultValue();
        String fieldName = promotedField.getName();
        boolean keepDefaultValue = defaultValue != null && !promotedField.isReadonly() && PhpCodeValidationUtil.isAllowedAsFieldDefaultValue(defaultValue);
        boolean isExplicitReadonly = promotedField.isReadonly() && !containingClass.isReadonly();
        PhpPsiElement traditionalField = PhpPsiElementFactory.createClassField(project, modifier, isExplicitReadonly, fieldName, keepDefaultValue ? defaultValue.getText() : null, PhpRefactoringUtil.createFieldTypeDeclaration(project, promotedField.getDeclaredType(), (PsiElement)containingClass), null, finalKeyword != null);
        PhpReplacePromotedFieldWithTraditionalQuickFix.insertPropertyHooks(project, promotedField, traditionalField);
        PsiElement newField = PhpCodeEditUtil.insertClassMember(containingClass, (PsiElement)traditionalField);
        if (setVisibility != null) {
            PhpDeleteElementQuickFix.deleteSetOperation(setVisibility);
            setVisibility.delete();
        }
        if (visibility != null) {
            visibility.delete();
        } else if (newField instanceof PhpClassFieldsList && (newVisibility = PhpFieldCanBePromotedInspection.getVisibilityModifier((PsiElement)(classFieldsList = (PhpClassFieldsList)newField).getModifierList())) != null) {
            newVisibility.delete();
        }
        if (promotedField.isReadonly() && (readonlyNode = FieldImpl.getReadonlyKeyword((PsiElement)promotedField)) != null) {
            readonlyNode.delete();
        }
        if (finalKeyword != null) {
            finalKeyword.delete();
        }
        ArrayList<PhpAttribute> attributesToCopy = new ArrayList<PhpAttribute>();
        ArrayList<PhpAttribute> attributesToRemove = new ArrayList<PhpAttribute>();
        for (PhpAttribute attribute : promotedField.getAttributes()) {
            List<@NotNull PhpAttribute> rootAttributes = PhpInapplicableAttributeTargetDeclarationInspection.getRootAttributes(attribute);
            Collection<@NotNull PhpExpectedFunctionArgument> arguments = PhpInapplicableAttributeTargetDeclarationInspection.collectArguments(rootAttributes);
            boolean targetsProperty = PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_PROPERTY");
            if (targetsProperty) {
                attributesToCopy.add(attribute);
            }
            if (!targetsProperty || PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_PARAMETER")) continue;
            attributesToRemove.add(attribute);
        }
        for (PhpAttribute attribute : attributesToCopy) {
            PhpAddAttributeQuickFixBase.addAttribute((PhpAttributesOwner)((PhpClassFieldsList)newField), attribute.getText());
        }
        for (PhpAttribute attribute : attributesToRemove) {
            PhpRemoveAttributeQuickFix.removeAttribute((PsiElement)attribute);
        }
        Object gs = PhpPsiUtil.getChildByCondition((PsiElement)PhpPsiUtil.getParentOfClass((PsiElement)promotedField, Method.class), (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        assert (gs != null);
        AssignmentExpression assignmentExpression = PhpPsiElementFactory.createPhpPsiFromText(project, AssignmentExpression.class, String.format("$this->%s =%s $%s;", fieldName, promotedField.isPassByRef() ? "&" : "", fieldName));
        gs.addAfter(assignmentExpression.getParent(), gs.getFirstChild());
    }

    private static void insertPropertyHooks(Project project, PhpPromotedFieldParameterImpl promotedField, PhpPsiElement traditionalField) {
        if (!PhpLanguageFeature.PROPERTY_HOOKS.isSupported(project)) {
            return;
        }
        PsiElement hooksContainer = FieldImpl.getPropertyHooksContainer(promotedField);
        if (hooksContainer == null) {
            return;
        }
        PsiElement semicolon = traditionalField.getLastChild();
        if (PhpPsiUtil.isOfType(semicolon, PhpTokenTypes.opSEMICOLON)) {
            semicolon.delete();
        }
        traditionalField.addAfter(hooksContainer, traditionalField.getLastChild());
        hooksContainer.delete();
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.family.name.replace.with.traditional.property.declaration", new Object[0]);
        if (string == null) {
            PhpReplacePromotedFieldWithTraditionalQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull Parameter element) {
        if (context == null) {
            PhpReplacePromotedFieldWithTraditionalQuickFix.$$$reportNull$$$0(5);
        }
        if (element == null) {
            PhpReplacePromotedFieldWithTraditionalQuickFix.$$$reportNull$$$0(6);
        }
        return Presentation.of((String)this.getFamilyName()).withPriority(PriorityAction.Priority.HIGH);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpReplacePromotedFieldWithTraditionalQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpReplacePromotedFieldWithTraditionalQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

