/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.inspections.PhpStaticVsDynamicInspectionBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpStaticAsDynamicMethodCallInspection
extends PhpStaticVsDynamicInspectionBase {
    private static final LocalQuickFix MAKE_CALL_STATIC_FIX = new MakeCallStaticQuickFix();
    public static final String MAKE_CALL_STATIC_FIX_NAME = MAKE_CALL_STATIC_FIX.getName();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpStaticAsDynamicMethodCallInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethodReference(MethodReference methodReference) {
                if (PhpPsiUtil.isOfType(methodReference.getParent(), (IElementType)PhpStubElementTypes.TRAIT_USE_RULE)) {
                    return;
                }
                String methodName = methodReference.getName();
                if (methodName == null) {
                    return;
                }
                if (1.isDynamic(methodReference)) {
                    Collection resolvedElements = methodReference.multiResolveStrict(Method.class);
                    if (resolvedElements.isEmpty() || !ContainerUtil.and((Iterable)resolvedElements, Method::isStatic)) {
                        return;
                    }
                    Project project = methodReference.getProject();
                    PhpType type = new PhpType();
                    resolvedElements.forEach(m -> type.add((PsiElement)m.getContainingClass()));
                    boolean hasMagic = PhpCodeInsightUtil.hasMagicMethod(type, PhpIndex.getInstance((Project)project), "__call");
                    if (hasMagic) {
                        if (!PhpStaticAsDynamicMethodCallInspection.this.isShowForMagic()) {
                            return;
                        }
                        holder.registerProblem(methodReference.getNameNode().getPsi(), PhpBundle.message("inspection.static.method.called.as.dynamic.problem.magic", new Object[0]), PhpStaticAsDynamicMethodCallInspection.this.getMagicHighlightType(), LocalQuickFix.notNullElements((LocalQuickFix)1.getQuickFix(methodReference)));
                    } else {
                        holder.registerProblem(methodReference.getNameNode().getPsi(), PhpBundle.message("inspection.static.method.called.as.dynamic.problem", new Object[0]), LocalQuickFix.notNullElements((LocalQuickFix)1.getQuickFix(methodReference)));
                    }
                }
            }

            @Nullable
            private static LocalQuickFix getQuickFix(@NotNull MethodReference methodReference) {
                PhpLanguageLevel languageLevel;
                if (methodReference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((languageLevel = PhpProjectConfigurationFacade.getInstance(methodReference.getProject()).getLanguageLevel()).hasFeature(PhpLanguageFeature.UNIFORM_VARIABLE_SYNTAX) || methodReference.getFirstChild() instanceof Variable) {
                    return MAKE_CALL_STATIC_FIX;
                }
                return null;
            }

            private static boolean isDynamic(@NotNull MethodReference methodReference) {
                if (methodReference == null) {
                    1.$$$reportNull$$$0(1);
                }
                return PhpPsiUtil.getChildOfType((PsiElement)methodReference, PhpTokenTypes.ARROW) != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "methodReference";
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpStaticAsDynamicMethodCallInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getQuickFix";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isDynamic";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpStaticAsDynamicMethodCallInspection", "buildVisitor"));
    }

    public static class MakeCallStaticQuickFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.make.call.static.name", new Object[0]);
            if (string == null) {
                MakeCallStaticQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            MemberReference methodReference;
            if (project == null) {
                MakeCallStaticQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                MakeCallStaticQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                MakeCallStaticQuickFix.$$$reportNull$$$0(3);
            }
            if ((methodReference = (MemberReference)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)MemberReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF)) == null) {
                return;
            }
            PhpExpression classReference = methodReference.getClassReference();
            assert (classReference != null);
            PsiElement arrow = PhpPsiUtil.getChildOfType((PsiElement)methodReference, PhpTokenTypes.ARROW);
            if (arrow == null) {
                updater.cancel(PhpBundle.message("quickfix.can.not.find.dynamic.method.reference", new Object[0]));
                return;
            }
            arrow.replace(PhpPsiElementFactory.createScopeResolution(project));
            if ("$this".equals(classReference.getText())) {
                classReference.replace((PsiElement)PhpPsiElementFactory.createClassReference(project, "static"));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpStaticAsDynamicMethodCallInspection$MakeCallStaticQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpStaticAsDynamicMethodCallInspection$MakeCallStaticQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

