/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpDFAUtil;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionsDFAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpFqnSimpleFunctionDefinedDfaAnalyzer;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpImportConstantQuickFix;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUndefinedConstantInspection
extends PhpInspection {
    public static final String DEFINED = "defined";
    public static final PhpReachingDefinitionsDFAnalyzer DF_ANALYZER = new PhpFqnSimpleFunctionDefinedDfaAnalyzer("defined");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedConstantInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpConstantReference(ConstantReference reference) {
                String name = reference.getName();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    return;
                }
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null) {
                    return;
                }
                if (PhpLangUtil.isBuiltInConstant(name, reference.getProject())) {
                    return;
                }
                ResolveResult[] results = ((PsiPolyVariantReference)reference.getReference()).multiResolve(false);
                if (results.length == 0) {
                    Ref canBeDefined = Ref.create((Object)false);
                    Ref canBeUndefined = Ref.create((Object)false);
                    PhpDFAUtil.processDfaReachability((PhpReference)reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined, reference.getFQN(), DF_ANALYZER);
                    if (!((Boolean)canBeDefined.get()).booleanValue()) {
                        LocalQuickFix[] localQuickFixArray;
                        if (PhpImportConstantQuickFix.INSTANCE.isApplicable(nameNode.getPsi())) {
                            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                            localQuickFixArray = localQuickFixArray2;
                            localQuickFixArray2[0] = PhpImportConstantQuickFix.INSTANCE;
                        } else {
                            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                        }
                        LocalQuickFix[] fixes = localQuickFixArray;
                        holder.registerProblem(nameNode.getPsi(), PhpUndefinedConstantInspection.getPROBLEM_1(), fixes);
                    } else if (((Boolean)canBeUndefined.get()).booleanValue()) {
                        holder.registerProblem(nameNode.getPsi(), PhpUndefinedConstantInspection.getPROBLEM_2(), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    @Nullable
    public static Boolean isDfaReachable(ConstantReference reference) {
        return PhpDFAUtil.isDfaReachable((PhpReference)reference, DF_ANALYZER);
    }

    @InspectionMessage
    private static String getPROBLEM_1() {
        return PhpBundle.message("inspection.undefined.constant.problem1", new Object[0]);
    }

    @InspectionMessage
    private static String getPROBLEM_2() {
        return PhpBundle.message("inspection.undefined.constant.problem2", new Object[0]);
    }

    @Override
    @Nullable
    protected ProblemHighlightType getPhp8CustomSeverity() {
        return ProblemHighlightType.ERROR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpUndefinedConstantInspection", "buildVisitor"));
    }
}

