/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitDataProviderInspectionBase;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitDeprecatedDataProviderSignatureInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitUndefinedDataProviderInspection
extends PhpUnitDataProviderInspectionBase {
    @Override
    protected void doCheck(@NotNull PsiElement elementToHighlight, Pair<String, String> classFqnAndMethodName, Pair<PhpClass, Method> classAndMethod, @NotNull ProblemsHolder holder) {
        if (elementToHighlight == null) {
            PhpUnitUndefinedDataProviderInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PhpUnitUndefinedDataProviderInspection.$$$reportNull$$$0(1);
        }
        if (classAndMethod.getSecond() == null) {
            String classFqn = (String)classFqnAndMethodName.getFirst();
            PhpClass targetClass = PhpUnitUndefinedDataProviderInspection.getProviderTargetClass(elementToHighlight, (PhpClass)classAndMethod.getFirst(), classFqn);
            PhpCreateDataProviderQuickFix fix = targetClass != null ? new PhpCreateDataProviderQuickFix(targetClass, (String)classFqnAndMethodName.getSecond()) : null;
            String message = PhpBundle.message("inspection.undefined.phpunit.provider", PhpUnitUndefinedDataProviderInspection.getPresentableName(classFqn, (String)classFqnAndMethodName.getSecond()));
            holder.problem(elementToHighlight, message).maybeFix((ModCommandAction)fix).register();
        }
    }

    @NotNull
    private static String getPresentableName(@Nullable String classFqn, @NotNull String methodName) {
        if (methodName == null) {
            PhpUnitUndefinedDataProviderInspection.$$$reportNull$$$0(2);
        }
        Object object = classFqn != null ? PhpLangUtil.toPresentableFQN(classFqn) + "::" + methodName : methodName;
        if (object == null) {
            PhpUnitUndefinedDataProviderInspection.$$$reportNull$$$0(3);
        }
        return object;
    }

    @Nullable
    private static PhpClass getProviderTargetClass(@NotNull PsiElement contextElement, @Nullable PhpClass resolvedClass, @Nullable String classFqn) {
        if (contextElement == null) {
            PhpUnitUndefinedDataProviderInspection.$$$reportNull$$$0(4);
        }
        if (classFqn == null) {
            return PhpPsiUtil.getParentOfClass(contextElement, PhpClass.class);
        }
        return resolvedClass != null && !resolvedClass.isInterface() ? resolvedClass : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnitUndefinedDataProviderInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnitUndefinedDataProviderInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doCheck";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProviderTargetClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class PhpCreateDataProviderQuickFix
    extends PsiUpdateModCommandAction<PhpClass> {
        private static final String PHPUNIT_DATA_PROVIDER_QUICK_TEMPLATE = "public function %NAME%() { return ; }";
        private static final String PHPUNIT10_DATA_PROVIDER_QUICK_TEMPLATE = "public static function %NAME%() { return ; }";
        private final String myMethodName;

        protected PhpCreateDataProviderQuickFix(@NotNull PhpClass phpClass, String methodName) {
            if (phpClass == null) {
                PhpCreateDataProviderQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)phpClass);
            this.myMethodName = methodName;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.create.data.provider.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PhpCreateDataProviderQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpClass phpClass, @NotNull ModPsiUpdater updater) {
            PsiElement createdMethod;
            Method alreadyExistingMethod;
            if (context == null) {
                PhpCreateDataProviderQuickFix.$$$reportNull$$$0(2);
            }
            if (phpClass == null) {
                PhpCreateDataProviderQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpCreateDataProviderQuickFix.$$$reportNull$$$0(4);
            }
            if ((alreadyExistingMethod = phpClass.findOwnMethodByName((CharSequence)this.myMethodName)) != null) {
                PhpCreateDataProviderQuickFix.focusOnMethod((PsiElement)alreadyExistingMethod, updater);
                return;
            }
            Method newMethod = PhpCreateDataProviderQuickFix.createProviderMethod((Pair<String, String>)Pair.create((Object)phpClass.getFQN(), (Object)this.myMethodName), phpClass);
            PsiElement psiElement = createdMethod = newMethod != null ? PhpCodeEditUtil.insertClassMember(phpClass, (PsiElement)newMethod) : null;
            if (createdMethod != null) {
                PhpCreateDataProviderQuickFix.focusOnMethod(createdMethod, updater);
            }
        }

        private static void focusOnMethod(@NotNull PsiElement method, @NotNull ModPsiUpdater updater) {
            PhpReturn phpReturn;
            if (method == null) {
                PhpCreateDataProviderQuickFix.$$$reportNull$$$0(5);
            }
            if (updater == null) {
                PhpCreateDataProviderQuickFix.$$$reportNull$$$0(6);
            }
            PsiElement returnSemicolon = (phpReturn = (PhpReturn)PsiTreeUtil.findChildOfType((PsiElement)method, PhpReturn.class)) != null ? PhpPsiUtil.getChildOfType((PsiElement)phpReturn, PhpTokenTypes.opSEMICOLON) : null;
            updater.moveCaretTo(returnSemicolon != null ? returnSemicolon : method);
        }

        @Nullable
        private static Method createProviderMethod(Pair<String, String> classFqnAndMethodName, PhpClass providerTargetClass) {
            String template = PhpUnitDeprecatedDataProviderSignatureInspection.atLeastPhpUnit10(providerTargetClass.getProject()) ? PHPUNIT10_DATA_PROVIDER_QUICK_TEMPLATE : PHPUNIT_DATA_PROVIDER_QUICK_TEMPLATE;
            return PhpCodeUtil.createMethodFromTemplate(providerTargetClass, providerTargetClass.getProject(), template.replace("%NAME%", (CharSequence)classFqnAndMethodName.getSecond()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnitUndefinedDataProviderInspection$PhpCreateDataProviderQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnitUndefinedDataProviderInspection$PhpCreateDataProviderQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "focusOnMethod";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

