/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpAddAttributeQuickFixBase;
import com.jetbrains.php.lang.inspections.attributes.PhpAddOverrideAttributeInspectionKt;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\r"}, d2={"Lcom/jetbrains/php/lang/inspections/attributes/PhpAddOverrideAttributeInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "Companion", "intellij.php.impl"})
public final class PhpAddOverrideAttributeInspection
extends PhpInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String OVERRIDE = "\\Override";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPhpMethod(Method method) {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                PsiElement psiElement = method.getNameIdentifier();
                if (psiElement == null) {
                    return;
                }
                PsiElement methodIdentifier = psiElement;
                Collection collection = method.getAttributes("\\Override");
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAttributes(...)");
                if (!collection.isEmpty()) {
                    return;
                }
                if (PhpAddOverrideAttributeInspectionKt.hasSuperMethodToOverride(method)) {
                    Object[] objectArray = new Object[]{method.getName()};
                    String string = PhpBundle.message("inspection.add.override.attribute", objectArray);
                    objectArray = new LocalQuickFix[]{new PhpAddAttributeQuickFixBase("\\Override")};
                    this.$holder.registerProblem(methodIdentifier, string, (LocalQuickFix[])objectArray);
                }
            }
        };
    }

    @Override
    @NotNull
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP830;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/php/lang/inspections/attributes/PhpAddOverrideAttributeInspection$Companion;", "", "<init>", "()V", "OVERRIDE", "", "intellij.php.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

