/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpClassCantBeUsedAsAttributeInspection
extends PhpInspection {
    public static final String ROOT_ATTRIBUTE = "\\Attribute";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpClassCantBeUsedAsAttributeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpAttribute(PhpAttribute attribute) {
                ClassReference reference;
                String fqn = attribute.getFQN();
                if (PhpLangUtil.equalsClassNames(PhpClassCantBeUsedAsAttributeInspection.ROOT_ATTRIBUTE, fqn)) {
                    return;
                }
                Collection classes = PhpIndex.getInstance((Project)holder.getProject()).getAnyByFQN(fqn);
                if (fqn != null && !classes.isEmpty() && classes.stream().noneMatch(c -> PhpClassCantBeUsedAsAttributeInspection.rootAttributes(c).findAny().isPresent()) && (reference = attribute.getClassReference()) != null) {
                    LocalQuickFix[] localQuickFixArray;
                    if (classes.size() == 1) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = new PhpAddRootAttributeQuickFix(fqn);
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    LocalQuickFix[] fixes = localQuickFixArray;
                    holder.registerProblem((PsiElement)reference, PhpBundle.message("inspection.message.class.does.not.have.attribute", reference.getName()), fixes);
                }
            }
        };
    }

    public static Stream<PhpAttribute> rootAttributes(PhpClass phpClass) {
        return phpClass.getAttributes().stream().filter(attr -> PhpLangUtil.equalsClassNames(attr.getFQN(), ROOT_ATTRIBUTE));
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/attributes/PhpClassCantBeUsedAsAttributeInspection", "buildVisitor"));
    }

    private static class PhpAddRootAttributeQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myFqn;

        private PhpAddRootAttributeQuickFix(String fqn) {
            this.myFqn = fqn;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.attribute.attribute", new Object[0]);
            if (string == null) {
                PhpAddRootAttributeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpClass phpClass;
            if (project == null) {
                PhpAddRootAttributeQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpAddRootAttributeQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpAddRootAttributeQuickFix.$$$reportNull$$$0(3);
            }
            if ((phpClass = this.getClass(project)) == null) {
                return;
            }
            phpClass = (PhpClass)updater.getWritable((PsiElement)phpClass);
            PhpAttributesList list = PhpAddRootAttributeQuickFix.createAttributeList(project, phpClass);
            phpClass.addBefore((PsiElement)list, phpClass.getFirstChild());
        }

        private PhpClass getClass(@NotNull Project project) {
            if (project == null) {
                PhpAddRootAttributeQuickFix.$$$reportNull$$$0(4);
            }
            return (PhpClass)ContainerUtil.getFirstItem((Collection)PhpIndex.getInstance((Project)project).getAnyByFQN(this.myFqn));
        }

        @NotNull
        private static PhpAttributesList createAttributeList(@NotNull Project project, PhpClass phpClass) {
            PhpAttributesList list;
            if (project == null) {
                PhpAddRootAttributeQuickFix.$$$reportNull$$$0(5);
            }
            PhpPsiElement scope = (PhpPsiElement)ObjectUtils.notNull((Object)PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)phpClass), (Object)phpClass);
            PhpAttributesList phpAttributesList = list = PhpPsiElementFactory.createAttributesList(project, PhpCodeInsightUtil.createQualifiedName(scope, PhpClassCantBeUsedAsAttributeInspection.ROOT_ATTRIBUTE));
            if (phpAttributesList == null) {
                PhpAddRootAttributeQuickFix.$$$reportNull$$$0(6);
            }
            return phpAttributesList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpClassCantBeUsedAsAttributeInspection$PhpAddRootAttributeQuickFix";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpClassCantBeUsedAsAttributeInspection$PhpAddRootAttributeQuickFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAttributeList";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getClass";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createAttributeList";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

